/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion.insert;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.GenerateDependencyAction;
import org.jetbrains.idea.maven.dom.generate.GenerateManagedDependencyAction;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;

public class MavenTopLevelDependencyInsertionHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new MavenTopLevelDependencyInsertionHandler();

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            MavenTopLevelDependencyInsertionHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            MavenTopLevelDependencyInsertionHandler.$$$reportNull$$$0(1);
        }
        if (TemplateManager.getInstance((Project)context.getProject()).getActiveTemplate(context.getEditor()) != null) {
            return;
        }
        Object object = item.getObject();
        if (!(object instanceof MavenRepositoryArtifactInfo)) {
            return;
        }
        MavenRepositoryArtifactInfo completionItem = (MavenRepositoryArtifactInfo)object;
        PsiFile contextFile = context.getFile();
        if (!(contextFile instanceof XmlFile)) {
            return;
        }
        Project project = context.getProject();
        MavenDomProjectModel model2 = MavenDomUtil.getMavenDomModel(contextFile, MavenDomProjectModel.class);
        if (model2 == null) {
            return;
        }
        Map<DependencyConflictId, MavenDomDependency> managedDependencies = GenerateManagedDependencyAction.collectManagingDependencies(model2);
        PsiElement element = contextFile.findElementAt(context.getStartOffset());
        if (!(element instanceof XmlText) && (element = PsiTreeUtil.getParentOfType((PsiElement)element, XmlText.class)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        MavenDomDependency dependency = GenerateDependencyAction.createDependency(model2, context.getEditor(), managedDependencies, Collections.singletonList(completionItem));
        element.delete();
        if (dependency != null && dependency.getXmlTag() != null) {
            context.getEditor().getCaretModel().moveToOffset(dependency.getXmlTag().getTextOffset());
        }
        context.commitDocument();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/dom/model/completion/insert/MavenTopLevelDependencyInsertionHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

