/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.impl.TrustChangeNotifier;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenDisposable;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.DummyMavenServerConnector;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerConnectorImpl;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenServerManager
implements Disposable {
    public static final String BUNDLED_MAVEN_2 = "Bundled (Maven 2)";
    public static final String BUNDLED_MAVEN_3 = "Bundled (Maven 3)";
    private final Map<Project, MavenServerConnector> myServerConnectors = new HashMap<Project, MavenServerConnector>();
    private File eventListenerJar;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnector(MavenServerConnector serverConnector) {
        Map<Project, MavenServerConnector> map = this.myServerConnectors;
        synchronized (map) {
            this.myServerConnectors.values().remove(serverConnector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownServer(Project project) {
        MavenServerConnector connector;
        Map<Project, MavenServerConnector> map = this.myServerConnectors;
        synchronized (map) {
            connector = this.myServerConnectors.get(project);
        }
        if (connector != null) {
            connector.shutdown(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MavenServerConnector> getAllConnectors() {
        Map<Project, MavenServerConnector> map = this.myServerConnectors;
        synchronized (map) {
            return new ArrayList<MavenServerConnector>(this.myServerConnectors.values());
        }
    }

    public static MavenServerManager getInstance() {
        return (MavenServerManager)ApplicationManager.getApplication().getService(MavenServerManager.class);
    }

    public MavenServerManager() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                ProgressManager.getInstance().run((Task)new Task.Modal(null, RunnerBundle.message("maven.server.shutdown", new Object[0]), false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        MavenServerManager.this.shutdown(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/server/MavenServerManager$1$1", "run"));
                    }
                });
            }
        });
        connection.subscribe(TrustChangeNotifier.TOPIC, (Object)new TrustChangeNotifier(){

            public void projectTrusted(@NotNull Project project) {
                MavenProjectsManager manager;
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((manager = MavenProjectsManager.getInstance(project)).isMavenizedProject()) {
                    MavenUtil.restartMavenConnectors(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/server/MavenServerManager$2", "projectTrusted"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenServerConnector getConnector(@NotNull Project project) {
        if (project == null) {
            MavenServerManager.$$$reportNull$$$0(0);
        }
        MavenWorkspaceSettings settings = MavenWorkspaceSettingsComponent.getInstance(project).getSettings();
        Sdk jdk = MavenServerManager.getJdk(project, settings);
        Map<Project, MavenServerConnector> map = this.myServerConnectors;
        synchronized (map) {
            MavenServerConnector connector = this.myServerConnectors.get(project);
            if (connector == null) {
                return this.registerNewConnector(project, settings, jdk);
            }
            if (!MavenServerManager.compatibleParameters(project, connector, jdk, settings)) {
                connector.shutdown(false);
                return this.registerNewConnector(project, settings, jdk);
            }
            return connector;
        }
    }

    private MavenServerConnector registerNewConnector(Project project, MavenWorkspaceSettings settings, Sdk jdk) {
        Integer debugPort = MavenServerManager.getDebugPort(project);
        if (MavenUtil.isProjectTrustedEnoughToImport(project, false)) {
            MavenLog.LOG.info("Creating new maven connector for " + project + " in");
            MavenServerConnectorImpl connector = new MavenServerConnectorImpl(project, this, settings, jdk, debugPort);
            this.myServerConnectors.put(project, connector);
            return connector;
        }
        MavenLog.LOG.warn("Project " + project + " not trusted enough. Will not start maven for it");
        DummyMavenServerConnector connector = new DummyMavenServerConnector(project, this, jdk, "", MavenServerManager.resolveEmbeddedMavenHome());
        Disposer.register((Disposable)MavenDisposable.getInstance(project), (Disposable)connector);
        return connector;
    }

    private static Integer getDebugPort(Project project) {
        if (project.isDefault() && Registry.is((String)"maven.server.debug.default") || Registry.is((String)"maven.server.debug")) {
            try {
                return NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                MavenLog.LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private static Sdk getJdk(Project project, MavenWorkspaceSettings settings) {
        Sdk sdk;
        String jdkForImporterName = settings.importingSettings.getJdkForImporter();
        try {
            sdk = MavenUtil.getJdk(project, jdkForImporterName);
        }
        catch (ExternalSystemJdkException e) {
            Sdk jdk = MavenUtil.getJdk(project, "#USE_PROJECT_JDK");
            MavenProjectsManager.getInstance(project).getSyncConsole().addWarning(SyncBundle.message("importing.jdk.changed", new Object[0]), SyncBundle.message("importing.jdk.changed.description", jdkForImporterName, jdk.getName()));
            Sdk sdk2 = jdk;
            if (sdk2 == null) {
                MavenServerManager.$$$reportNull$$$0(2);
            }
            return sdk2;
        }
        if (sdk == null) {
            MavenServerManager.$$$reportNull$$$0(1);
        }
        return sdk;
    }

    private static boolean compatibleParameters(@NotNull Project project, MavenServerConnector connector, Sdk jdk, MavenWorkspaceSettings settings) {
        if (project == null) {
            MavenServerManager.$$$reportNull$$$0(3);
        }
        if (!StringUtil.equals((CharSequence)connector.getJdk().getName(), (CharSequence)jdk.getName())) {
            return false;
        }
        return connector.isSettingsStillValid(settings);
    }

    public MavenServerConnector getDefaultConnector() {
        return this.getConnector(ProjectManager.getInstance().getDefaultProject());
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean wait) {
        ArrayList<MavenServerConnector> values;
        Map<Project, MavenServerConnector> map = this.myServerConnectors;
        synchronized (map) {
            values = new ArrayList<MavenServerConnector>(this.myServerConnectors.values());
        }
        values.forEach(c -> c.shutdown(wait));
    }

    public static boolean verifyMavenSdkRequirements(@NotNull Sdk jdk, String mavenVersion) {
        if (jdk == null) {
            MavenServerManager.$$$reportNull$$$0(4);
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        return StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.3.1") < 0 || StringUtil.compareVersionNumbers((String)version, (String)"1.7") >= 0;
    }

    public static File getMavenEventListener() {
        return MavenServerManager.getInstance().getEventListenerJar();
    }

    private File getEventListenerJar() {
        if (this.eventListenerJar != null) {
            return this.eventListenerJar;
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        this.eventListenerJar = pluginFileOrDir.isDirectory() ? MavenServerManager.getEventSpyPathForLocalBuild() : new File(root, "maven-event-listener.jar");
        if (!this.eventListenerJar.exists()) {
            if (ApplicationManager.getApplication().isInternal()) {
                MavenLog.LOG.warn("Event listener does not exist: Please run rebuild for maven modules:\ncommunity/plugins/maven/maven-event-listener\nand all maven*-server* modules");
            } else {
                MavenLog.LOG.warn("Event listener does not exist " + this.eventListenerJar);
            }
        }
        return this.eventListenerJar;
    }

    private static File getEventSpyPathForLocalBuild() {
        File root = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        return new File(root.getParent(), "intellij.maven.server.eventListener");
    }

    @Nullable
    public String getMavenVersion(@Nullable String mavenHome) {
        return MavenUtil.getMavenVersion(MavenServerManager.getMavenHomeFile(mavenHome));
    }

    @Nullable
    public String getMavenVersion(@Nullable File mavenHome) {
        return MavenUtil.getMavenVersion(mavenHome);
    }

    @Deprecated
    @Nullable
    public String getCurrentMavenVersion() {
        return null;
    }

    public static List<File> collectClassPathAndLibsFolder(@NotNull String mavenVersion, @NotNull File mavenHome) {
        if (mavenVersion == null) {
            MavenServerManager.$$$reportNull$$$0(5);
        }
        if (mavenHome == null) {
            MavenServerManager.$$$reportNull$$$0(6);
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        ArrayList<File> classpath = new ArrayList<File>();
        if (pluginFileOrDir.isDirectory()) {
            MavenServerManager.prepareClassPathForLocalRunAndUnitTests(mavenVersion, classpath, root);
        } else {
            MavenServerManager.prepareClassPathForProduction(mavenVersion, classpath, root);
        }
        MavenServerManager.addMavenLibs(classpath, mavenHome);
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        return classpath;
    }

    private static void prepareClassPathForProduction(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            MavenServerManager.$$$reportNull$$$0(7);
        }
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(root, "maven-server-api.jar"));
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3") < 0) {
            classpath.add(new File(root, "maven2-server-impl.jar"));
            MavenServerManager.addDir(classpath, new File(root, "maven2-server-lib"), f -> true);
        } else {
            classpath.add(new File(root, "maven3-server-common.jar"));
            MavenServerManager.addDir(classpath, new File(root, "maven3-server-lib"), f -> true);
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
                classpath.add(new File(root, "maven30-server-impl.jar"));
            } else {
                classpath.add(new File(root, "maven3-server-impl.jar"));
                if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
                    classpath.add(new File(root, "maven36-server-impl.jar"));
                }
            }
        }
    }

    private static void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            MavenServerManager.$$$reportNull$$$0(8);
        }
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(root, "intellij.maven.server"));
        File parentFile = MavenServerManager.getMavenPluginParentFile();
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3") < 0) {
            classpath.add(new File(root, "intellij.maven.server.m2.impl"));
            MavenServerManager.addDir(classpath, new File(parentFile, "maven2-server-impl/lib"), f -> true);
        } else {
            classpath.add(new File(root, "intellij.maven.server.m3.common"));
            MavenServerManager.addDir(classpath, new File(parentFile, "maven3-server-common/lib"), f -> true);
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
                classpath.add(new File(root, "intellij.maven.server.m30.impl"));
            } else {
                classpath.add(new File(root, "intellij.maven.server.m3.impl"));
                if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
                    classpath.add(new File(root, "intellij.maven.server.m36.impl"));
                }
            }
        }
    }

    private static File getMavenPluginParentFile() {
        File luceneLib = new File(PathUtil.getJarPathForClass(Query.class));
        return luceneLib.getParentFile().getParentFile().getParentFile();
    }

    private static void addMavenLibs(List<File> classpath, File mavenHome) {
        MavenServerManager.addDir(classpath, new File(mavenHome, "lib"), f -> !f.getName().contains("maven-slf4j-provider"));
        File bootFolder = new File(mavenHome, "boot");
        File[] classworldsJars = bootFolder.listFiles((dir, name) -> StringUtil.contains((CharSequence)name, (CharSequence)"classworlds"));
        if (classworldsJars != null) {
            Collections.addAll(classpath, classworldsJars);
        }
    }

    private static void addDir(List<File> classpath, File dir, Predicate<File> filter) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File jar : files) {
            if (!jar.isFile() || !jar.getName().endsWith(".jar") || !filter.test(jar)) continue;
            classpath.add(jar);
        }
    }

    public MavenEmbedderWrapper createEmbedder(final Project project, final boolean alwaysOnline, final @Nullable String workingDirectory, final @Nullable String multiModuleProjectDirectory) {
        return new MavenEmbedderWrapper(null){

            @Override
            @NotNull
            protected MavenServerEmbedder create() throws RemoteException {
                MavenServerSettings settings = MavenServerManager.convertSettings(MavenProjectsManager.getInstance(project).getGeneralSettings());
                if (alwaysOnline && settings.isOffline()) {
                    settings = settings.clone();
                    settings.setOffline(false);
                }
                settings.setProjectJdk(MavenUtil.getSdkPath(ProjectRootManager.getInstance((Project)project).getProjectSdk()));
                MavenServerEmbedder mavenServerEmbedder = MavenServerManager.this.getConnector(project).createEmbedder(new MavenEmbedderSettings(settings, workingDirectory, multiModuleProjectDirectory));
                if (mavenServerEmbedder == null) {
                    3.$$$reportNull$$$0(0);
                }
                return mavenServerEmbedder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$3", "create"));
            }
        };
    }

    public MavenIndexerWrapper createIndexer() {
        return new MavenIndexerWrapper(null){

            @Override
            @NotNull
            protected MavenServerIndexer create() throws RemoteException {
                MavenServerIndexer mavenServerIndexer = MavenServerManager.this.getDefaultConnector().createIndexer();
                if (mavenServerIndexer == null) {
                    4.$$$reportNull$$$0(0);
                }
                return mavenServerIndexer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$4", "create"));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadListener(MavenServerDownloadListener listener2) {
        Map<Project, MavenServerConnector> map = this.myServerConnectors;
        synchronized (map) {
            this.myServerConnectors.values().forEach(l -> l.addDownloadListener(listener2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadListener(MavenServerDownloadListener listener2) {
        Map<Project, MavenServerConnector> map = this.myServerConnectors;
        synchronized (map) {
            this.myServerConnectors.values().forEach(l -> l.removeDownloadListener(listener2));
        }
    }

    public static MavenServerSettings convertSettings(MavenGeneralSettings settings) {
        MavenServerSettings result = new MavenServerSettings();
        result.setLoggingLevel(settings.getOutputLevel().getLevel());
        result.setOffline(settings.isWorkOffline());
        result.setMavenHome(settings.getEffectiveMavenHome());
        result.setUserSettingsFile(settings.getEffectiveUserSettingsIoFile());
        result.setGlobalSettingsFile(settings.getEffectiveGlobalSettingsIoFile());
        result.setLocalRepository(settings.getEffectiveLocalRepository());
        result.setPluginUpdatePolicy(settings.getPluginUpdatePolicy().getServerPolicy());
        result.setSnapshotUpdatePolicy(settings.isAlwaysUpdateSnapshots() ? MavenServerSettings.UpdatePolicy.ALWAYS_UPDATE : MavenServerSettings.UpdatePolicy.DO_NOT_UPDATE);
        return result;
    }

    public boolean isUseMaven2() {
        String version = this.getCurrentMavenVersion();
        return version != null && StringUtil.compareVersionNumbers((String)version, (String)"3") < 0 && StringUtil.compareVersionNumbers((String)version, (String)"2") >= 0;
    }

    @Nullable
    public static File getMavenHomeFile(@Nullable String mavenHome) {
        if (mavenHome == null) {
            return null;
        }
        if (StringUtil.equals((CharSequence)BUNDLED_MAVEN_2, (CharSequence)mavenHome) && ApplicationManager.getApplication().isUnitTestMode()) {
            return MavenServerManager.resolveEmbeddedMaven2HomeForTests().getMavenHome();
        }
        if (StringUtil.equals((CharSequence)BUNDLED_MAVEN_3, (CharSequence)mavenHome) || StringUtil.equals((CharSequence)MavenProjectBundle.message("maven.bundled.version.title", new Object[0]), (CharSequence)mavenHome)) {
            return MavenServerManager.resolveEmbeddedMavenHome().getMavenHome();
        }
        File home = new File(mavenHome);
        return MavenUtil.isValidMavenHome(home) ? home : null;
    }

    @Deprecated
    @NotNull
    public String getMavenEmbedderVMOptions() {
        return "";
    }

    @Deprecated
    public void setMavenEmbedderVMOptions(@NotNull String mavenEmbedderVMOptions) {
        if (mavenEmbedderVMOptions == null) {
            MavenServerManager.$$$reportNull$$$0(9);
        }
    }

    @NotNull
    public static MavenDistribution resolveEmbeddedMavenHome() {
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        if (pluginFileOrDir.isDirectory()) {
            File parentFile = MavenServerManager.getMavenPluginParentFile();
            return new MavenDistribution(new File(parentFile, "maven36-server-impl/lib/maven3"), BUNDLED_MAVEN_3);
        }
        return new MavenDistribution(new File(root, "maven3"), BUNDLED_MAVEN_3);
    }

    @NotNull
    private static MavenDistribution resolveEmbeddedMaven2HomeForTests() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("Maven2 is for test purpose only");
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        if (pluginFileOrDir.isDirectory()) {
            File parentFile = MavenServerManager.getMavenPluginParentFile();
            return new MavenDistribution(new File(parentFile, "maven2-server-impl/lib/maven2"), BUNDLED_MAVEN_2);
        }
        throw new IllegalStateException("Maven2 is not bundled anymore, please do not try to use it in tests");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenHome";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenEmbedderVMOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConnector";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compatibleParameters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "verifyMavenSdkRequirements";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForProduction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setMavenEmbedderVMOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

