/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.FilePredictionFeature;
import com.intellij.filePrediction.features.FilePredictionFeatureProvider;
import com.intellij.filePrediction.features.FilePredictionFeaturesCache;
import com.intellij.filePrediction.features.history.FileHistoryFeatures;
import com.intellij.filePrediction.features.history.FilePredictionHistory;
import com.intellij.filePrediction.features.history.NextFileProbability;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\"\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b`\fH\u0002J6\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/filePrediction/features/history/FilePredictionHistoryFeatures;", "Lcom/intellij/filePrediction/features/FilePredictionFeatureProvider;", "()V", "addNGramFeatures", "", "probability", "Lcom/intellij/filePrediction/features/history/NextFileProbability;", "prefix", "", "result", "Ljava/util/HashMap;", "Lcom/intellij/filePrediction/features/FilePredictionFeature;", "Lkotlin/collections/HashMap;", "calculateFileFeatures", "", "project", "Lcom/intellij/openapi/project/Project;", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "prevFile", "cache", "Lcom/intellij/filePrediction/features/FilePredictionFeaturesCache;", "getFeatures", "", "getName", "Companion", "intellij.filePrediction"})
public final class FilePredictionHistoryFeatures
implements FilePredictionFeatureProvider {
    private static final ArrayList<String> FEATURES;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getName() {
        return "history";
    }

    @Override
    @NotNull
    public List<String> getFeatures() {
        return FEATURES;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, FilePredictionFeature> calculateFileFeatures(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable VirtualFile prevFile, @NotNull FilePredictionFeaturesCache cache) {
        void uniGram;
        void position;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        HashMap<String, FilePredictionFeature> result2 = new HashMap<String, FilePredictionFeature>();
        FilePredictionHistory history = FilePredictionHistory.Companion.getInstance(project);
        ((Map)result2).put("size", FilePredictionFeature.Companion.numerical(history.size()));
        String string = newFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newFile.url");
        FileHistoryFeatures fileHistoryFeatures = history.calcHistoryFeatures(string);
        Integer n = fileHistoryFeatures.component1();
        NextFileProbability nextFileProbability = fileHistoryFeatures.component2();
        NextFileProbability biGram = fileHistoryFeatures.component3();
        if (position != null) {
            ((Map)result2).put("position", FilePredictionFeature.Companion.numerical(position.intValue()));
        }
        this.addNGramFeatures((NextFileProbability)uniGram, "uni", result2);
        this.addNGramFeatures(biGram, "bi", result2);
        return result2;
    }

    private final void addNGramFeatures(NextFileProbability probability, String prefix, HashMap<String, FilePredictionFeature> result2) {
        ((Map)result2).put(prefix + "_mle", FilePredictionFeature.Companion.numerical(probability.getMle()));
        ((Map)result2).put(prefix + "_min", FilePredictionFeature.Companion.numerical(probability.getMinMle()));
        ((Map)result2).put(prefix + "_max", FilePredictionFeature.Companion.numerical(probability.getMaxMle()));
        ((Map)result2).put(prefix + "_mle_to_min", FilePredictionFeature.Companion.numerical(probability.getMleToMin()));
        ((Map)result2).put(prefix + "_mle_to_max", FilePredictionFeature.Companion.numerical(probability.getMleToMax()));
    }

    static {
        Companion = new Companion(null);
        FEATURES = CollectionsKt.arrayListOf((Object[])new String[]{"bi_max", "bi_min", "bi_mle", "bi_mle_to_max", "bi_mle_to_min", "position", "size", "uni_max", "uni_min", "uni_mle", "uni_mle_to_max", "uni_mle_to_min"});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/filePrediction/features/history/FilePredictionHistoryFeatures$Companion;", "", "()V", "FEATURES", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "intellij.filePrediction"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

