/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa;

import com.jetbrains.sa.SaJdwpAttachingServer;
import com.jetbrains.sa.SaJdwpListeningServer;
import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class SaJdwp {
    private static final String JDK_HOTSPOT_AGENT = "jdk.hotspot.agent";

    private SaJdwp() {
    }

    private static void usage() {
        System.out.println("Usage: java -jar sa-jdwp.jar <pid> (port)");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            SaJdwp.usage();
        }
        String port = args.length > 1 ? args[1] : "";
        List<String> commands = SaJdwp.getServerProcessCommand(args[0], port, true, SaJdwp.getJarPath());
        try {
            SaJdwp.startServer(commands);
        }
        catch (Exception e) {
            List<String> commandsWithSudo = SaJdwp.createSudoCommand(commands);
            if (((Object)commandsWithSudo).equals(commands)) {
                throw e;
            }
            System.out.println("Trying with sudo...");
            SaJdwp.startServer(commandsWithSudo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getServerProcessCommand(String pidString, String port, boolean server, String pathToJar) throws Exception {
        Properties systemProperties;
        VirtualMachine vm = VirtualMachine.attach(pidString);
        try {
            systemProperties = vm.getSystemProperties();
        }
        finally {
            vm.detach();
        }
        return SaJdwp.getServerProcessCommand(systemProperties, pidString, port, server, pathToJar);
    }

    public static List<String> getServerProcessCommand(Properties systemProperties, String target, String port, boolean server, String pathToJar) throws Exception {
        String javaHome = systemProperties.getProperty("java.home");
        String version = systemProperties.getProperty("java.specification.version");
        ArrayList<String> commands = new ArrayList<String>();
        if (version.startsWith("1.6") || version.startsWith("1.7") || version.startsWith("1.8")) {
            SaJdwp.prepare6(commands, javaHome, pathToJar);
        } else {
            try {
                int v = Integer.parseInt(version);
                if (v >= 9) {
                    SaJdwp.prepare9(commands, javaHome, pathToJar);
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (commands.isEmpty()) {
            throw new IllegalStateException("Unable to start on version " + version);
        }
        String serverClassName = server ? SaJdwpListeningServer.class.getName() : SaJdwpAttachingServer.class.getName();
        Collections.addAll(commands, serverClassName, target, port);
        return commands;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.US).startsWith("windows");
    }

    private static void prepare6(List<String> commands, String javaHome, String pathToJar) throws IOException {
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (!toolsJar.exists() && !(toolsJar = new File(javaHome, "../lib/tools.jar")).exists()) {
            throw new IllegalStateException("JDK not detected, unable to find tools.jar in " + javaHome);
        }
        File saJdiJar = new File(javaHome, "lib/sa-jdi.jar");
        if (!saJdiJar.exists() && !(saJdiJar = new File(javaHome, "../lib/sa-jdi.jar")).exists()) {
            throw new IllegalStateException("JDK not detected, unable to find sa-jdi.jar in " + javaHome);
        }
        Collections.addAll(commands, javaHome + "/bin/java", "-cp", toolsJar.getCanonicalPath() + File.pathSeparatorChar + saJdiJar.getCanonicalPath() + File.pathSeparatorChar + pathToJar);
    }

    private static void prepare9(List<String> commands, String javaHome, String pathToJar) {
        if (!SaJdwp.hasModule(javaHome, JDK_HOTSPOT_AGENT)) {
            throw new IllegalStateException("jdk.hotspot.agent module is not available in JDK in " + javaHome + " , unable to attach");
        }
        Collections.addAll(commands, javaHome + "/bin/java", "--add-modules", JDK_HOTSPOT_AGENT, "--add-exports", "jdk.hotspot.agent/sun.jvm.hotspot=ALL-UNNAMED", "--add-exports", "jdk.hotspot.agent/sun.jvm.hotspot.runtime=ALL-UNNAMED", "--add-exports", "jdk.hotspot.agent/sun.jvm.hotspot.memory=ALL-UNNAMED", "--add-opens", "jdk.hotspot.agent/sun.jvm.hotspot.oops=ALL-UNNAMED", "--add-exports", "jdk.hotspot.agent/sun.jvm.hotspot.utilities=ALL-UNNAMED", "--add-exports", "jdk.hotspot.agent/sun.jvm.hotspot.debugger=ALL-UNNAMED", "--add-exports", "jdk.hotspot.agent/sun.jvm.hotspot.tools.jcore=ALL-UNNAMED", "--add-exports", "jdk.hotspot.agent/sun.jvm.hotspot.classfile=ALL-UNNAMED", "-cp", pathToJar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasModule(String javaHome, String moduleName) {
        File releaseFile = new File(javaHome, "release");
        if (releaseFile.isFile()) {
            boolean bl;
            FileInputStream stream = new FileInputStream(releaseFile);
            try {
                Properties p = new Properties();
                p.load(stream);
                bl = p.getProperty("MODULES").contains(moduleName);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stream.close();
            return bl;
        }
        return false;
    }

    private static String getJarPath() {
        String path = "/" + SaJdwp.class.getName().replace('.', '/') + ".class";
        String classResource = SaJdwp.class.getResource(path).getFile();
        String jarPath = classResource.startsWith("file:") ? classResource.substring(5, classResource.length() - path.length() - 1) : "build/libs/sa-jdwp.jar";
        return new File(jarPath).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startServer(List<String> cmds) throws Exception {
        System.out.println("Running: ");
        for (String s : cmds) {
            System.out.print(s + " ");
        }
        System.out.println();
        ProcessBuilder builder = new ProcessBuilder(cmds);
        builder.redirectErrorStream(true);
        final Process process = builder.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                process.destroy();
            }
        }));
        boolean success = false;
        BufferedReader stdOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            String s;
            while ((s = stdOutput.readLine()) != null) {
                System.out.println(s);
                if (!s.startsWith("Waiting for debugger on: ") && !s.startsWith("sa-jdwp server connected")) continue;
                success = true;
            }
        }
        finally {
            stdOutput.close();
        }
        if (!success) {
            throw new IllegalStateException("Unable to start");
        }
    }

    private static List<String> createSudoCommand(List<String> command) {
        if (SaJdwp.isWindows()) {
            return command;
        }
        ArrayList<String> res = new ArrayList<String>(command.size() + 1);
        res.add("sudo");
        res.add("--");
        res.addAll(command);
        return res;
    }
}

