/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateLogger;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixLiveTemplate
extends CustomLiveTemplateBase {
    @NonNls
    public static final String POSTFIX_TEMPLATE_ID = "POSTFIX_TEMPLATE_ID";
    private static final Logger LOG = Logger.getInstance(PostfixLiveTemplate.class);

    public @NotNull Set<@NlsSafe String> getAllTemplateKeys(PsiFile file2, int offset) {
        HashSet<String> keys2 = new HashSet<String>();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            ProgressManager.checkCanceled();
            keys2.addAll(PostfixLiveTemplate.getKeys(provider2));
        }
        HashSet<String> hashSet = keys2;
        if (hashSet == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Nullable
    @NlsSafe
    private static String computeTemplateKeyWithoutContextChecking(@NotNull PostfixTemplateProvider provider2, @NotNull CharSequence documentContent, int currentOffset) {
        int startOffset;
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(1);
        }
        if (documentContent == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(2);
        }
        if (documentContent.length() < startOffset) {
            return null;
        }
        for (startOffset = currentOffset; startOffset > 0; --startOffset) {
            ProgressManager.checkCanceled();
            char currentChar = documentContent.charAt(startOffset - 1);
            if (Character.isJavaIdentifierPart(currentChar)) continue;
            if (!provider2.isTerminalSymbol(currentChar)) {
                return null;
            }
            --startOffset;
            break;
        }
        return String.valueOf(documentContent.subSequence(startOffset, currentOffset));
    }

    @Override
    @Nullable
    @NlsSafe
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback2) {
        if (callback2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(3);
        }
        Editor editor = callback2.getEditor();
        CharSequence charsSequence = editor.getDocument().getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback2))) {
            String key = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider2, charsSequence, offset);
            if (key == null || !PostfixLiveTemplate.isApplicableTemplate(provider2, key, callback2.getFile(), editor)) continue;
            return key;
        }
        return null;
    }

    @Override
    @Nullable
    @NlsSafe
    public String computeTemplateKeyWithoutContextChecking(@NotNull CustomTemplateCallback callback2) {
        if (callback2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(4);
        }
        Editor editor = callback2.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback2))) {
            ProgressManager.checkCanceled();
            String key = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider2, editor.getDocument().getCharsSequence(), currentOffset);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    @Override
    public boolean supportsMultiCaret() {
        return false;
    }

    @Override
    public void expand(@NotNull String key, @NotNull CustomTemplateCallback callback2) {
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(5);
        }
        if (callback2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor = callback2.getEditor();
        PsiFile file2 = callback2.getContext().getContainingFile();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback2))) {
            PostfixTemplate postfixTemplate = PostfixLiveTemplate.findApplicableTemplate(provider2, key, editor, file2);
            if (postfixTemplate == null) continue;
            PostfixLiveTemplate.expandTemplate(key, callback2, editor, provider2, postfixTemplate);
            return;
        }
        if (editor.getCaretModel().getAllCarets().size() == 1) {
            LOG.error("Template not found by key: " + key + "; offset = " + callback2.getOffset(), new Attachment[]{AttachmentFactory.createAttachment(callback2.getFile().getVirtualFile())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandTemplate(@NotNull String key, @NotNull CustomTemplateCallback callback2, @NotNull Editor editor, @NotNull PostfixTemplateProvider provider2, @NotNull PostfixTemplate postfixTemplate) {
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(7);
        }
        if (callback2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(9);
        }
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(10);
        }
        if (postfixTemplate == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.postfix");
        PsiFile file2 = callback2.getContext().getContainingFile();
        if (PostfixLiveTemplate.isApplicableTemplate(provider2, key, file2, editor, postfixTemplate)) {
            int offset = PostfixLiveTemplate.deleteTemplateKey(file2, editor, key);
            try {
                provider2.preExpand(file2, editor);
                PsiElement context = CustomTemplateCallback.getContext(file2, PostfixLiveTemplate.positiveOffset(offset));
                PostfixLiveTemplate.expandTemplate(postfixTemplate, editor, context);
            }
            finally {
                provider2.afterExpand(file2, editor);
            }
        } else if (editor.getCaretModel().getAllCarets().size() == 1) {
            LOG.error("Template not found by key: " + key + "; offset = " + callback2.getOffset(), new Attachment[]{AttachmentFactory.createAttachment(callback2.getFile().getVirtualFile())});
        }
    }

    @Override
    public boolean isApplicable(@NotNull CustomTemplateCallback callback2, int offset, boolean wrapping) {
        if (callback2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(12);
        }
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        if (wrapping || !settings.isPostfixTemplatesEnabled()) {
            return false;
        }
        PsiFile contextFile = callback2.getFile();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)contextFile, (int)offset);
        CharSequence fileText = callback2.getEditor().getDocument().getImmutableCharSequence();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            if (!StringUtil.isNotEmpty((String)PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider2, fileText, offset + 1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsWrapping() {
        return false;
    }

    @Override
    public void wrap(@NotNull String selection, @NotNull CustomTemplateCallback callback2) {
        if (selection == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(13);
        }
        if (callback2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    @NlsActions.ActionText
    public String getTitle() {
        String string = CodeInsightBundle.message((String)"postfix.live.template.title", (Object[])new Object[0]);
        if (string == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public char getShortcut() {
        return (char)PostfixTemplatesSettings.getInstance().getShortcut();
    }

    @Override
    public boolean hasCompletionItem(@NotNull CustomTemplateCallback callback2, int offset) {
        if (callback2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(16);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<? extends CustomLiveTemplateLookupElement> getLookupElements(@NotNull PsiFile file2, @NotNull Editor editor, int offset) {
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(18);
        }
        HashSet<PostfixTemplateLookupElement> result2 = new HashSet<PostfixTemplateLookupElement>();
        CustomTemplateCallback callback2 = new CustomTemplateCallback(editor, file2);
        Disposable parentDisposable = Disposer.newDisposable();
        try {
            for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback2))) {
                ProgressManager.checkCanceled();
                String key = this.computeTemplateKeyWithoutContextChecking(callback2);
                if (key == null || editor.getCaretModel().getCaretCount() != 1) continue;
                Condition<PostfixTemplate> isApplicationTemplateFunction = PostfixLiveTemplate.createIsApplicationTemplateFunction(provider2, key, file2, editor, parentDisposable);
                for (PostfixTemplate postfixTemplate : PostfixTemplatesUtils.getAvailableTemplates(provider2)) {
                    ProgressManager.checkCanceled();
                    if (!isApplicationTemplateFunction.value((Object)postfixTemplate)) continue;
                    result2.add(new PostfixTemplateLookupElement(this, postfixTemplate, postfixTemplate.getKey(), provider2, false));
                }
            }
        }
        finally {
            Disposer.dispose((Disposable)parentDisposable);
        }
        HashSet<PostfixTemplateLookupElement> hashSet = result2;
        if (hashSet == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    private static void expandTemplate(@NotNull PostfixTemplate template, @NotNull Editor editor, @NotNull PsiElement context) {
        if (template == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(21);
        }
        if (context == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(22);
        }
        PostfixTemplateLogger.log(template, context);
        if (template.startInWriteAction()) {
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(context.getProject(), () -> template.expand(context, editor), CodeInsightBundle.message((String)"command.expand.postfix.template", (Object[])new Object[0]), (Object)POSTFIX_TEMPLATE_ID));
        } else {
            template.expand(context, editor);
        }
    }

    private static int deleteTemplateKey(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull String key) {
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(24);
        }
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int currentOffset = editor.getCaretModel().getOffset();
        int newOffset = currentOffset - key.length();
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            Document document = editor.getDocument();
            document.deleteString(newOffset, currentOffset);
            editor.getCaretModel().moveToOffset(newOffset);
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
        }));
        return newOffset;
    }

    private static Condition<PostfixTemplate> createIsApplicationTemplateFunction(@NotNull PostfixTemplateProvider provider2, @NotNull String key, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Disposable parentDisposable) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(26);
        }
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(28);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(29);
        }
        if (parentDisposable == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(30);
        }
        if (file2.getFileType().isBinary()) {
            return Conditions.alwaysFalse();
        }
        int currentOffset = editor.getCaretModel().getOffset();
        int newOffset = currentOffset - key.length();
        CharSequence fileContent = editor.getDocument().getCharsSequence();
        StringBuilder fileContentWithoutKey = new StringBuilder();
        fileContentWithoutKey.append(fileContent.subSequence(0, newOffset));
        fileContentWithoutKey.append(fileContent.subSequence(currentOffset, fileContent.length()));
        PsiFile copyFile = PostfixLiveTemplate.copyFile(file2, fileContentWithoutKey);
        Document copyDocument = copyFile.getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        copyDocument = (copyFile = provider2.preCheck(copyFile, editor, newOffset)).getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        Document fileDocument = file2.getViewProvider().getDocument();
        if (fileDocument != null && fileDocument.getTextLength() < currentOffset) {
            LOG.error("File document length (" + fileDocument.getTextLength() + ") is less than offset (" + currentOffset + ")", new Attachment[]{AttachmentFactory.createAttachment(fileDocument), AttachmentFactory.createAttachment(editor.getDocument())});
        }
        Document originalDocument = editor.getDocument();
        OffsetTranslator translator = new OffsetTranslator(originalDocument, file2, copyDocument, newOffset, currentOffset, "");
        Disposer.register((Disposable)parentDisposable, (Disposable)translator);
        PsiElement context = CustomTemplateCallback.getContext(copyFile, PostfixLiveTemplate.positiveOffset(newOffset));
        Document finalCopyDocument = copyDocument;
        return template -> template != null && PostfixLiveTemplate.isDumbEnough(template, context) && template.isEnabled(provider2) && template.isApplicable(context, finalCopyDocument, newOffset);
    }

    private static boolean isDumbEnough(@NotNull PostfixTemplate template, @NotNull PsiElement context) {
        DumbService dumbService;
        if (template == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(32);
        }
        return !(dumbService = DumbService.getInstance((Project)context.getProject())).isDumb() || DumbService.isDumbAware((Object)template);
    }

    @NotNull
    public static PsiFile copyFile(@NotNull PsiFile file2, @NotNull StringBuilder fileContentWithoutKey) {
        VirtualFile vFile;
        PsiFile copy2;
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(33);
        }
        if (fileContentWithoutKey == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(34);
        }
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)file2.getProject());
        Language language = LanguageUtil.getLanguageForPsi((Project)file2.getProject(), (VirtualFile)file2.getVirtualFile());
        PsiFile psiFile = copy2 = language != null ? psiFileFactory.createFileFromText(file2.getName(), language, (CharSequence)fileContentWithoutKey, false, true) : psiFileFactory.createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)fileContentWithoutKey);
        if (copy2 instanceof PsiFileImpl) {
            ((PsiFileImpl)copy2).setOriginalFile(TemplateLanguageUtil.getBaseFile((PsiFile)file2));
        }
        if ((vFile = copy2.getVirtualFile()) != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        PsiFile psiFile2 = copy2;
        if (psiFile2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(35);
        }
        return psiFile2;
    }

    public static boolean isApplicableTemplate(@NotNull PostfixTemplateProvider provider2, @NotNull String key, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(36);
        }
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(38);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(39);
        }
        return PostfixLiveTemplate.findApplicableTemplate(provider2, key, editor, file2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isApplicableTemplate(@NotNull PostfixTemplateProvider provider2, @NotNull String key, @NotNull PsiFile file2, @NotNull Editor editor, @Nullable PostfixTemplate template) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(40);
        }
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(41);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(42);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(43);
        }
        Disposable parentDisposable = Disposer.newDisposable();
        try {
            boolean bl = PostfixLiveTemplate.createIsApplicationTemplateFunction(provider2, key, file2, editor, parentDisposable).value((Object)template);
            return bl;
        }
        finally {
            Disposer.dispose((Disposable)parentDisposable);
        }
    }

    @NotNull
    private static Set<String> getKeys(@NotNull PostfixTemplateProvider provider2) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(44);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (PostfixTemplate template : PostfixTemplatesUtils.getAvailableTemplates(provider2)) {
            result2.add(template.getKey());
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(45);
        }
        return hashSet;
    }

    @Nullable
    private static PostfixTemplate findApplicableTemplate(@NotNull PostfixTemplateProvider provider2, @Nullable String key, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(46);
        }
        if (editor == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(47);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(48);
        }
        for (PostfixTemplate template : PostfixTemplatesUtils.getAvailableTemplates(provider2)) {
            if (!template.getKey().equals(key) || !PostfixLiveTemplate.isApplicableTemplate(provider2, key, file2, editor, template)) continue;
            return template;
        }
        return null;
    }

    private static Language getLanguage(@NotNull CustomTemplateCallback callback2) {
        if (callback2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(49);
        }
        return PsiUtilCore.getLanguageAtOffset((PsiFile)callback2.getFile(), (int)callback2.getOffset());
    }

    private static int positiveOffset(int offset) {
        return offset > 0 ? offset - 1 : offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate";
                break;
            }
            case 1: 
            case 10: 
            case 26: 
            case 36: 
            case 40: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentContent";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: 
            case 7: 
            case 25: 
            case 27: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 39: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixTemplate";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 17: 
            case 23: 
            case 28: 
            case 33: 
            case 38: 
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentWithoutKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplateKeys";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKeyWithoutContextChecking";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKey";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "expandTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasCompletionItem";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteTemplateKey";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createIsApplicationTemplateFunction";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDumbEnough";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTemplate";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getKeys";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableTemplate";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

