/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.console.IdeConsoleRootType;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.script.IdeConsoleScriptBindings;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunIdeConsoleAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(RunIdeConsoleAction.class);
    private static final String DEFAULT_FILE_NAME = "ide-scripting";
    private static final Key<IdeScriptEngineManager.EngineInfo> SELECTED_ENGINE_INFO_KEY = Key.create((String)"SELECTED_ENGINE_INFO_KEY");
    private static final Key<Trinity<IdeScriptEngine, IdeScriptEngineManager.EngineInfo, VirtualFile>> SCRIPT_ENGINE_KEY = Key.create((String)"SCRIPT_ENGINE_KEY");

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(0);
        }
        IdeScriptEngineManager manager2 = IdeScriptEngineManager.getInstance();
        e.getPresentation().setVisible(e.getProject() != null);
        e.getPresentation().setEnabled(manager2.isInitialized() && !manager2.getEngineInfos().isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List<IdeScriptEngineManager.EngineInfo> infos = IdeScriptEngineManager.getInstance().getEngineInfos();
        RunIdeConsoleAction.chooseScriptEngineAndRun(e, infos, (Consumer<? super IdeScriptEngineManager.EngineInfo>)((Consumer)engineInfo -> this.runConsole(project, (IdeScriptEngineManager.EngineInfo)engineInfo)));
    }

    static void chooseScriptEngineAndRun(@NotNull AnActionEvent e, @NotNull List<IdeScriptEngineManager.EngineInfo> infos, @NotNull Consumer<? super IdeScriptEngineManager.EngineInfo> onChosen) {
        if (e == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(2);
        }
        if (infos == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(3);
        }
        if (onChosen == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(4);
        }
        if (infos.size() == 1) {
            onChosen.consume((Object)infos.iterator().next());
            return;
        }
        List actions = JBIterable.from(infos).map(engineInfo -> {
            String lang = engineInfo.languageName;
            String eng = engineInfo.engineName;
            if (StringUtil.toLowerCase((String)lang).equals(lang)) {
                lang = StringUtil.capitalize((String)lang);
            }
            if (StringUtil.toLowerCase((String)eng).equals(eng)) {
                eng = StringUtil.capitalize((String)eng);
            }
            String name = lang + " (" + eng + ")";
            PluginDescriptor plugin2 = engineInfo.plugin;
            String description = LangBundle.message((String)"action.engine.description", (Object[])new Object[]{lang, eng, plugin2 == null ? "" : LangBundle.message((String)"action.plugin.description", (Object[])new Object[0]) + plugin2.getName()});
            return new DumbAwareAction(name, description, null, (Consumer)onChosen, (IdeScriptEngineManager.EngineInfo)engineInfo){
                final /* synthetic */ Consumer val$onChosen;
                final /* synthetic */ IdeScriptEngineManager.EngineInfo val$engineInfo;
                {
                    this.val$onChosen = consumer2;
                    this.val$engineInfo = engineInfo;
                    super(arg0, arg1, arg2);
                }

                public void actionPerformed(@NotNull AnActionEvent e1) {
                    if (e1 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.val$onChosen.consume((Object)this.val$engineInfo);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/execution/console/RunIdeConsoleAction$1", "actionPerformed"));
                }
            };
        }).sort(Comparator.comparing(o -> o.getTemplatePresentation().getText())).toList();
        DefaultActionGroup actionGroup = new DefaultActionGroup(actions);
        JBPopupFactory.getInstance().createActionGroupPopup(ExecutionBundle.message((String)"popup.title.script.engine", (Object[])new Object[0]), (ActionGroup)actionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false).showInBestPositionFor(e.getDataContext());
    }

    protected void runConsole(@NotNull Project project, @NotNull IdeScriptEngineManager.EngineInfo info) {
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(5);
        }
        if (info == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(6);
        }
        List<String> extensions2 = info.fileExtensions;
        try {
            String pathName = PathUtil.makeFileName((String)DEFAULT_FILE_NAME, (String)((String)ContainerUtil.getFirstItem(extensions2)));
            VirtualFile virtualFile = IdeConsoleRootType.getInstance().findFile(project, pathName, ScratchFileService.Option.create_if_missing);
            if (virtualFile != null) {
                virtualFile.putUserData(SELECTED_ENGINE_INFO_KEY, (Object)info);
                FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
            }
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
        }
    }

    public static void configureConsole(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(7);
        }
        if (source == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(8);
        }
        MyRunAction runAction = new MyRunAction();
        for (FileEditor fileEditor : source.getEditors(file2)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            runAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, editor.getComponent());
        }
    }

    private static void executeQuery(@NotNull Project project, @NotNull VirtualFile file2, @NotNull Editor editor, @NotNull IdeScriptEngineManager.EngineInfo engineInfo) {
        IdeScriptEngine engine;
        String command;
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(11);
        }
        if (engineInfo == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmptyOrSpaces((String)(command = RunIdeConsoleAction.getCommandText(project, editor)))) {
            return;
        }
        String profile = RunIdeConsoleAction.getProfileText(file2);
        RunContentDescriptor descriptor2 = RunIdeConsoleAction.getConsoleView(project, file2, engineInfo);
        Content content2 = descriptor2.getAttachedContent();
        if (content2 == null) {
            LOG.error("Attached content expected");
            return;
        }
        Trinity data2 = (Trinity)content2.getUserData(SCRIPT_ENGINE_KEY);
        if (data2 != null) {
            engine = (IdeScriptEngine)data2.first;
        } else {
            engine = IdeScriptEngineManager.getInstance().getEngine(engineInfo, null);
            if (engine == null) {
                LOG.error("Script engine not found for: " + file2.getName());
                return;
            }
            content2.putUserData(SCRIPT_ENGINE_KEY, (Object)Trinity.create((Object)engine, (Object)engineInfo, (Object)file2));
        }
        ConsoleViewImpl consoleView = (ConsoleViewImpl)descriptor2.getExecutionConsole();
        RunIdeConsoleAction.prepareEngine(project, engine, descriptor2);
        try {
            long ts = System.currentTimeMillis();
            consoleView.print("> " + command, ConsoleViewContentType.USER_INPUT);
            consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            String script = profile == null ? command : profile + "\n" + command;
            Object o = engine.eval(script);
            String prefix = "[" + StringUtil.formatDuration((long)(System.currentTimeMillis() - ts)) + "]";
            consoleView.print(prefix + "=> " + o, ConsoleViewContentType.NORMAL_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        catch (Throwable e) {
            Throwable ex = ExceptionUtil.getRootCause((Throwable)e);
            String message = StringUtil.notNullize((String)StringUtil.nullize((String)ex.getMessage()), (String)ex.toString());
            consoleView.print(ex.getClass().getSimpleName() + ": " + message, ConsoleViewContentType.ERROR_OUTPUT);
            consoleView.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
        RunIdeConsoleAction.selectContent(descriptor2);
    }

    private static void prepareEngine(@NotNull Project project, @NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor2) {
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(13);
        }
        if (engine == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(14);
        }
        if (descriptor2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(15);
        }
        IdeConsoleScriptBindings.ensureIdeIsBound(project, engine);
        RunIdeConsoleAction.ensureOutputIsRedirected(engine, descriptor2);
    }

    @Nullable
    private static String getProfileText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(16);
        }
        try {
            VirtualFile folder = file2.getParent();
            VirtualFile profileChild = folder == null ? null : folder.findChild(".profile." + file2.getExtension());
            return profileChild == null ? null : StringUtil.nullize((String)VfsUtilCore.loadText((VirtualFile)profileChild));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    private static String getCommandText(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(18);
        }
        TextRange selectedRange = EditorUtil.getSelectionInAnyMode(editor);
        Document document = editor.getDocument();
        if (selectedRange.isEmpty()) {
            int line = document.getLineNumber(selectedRange.getStartOffset());
            selectedRange = TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 != null && file2.getFirstChild() != null && file2.getFirstChild() != file2.getLastChild()) {
                PsiElement parent;
                PsiElement e1 = file2.findElementAt(selectedRange.getStartOffset());
                PsiElement e2 = file2.findElementAt(selectedRange.getEndOffset());
                while (e1 != e2 && (e1 instanceof PsiWhiteSpace || e1 != null && StringUtil.isEmptyOrSpaces((String)e1.getText()))) {
                    e1 = (PsiElement)ObjectUtils.chooseNotNull((Object)e1.getNextSibling(), (Object)PsiTreeUtil.getDeepestFirst((PsiElement)e1.getParent()));
                }
                while (e1 != e2 && (e2 instanceof PsiWhiteSpace || e2 != null && StringUtil.isEmptyOrSpaces((String)e2.getText()))) {
                    e2 = (PsiElement)ObjectUtils.chooseNotNull((Object)e2.getPrevSibling(), (Object)PsiTreeUtil.getDeepestLast((PsiElement)e2.getParent()));
                }
                if (e1 instanceof LeafPsiElement) {
                    e1 = e1.getParent();
                }
                if (e2 instanceof LeafPsiElement) {
                    e2 = e2.getParent();
                }
                PsiElement psiElement = e1 == null ? e2 : (parent = e2 == null ? e1 : PsiTreeUtil.findCommonParent((PsiElement)e1, (PsiElement)e2));
                if (parent != null && parent != file2) {
                    selectedRange = parent.getTextRange();
                }
            }
        }
        String string = document.getText(selectedRange);
        if (string == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void selectContent(RunContentDescriptor descriptor2) {
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ConsoleViewImpl consoleView = Objects.requireNonNull((ConsoleViewImpl)descriptor2.getExecutionConsole());
        RunContentManager.getInstance((Project)consoleView.getProject()).toFrontRunContent(executor, descriptor2);
    }

    @NotNull
    private static RunContentDescriptor getConsoleView(@NotNull Project project, @NotNull VirtualFile file2, @NotNull IdeScriptEngineManager.EngineInfo engineInfo) {
        if (project == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(20);
        }
        if (file2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(21);
        }
        if (engineInfo == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(22);
        }
        for (RunContentDescriptor existing : RunContentManager.getInstance((Project)project).getAllDescriptors()) {
            Trinity data2;
            Content content2 = existing.getAttachedContent();
            if (content2 == null || (data2 = (Trinity)content2.getUserData(SCRIPT_ENGINE_KEY)) == null || !Comparing.equal((Object)file2, (Object)((VirtualFile)data2.third)) || !Comparing.equal((Object)engineInfo, (Object)((IdeScriptEngineManager.EngineInfo)data2.second))) continue;
            RunContentDescriptor runContentDescriptor = existing;
            if (runContentDescriptor == null) {
                RunIdeConsoleAction.$$$reportNull$$$0(23);
            }
            return runContentDescriptor;
        }
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("RunIdeConsole", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        panel2.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)consoleView, null, panel2, file2.getName()){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.addAll(consoleView.createConsoleActions());
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor2, project));
        RunContentManager.getInstance((Project)project).showRunContent(executor, descriptor2);
        RunContentDescriptor runContentDescriptor = descriptor2;
        if (runContentDescriptor == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(24);
        }
        return runContentDescriptor;
    }

    private static void ensureOutputIsRedirected(@NotNull IdeScriptEngine engine, @NotNull RunContentDescriptor descriptor2) {
        if (engine == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(25);
        }
        if (descriptor2 == null) {
            RunIdeConsoleAction.$$$reportNull$$$0(26);
        }
        ConsoleWriter stdOutWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdOut(), ConsoleWriter.class);
        ConsoleWriter stdErrWriter = (ConsoleWriter)ObjectUtils.tryCast((Object)engine.getStdErr(), ConsoleWriter.class);
        if (stdOutWriter != null && stdOutWriter.getDescriptor() == descriptor2 && stdErrWriter != null && stdErrWriter.getDescriptor() == descriptor2) {
            return;
        }
        WeakReference<RunContentDescriptor> ref = new WeakReference<RunContentDescriptor>(descriptor2);
        engine.setStdOut(new ConsoleWriter(ref, ConsoleViewContentType.NORMAL_OUTPUT));
        engine.setStdErr(new ConsoleWriter(ref, ConsoleViewContentType.ERROR_OUTPUT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: 
            case 10: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engineInfo";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/RunIdeConsoleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/RunIdeConsoleAction";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandText";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseScriptEngineAndRun";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runConsole";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureConsole";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeQuery";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareEngine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getProfileText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCommandText";
                break;
            }
            case 19: 
            case 23: 
            case 24: {
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleView";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "ensureOutputIsRedirected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ConsoleWriter
    extends Writer {
        private final WeakReference<RunContentDescriptor> myDescriptor;
        private final ConsoleViewContentType myOutputType;

        private ConsoleWriter(@NotNull WeakReference<RunContentDescriptor> descriptor2, @NotNull ConsoleViewContentType outputType) {
            if (descriptor2 == null) {
                ConsoleWriter.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                ConsoleWriter.$$$reportNull$$$0(1);
            }
            this.myDescriptor = descriptor2;
            this.myOutputType = outputType;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            return (RunContentDescriptor)this.myDescriptor.get();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            RunContentDescriptor descriptor2 = (RunContentDescriptor)this.myDescriptor.get();
            ConsoleViewImpl console = (ConsoleViewImpl)ObjectUtils.tryCast((Object)(descriptor2 != null ? descriptor2.getExecutionConsole() : null), ConsoleViewImpl.class);
            if (console == null) {
                throw new IOException("The console is not available.");
            }
            console.print(new String(cbuf, off, len), this.myOutputType);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/console/RunIdeConsoleAction$ConsoleWriter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyRunAction
    extends DumbAwareAction {
        private IdeScriptEngineManager.EngineInfo engineInfo;

        private MyRunAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRunAction.$$$reportNull$$$0(0);
            }
            Project project = e.getProject();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(project != null && editor != null && virtualFile != null && (this.engineInfo != null || virtualFile.getUserData(SELECTED_ENGINE_INFO_KEY) != null || virtualFile.getExtension() != null));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRunAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (project == null || editor == null || virtualFile == null) {
                return;
            }
            String extension = virtualFile.getExtension();
            IdeScriptEngineManager.EngineInfo engineInfo0 = (IdeScriptEngineManager.EngineInfo)virtualFile.getUserData(SELECTED_ENGINE_INFO_KEY);
            if (this.engineInfo == null && engineInfo0 == null && extension == null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (this.engineInfo == null || engineInfo0 != null && !Comparing.equal((Object)engineInfo0, (Object)this.engineInfo) || extension != null && !this.engineInfo.fileExtensions.contains(extension)) {
                virtualFile.putUserData(SELECTED_ENGINE_INFO_KEY, null);
                List infos = engineInfo0 != null ? Collections.singletonList(engineInfo0) : JBIterable.from(IdeScriptEngineManager.getInstance().getEngineInfos()).filter(o -> o.fileExtensions.contains(extension)).toList();
                RunIdeConsoleAction.chooseScriptEngineAndRun(e, infos, (Consumer<? super IdeScriptEngineManager.EngineInfo>)((Consumer)selectedInfo -> {
                    this.engineInfo = selectedInfo;
                    RunIdeConsoleAction.executeQuery(project, virtualFile, editor, this.engineInfo);
                }));
            } else {
                RunIdeConsoleAction.executeQuery(project, virtualFile, editor, this.engineInfo);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/console/RunIdeConsoleAction$MyRunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

