/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.elevation;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.SelfKiller;
import com.intellij.execution.process.elevation.ElevationBundle;
import com.intellij.execution.process.elevation.ElevationLogger;
import com.intellij.execution.process.elevation.ElevationServiceImpl;
import com.intellij.execution.process.elevation.settings.ElevationSettings;
import com.intellij.execution.process.mediator.MediatedProcessHandler;
import com.intellij.execution.process.mediator.ProcessMediatorClientManager;
import com.intellij.execution.process.mediator.client.MediatedProcess;
import com.intellij.execution.process.mediator.client.ProcessMediatorClient;
import com.intellij.execution.process.mediator.daemon.QuotaExceededException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J'\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\u00110\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/execution/process/elevation/ElevationServiceImpl;", "Lcom/intellij/execution/process/ElevationService;", "Lcom/intellij/openapi/Disposable;", "()V", "clientManager", "Lcom/intellij/execution/process/mediator/ProcessMediatorClientManager;", "createProcess", "Lcom/intellij/execution/process/mediator/client/MediatedProcess;", "processBuilder", "Ljava/lang/ProcessBuilder;", "createProcessHandler", "Lcom/intellij/execution/process/mediator/MediatedProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "dispose", "", "tryRelaunchingDaemonUntilHaveQuotaPermit", "R", "block", "Lkotlin/Function1;", "Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "intellij.platform.elevation"})
public final class ElevationServiceImpl
implements ElevationService,
Disposable {
    private final ProcessMediatorClientManager clientManager;
    private static final int MAX_RELAUNCHING_DAEMON_UNTIL_HAVE_QUOTA_PERMIT_ATTEMPTS = 3;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public MediatedProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessBuilder processBuilder = commandLine.toProcessBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"commandLine.toProcessBuilder()");
        ProcessBuilder processBuilder2 = processBuilder;
        MediatedProcess process2 = this.createProcess(processBuilder2);
        return new MediatedProcessHandler(process2, commandLine);
    }

    @NotNull
    public MediatedProcess createProcess(@NotNull ProcessBuilder processBuilder) {
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        if (!ElevationSettings.Companion.getInstance().askEnableKeepAuthIfNeeded()) {
            throw (Throwable)new ProcessCanceledException();
        }
        return (MediatedProcess)this.tryRelaunchingDaemonUntilHaveQuotaPermit((Function1)new Function1<ProcessMediatorClient, createProcess.1>(processBuilder){
            final /* synthetic */ ProcessBuilder $processBuilder;

            @NotNull
            public final createProcess.1 invoke(@NotNull ProcessMediatorClient client) {
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                return new SelfKiller(this, client, client, this.$processBuilder){
                    final /* synthetic */ createProcess.1 this$0;
                    final /* synthetic */ ProcessMediatorClient $client;
                    {
                        this.this$0 = this$0;
                        this.$client = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3);
                        ElevationLogger.INSTANCE.getLOG().info("Created process PID " + this.pid());
                    }
                };
            }
            {
                this.$processBuilder = processBuilder;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final <R> R tryRelaunchingDaemonUntilHaveQuotaPermit(Function1<? super ProcessMediatorClient, ? extends R> block) {
        int maxAttempts = 3;
        boolean bl = true;
        int n = maxAttempts;
        while (true) {
            ProcessMediatorClient client = this.clientManager.launchDaemonAndConnectClientIfNeeded();
            try {
                return (R)block.invoke((Object)client);
            }
            catch (QuotaExceededException e) {
                void attempt;
                if (attempt > true) {
                    ElevationLogger.INSTANCE.getLOG().warn("Repeated quota exceeded error after " + (int)attempt + " attempts; " + "quota options: " + ElevationSettings.Companion.getInstance().getQuotaOptions(), (Throwable)e);
                }
                this.clientManager.parkClient(client);
                if (attempt != n) {
                    ++attempt;
                    continue;
                }
                throw (Throwable)new ExecutionException(ElevationBundle.message("dialog.message.unable.to.configure.elevation.daemon.after.attempts", maxAttempts));
            }
            break;
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    public ElevationServiceImpl() {
        void it;
        ProcessMediatorClientManager processMediatorClientManager = new ProcessMediatorClientManager();
        boolean bl = false;
        boolean bl2 = false;
        ProcessMediatorClientManager processMediatorClientManager2 = processMediatorClientManager;
        ElevationServiceImpl elevationServiceImpl = this;
        boolean bl3 = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        Unit unit = Unit.INSTANCE;
        elevationServiceImpl.clientManager = processMediatorClientManager;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/execution/process/elevation/ElevationServiceImpl$Companion;", "", "()V", "MAX_RELAUNCHING_DAEMON_UNTIL_HAVE_QUOTA_PERMIT_ATTEMPTS", "", "intellij.platform.elevation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

