/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WslDistributionManager {
    private static final Logger LOG = Logger.getInstance(WslDistributionManager.class);
    private static final WslDistributionManager INSTANCE = new WslDistributionManager();

    @NotNull
    public static WslDistributionManager getInstance() {
        WslDistributionManager wslDistributionManager = INSTANCE;
        if (wslDistributionManager == null) {
            WslDistributionManager.$$$reportNull$$$0(0);
        }
        return wslDistributionManager;
    }

    @NotNull
    public List<WSLDistribution> getInstalledDistributions() {
        List<WSLDistribution> parsedFromWslList;
        try {
            long startNano = System.nanoTime();
            parsedFromWslList = WslDistributionManager.parseFromWslList();
            LOG.info("Installed WSL distributions parsed in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms");
        }
        catch (ExecutionException e) {
            LOG.info("Cannot parse WSL distributions", (Throwable)e);
            parsedFromWslList = Collections.emptyList();
        }
        List<WSLDistribution> withExecutable = WSLUtil.getAvailableDistributions();
        ArrayList<WSLDistribution> result2 = new ArrayList<WSLDistribution>(withExecutable);
        for (WSLDistribution parsedDistribution : parsedFromWslList) {
            if (!withExecutable.stream().noneMatch(d -> d.getMsId().equals(parsedDistribution.getMsId()))) continue;
            result2.add(parsedDistribution);
        }
        ArrayList<WSLDistribution> arrayList = result2;
        if (arrayList == null) {
            WslDistributionManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static List<WSLDistribution> parseFromWslList() throws ExecutionException {
        GeneralCommandLine commandLine = WslDistributionManager.createCommandLine();
        commandLine.setCharset(StandardCharsets.UTF_16LE);
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)5000);
        if (output.isTimeout()) {
            throw new ExecutionException(commandLine.getCommandLineString() + " is timed out");
        }
        if (output.getExitCode() != 0) {
            throw new ExecutionException(commandLine.getCommandLineString() + " has terminated with exit code " + output.getExitCode());
        }
        if (!output.getStderr().isEmpty()) {
            throw new ExecutionException(commandLine.getCommandLineString() + " failed with " + output.getStderr());
        }
        @NlsSafe List lines = output.getStdoutLines();
        List list2 = ContainerUtil.map((Collection)lines, WSLDistribution::new);
        if (list2 == null) {
            WslDistributionManager.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine() throws ExecutionException {
        File wslExe = PathEnvironmentVariableUtil.findInPath((String)"wsl.exe");
        if (wslExe == null) {
            throw new ExecutionException("No wsl.exe found in %PATH%");
        }
        return new GeneralCommandLine(new String[]{wslExe.getAbsolutePath(), "--list", "--quiet"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/wsl/WslDistributionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDistributions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFromWslList";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

