/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.impl.FrameworkDetectionIndexListener;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.externalizer.StringCollectionExternalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkDetectionIndex
extends ScalarIndexExtension<String> {
    private static final Logger LOG = Logger.getInstance(FrameworkDetectionIndex.class);
    public static final ID<String, Void> NAME = ID.create((String)"FrameworkDetectionIndex");
    private final EventDispatcher<FrameworkDetectionIndexListener> myDispatcher = EventDispatcher.create(FrameworkDetectionIndexListener.class);

    public static FrameworkDetectionIndex getInstance() {
        return (FrameworkDetectionIndex)((Object)EXTENSION_POINT_NAME.findExtension(FrameworkDetectionIndex.class));
    }

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public void addListener(@NotNull FrameworkDetectionIndexListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return new CompositeDataIndexer<String, Void, Collection<Pair<ElementPattern<FileContent>, String>>, List<String>>(){

            @Nullable
            public Collection<Pair<ElementPattern<FileContent>, String>> calculateSubIndexer(@NotNull IndexedFile file2) {
                MultiMap<FileType, Pair<ElementPattern<FileContent>, String>> map2;
                Collection indexerCandidates;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (indexerCandidates = (map2 = FrameworkDetectorRegistry.getInstance().getDetectorsMap()).get((Object)file2.getFileType())).isEmpty() ? null : indexerCandidates;
            }

            @NotNull
            public List<String> getSubIndexerVersion(@NotNull Collection<Pair<ElementPattern<FileContent>, String>> pairs) {
                if (pairs == null) {
                    1.$$$reportNull$$$0(1);
                }
                List<String> list2 = pairs.stream().map(p -> (String)p.getSecond()).sorted().collect(Collectors.toList());
                if (list2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list2;
            }

            @NotNull
            public KeyDescriptor<List<String>> getSubIndexerVersionDescriptor() {
                return new StringCollectionExternalizer(ArrayList::new);
            }

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData, @NotNull Collection<Pair<ElementPattern<FileContent>, String>> pairs) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (pairs == null) {
                    1.$$$reportNull$$$0(4);
                }
                FileType fileType = inputData.getFileType();
                MultiMap<FileType, Pair<ElementPattern<FileContent>, String>> detectors = FrameworkDetectorRegistry.getInstance().getDetectorsMap();
                if (!detectors.containsKey((Object)fileType)) {
                    Map<String, Void> map2 = Collections.emptyMap();
                    if (map2 == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return map2;
                }
                Map<String, Void> result2 = null;
                for (Pair pair : detectors.get((Object)fileType)) {
                    if (!((ElementPattern)pair.getFirst()).accepts((Object)inputData)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(inputData.getFile() + " accepted by detector " + (String)pair.getSecond());
                    }
                    if (result2 == null) {
                        result2 = new HashMap<String, Void>();
                    }
                    ((FrameworkDetectionIndexListener)FrameworkDetectionIndex.this.myDispatcher.getMulticaster()).fileUpdated(inputData.getFile(), (String)pair.getSecond());
                    result2.put((String)pair.getSecond(), null);
                }
                Map<String, Void> map3 = result2 != null ? result2 : Collections.emptyMap();
                if (map3 == null) {
                    1.$$$reportNull$$$0(6);
                }
                return map3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pairs";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/framework/detection/impl/FrameworkDetectionIndex$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionIndex$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersion";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSubIndexer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubIndexerVersion";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            FrameworkDetectionIndex.$$$reportNull$$$0(3);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(FrameworkDetectorRegistry.getInstance().getAcceptedFileTypes()){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return file2.isInLocalFileSystem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/framework/detection/impl/FrameworkDetectionIndex$2", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 65536;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/FrameworkDetectionIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectionIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

