/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.customize.IdSet;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import icons.PlatformImplIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginGroups {
    static final String CORE = "Core";
    private static final int MAX_DESCR_LENGTH = 55;
    static final String IDEA_VIM_PLUGIN_ID = "IdeaVIM";
    @NlsSafe
    private static final String CLOUD_DESCRIPTION = "#Cloud:#Cloud:";
    private final List<Group> myTree = new ArrayList<Group>();
    private final Map<String, @Nls String> myFeaturedPlugins = new LinkedHashMap<String, String>();
    private final Map<String, List<IdSet>> myGroups = new LinkedHashMap<String, List<IdSet>>();
    private final Map<String, @Nls String> myDescriptions = new LinkedHashMap<String, String>();
    private final List<PluginNode> myPluginsFromRepository = new ArrayList<PluginNode>();
    private final Collection<PluginId> myDisabledPluginIds = new HashSet<PluginId>();
    private final List<IdeaPluginDescriptorImpl> myAllPlugins;
    private boolean myInitialized;
    private final Set<String> myFeaturedIds = new HashSet<String>();
    private Runnable myLoadingCallback;

    public PluginGroups() {
        this.myAllPlugins = PluginDescriptorLoader.loadUncachedDescriptors();
        SwingWorker<List<PluginNode>, Object> worker = new SwingWorker<List<PluginNode>, Object>(){

            @Override
            protected List<PluginNode> doInBackground() {
                try {
                    List featuresPluginIds = ContainerUtil.map(PluginGroups.this.getFeaturedPlugins().values(), value2 -> PluginGroups.parsePluginId(value2));
                    List<PluginNode> featuredPlugins = MarketplaceRequests.getInstance().loadLastCompatiblePluginDescriptors(featuresPluginIds);
                    List<@NotNull String> dependsIds = featuredPlugins.stream().map(p -> p.getDependencies()).flatMap(Collection::stream).filter(dep -> !dep.isOptional()).map(dep -> dep.getPluginId().getIdString()).collect(Collectors.toList());
                    List<PluginNode> dependsPlugins = MarketplaceRequests.getInstance().loadLastCompatiblePluginDescriptors(dependsIds);
                    featuredPlugins.addAll(dependsPlugins);
                    return featuredPlugins;
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }

            @Override
            protected void done() {
                block3: {
                    try {
                        PluginGroups.this.myPluginsFromRepository.addAll((Collection)this.get());
                        if (PluginGroups.this.myLoadingCallback != null) {
                            PluginGroups.this.myLoadingCallback.run();
                        }
                    }
                    catch (InterruptedException | ExecutionException e) {
                        if (PluginGroups.this.myLoadingCallback == null) break block3;
                        PluginGroups.this.myLoadingCallback.run();
                    }
                }
            }
        };
        LinkedHashMap<String, Pair<Icon, List<String>>> treeMap = new LinkedHashMap<String, Pair<Icon, List<String>>>();
        this.initGroups(treeMap, this.myFeaturedPlugins);
        for (Map.Entry entry : treeMap.entrySet()) {
            this.myTree.add(new Group((String)entry.getKey(), (String)entry.getKey(), (Icon)((Pair)entry.getValue()).getFirst(), null, (List)((Pair)entry.getValue()).getSecond()));
        }
        worker.execute();
        DisabledPluginsState.loadDisabledPlugins(new File(PathManager.getConfigPath()).getPath(), this.myDisabledPluginIds);
        this.initCloudPlugins();
    }

    void setLoadingCallback(Runnable loadingCallback) {
        this.myLoadingCallback = loadingCallback;
        if (!this.myPluginsFromRepository.isEmpty()) {
            this.myLoadingCallback.run();
        }
    }

    private void initCloudPlugins() {
        CloudConfigProvider provider2 = CloudConfigProvider.getProvider();
        if (provider2 == null) {
            return;
        }
        List<PluginId> plugins = provider2.getInstalledPlugins();
        if (plugins.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, String>> I = this.myFeaturedPlugins.entrySet().iterator();
        while (I.hasNext()) {
            String value2 = I.next().getValue();
            if (ContainerUtil.find(plugins, plugin2 -> value2.endsWith(":" + plugin2)) == null) continue;
            I.remove();
        }
        for (PluginId plugin3 : plugins) {
            this.myFeaturedPlugins.put(plugin3.getIdString(), CLOUD_DESCRIPTION + plugin3);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    protected void initGroups(Map<String, Pair<Icon, List<String>>> tree, Map<String, String> featuredPlugins) {
        this.initGroups(this.myTree, this.myFeaturedPlugins);
    }

    protected void initGroups(@NotNull List<Group> groups2, @NotNull Map<String, String> featuredPlugins) {
        if (groups2 == null) {
            PluginGroups.$$$reportNull$$$0(0);
        }
        if (featuredPlugins == null) {
            PluginGroups.$$$reportNull$$$0(1);
        }
        groups2.add(new Group(CORE, IdeBundle.message((String)"label.plugin.group.name.core", (Object[])new Object[0]), null, null, Arrays.asList("com.intellij.copyright", "com.intellij.java-i18n", "org.intellij.intelliLang", "com.intellij.properties", "Refactor-X", "Type Migration", "ZKM")));
        groups2.add(new Group("Java Frameworks", IdeBundle.message((String)"label.plugin.group.name.java.frameworks", (Object[])new Object[0]), PlatformImplIcons.JavaFrameworks, null, Arrays.asList("Spring:com.intellij.spring.batch,com.intellij.spring.data,com.intellij.spring.integration,com.intellij.spring.osgi,com.intellij.spring.security,com.intellij.spring,com.intellij.spring.webflow,com.intellij.spring.ws,com.intellij.aop", "Java EE:com.intellij.javaee.batch,com.intellij.beanValidation,com.intellij.cdi,com.intellij.javaee,com.intellij.jsf,com.intellij.javaee.extensions,com.jetbrains.restWebServices,Web Services (JAX-WS),com.intellij.javaee.webSocket,com.intellij.jsp", "com.intellij.hibernate", "com.intellij.reactivestreams", "com.intellij.frameworks.java.sql", "org.intellij.grails", "com.intellij.micronaut", "com.intellij.quarkus", "com.intellij.helidon", "com.intellij.guice", "com.intellij.freemarker", "com.intellij.velocity", "com.intellij.aspectj")));
        groups2.add(new Group("Build Tools", IdeBundle.message((String)"label.plugin.group.name.build.tools", (Object[])new Object[0]), PlatformImplIcons.BuildTools, null, Arrays.asList("AntSupport", "Maven:org.jetbrains.idea.maven,org.jetbrains.idea.maven.ext", "org.jetbrains.plugins.gradle")));
        groups2.add(new Group("JavaScript Development", IdeBundle.message((String)"label.plugin.group.name.javascript.development", (Object[])new Object[0]), PlatformImplIcons.WebDevelopment, IdeBundle.message((String)"label.plugin.group.description.javascript.development", (Object[])new Object[0]), Arrays.asList("HTML:HtmlTools,W3Validators", "JavaScript and TypeScript:JavaScript,JavaScriptDebugger,JSIntentionPowerPack", "Node.js:NodeJS", "com.intellij.css", "org.jetbrains.plugins.less", "org.jetbrains.plugins.sass", "org.jetbrains.plugins.stylus", "org.jetbrains.plugins.haml", "AngularJS", "org.coffeescript", "com.jetbrains.restClient", "com.intellij.swagger")));
        PluginGroups.addVcsGroup(groups2);
        groups2.add(new Group("Test Tools", IdeBundle.message((String)"label.plugin.group.name.test.tools", (Object[])new Object[0]), PlatformImplIcons.TestTools, null, Arrays.asList("JUnit", "TestNG-J", "cucumber-java", "cucumber", "Coverage:Coverage,Emma")));
        groups2.add(new Group("Application Servers", IdeBundle.message((String)"label.plugin.group.name.application.servers", (Object[])new Object[0]), PlatformImplIcons.ApplicationServers, null, Arrays.asList("com.intellij.javaee.view", "Geronimo", "GlassFish", "JBoss", "Jetty", "Tomcat", "Weblogic", "WebSphere", "JSR45Plugin")));
        groups2.add(new Group("Swing", IdeBundle.message((String)"label.plugin.group.name.swing", (Object[])new Object[0]), PlatformImplIcons.Swing, null, Collections.singletonList("com.intellij.uiDesigner")));
        groups2.add(new Group("Android", IdeBundle.message((String)"label.plugin.group.name.android", (Object[])new Object[0]), PlatformImplIcons.Android, null, Arrays.asList("org.jetbrains.android", "com.intellij.android-designer")));
        groups2.add(new Group("Database Tools", IdeBundle.message((String)"label.plugin.group.name.database.tools", (Object[])new Object[0]), PlatformImplIcons.DatabaseTools, null, Collections.singletonList("com.intellij.database")));
        groups2.add(new Group("Other Tools", IdeBundle.message((String)"label.plugin.group.name.other.tools", (Object[])new Object[0]), PlatformImplIcons.OtherTools, null, Arrays.asList("ByteCodeViewer", "com.intellij.dsm", "org.jetbrains.idea.eclipse", "org.jetbrains.debugger.streams", "Remote Access:com.jetbrains.plugins.webDeployment,org.jetbrains.plugins.remote-run", "Task Management:com.intellij.tasks,com.intellij.tasks.timeTracking", "org.jetbrains.plugins.terminal", "org.jetbrains.plugins.emojipicker", "com.intellij.diagram", "org.jetbrains.plugins.yaml", "XSLT and XPath:XPathView,XSLT-Debugger")));
        groups2.add(new Group("Plugin Development", IdeBundle.message((String)"label.plugin.group.name.plugin.development", (Object[])new Object[0]), PlatformImplIcons.PluginDevelopment, null, Collections.singletonList("DevKit")));
        this.initFeaturedPlugins(featuredPlugins);
    }

    protected void initFeaturedPlugins(@NotNull Map<String, String> featuredPlugins) {
        if (featuredPlugins == null) {
            PluginGroups.$$$reportNull$$$0(2);
        }
        featuredPlugins.put("Scala", "Custom Languages:Plugin for Scala language support:org.intellij.scala");
        featuredPlugins.put("Live Edit Tool", "Web Development:Provides live edit HTML/CSS/JavaScript:com.intellij.plugins.html.instantEditing");
        PluginGroups.addVimPlugin(featuredPlugins);
        featuredPlugins.put("Atlassian Connector", "Tools Integration:Integration for Atlassian JIRA, Bamboo, Crucible, FishEye:atlassian-idea-plugin");
        PluginGroups.addTrainingPlugin(featuredPlugins);
    }

    static String parsePluginId(String string) {
        int i2 = string.indexOf(58);
        int j = string.indexOf(58, i2 + 1);
        return string.substring(j + 1);
    }

    protected static void addVcsGroup(@NotNull List<Group> groups2) {
        if (groups2 == null) {
            PluginGroups.$$$reportNull$$$0(3);
        }
        groups2.add(new Group("Version Controls", IdeBundle.message((String)"label.plugin.group.name.version.controls", (Object[])new Object[0]), PlatformImplIcons.VersionControls, null, Arrays.asList("CVS", "Git4Idea", "org.jetbrains.plugins.github", "hg4idea", "PerforceDirectPlugin", "Subversion", "TFS")));
    }

    public static void addVimPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("IdeaVim", "Editor:Emulates Vim editor:IdeaVIM");
    }

    public static void addAwsPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("AWS Toolkit", "Cloud Support:Create, test, and debug serverless applications built using the AWS Serverless Application Model:aws.toolkit");
    }

    public static void addTrainingPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("IDE Features Trainer", "Code tools:Learn basic shortcuts and essential features interactively:training");
    }

    protected static void addLuaPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("Lua", "Custom Languages:Lua language support:Lua");
    }

    public static void addRustPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("Rust", "Custom Languages:Rust language support:org.rust.lang");
    }

    public static void addMarkdownPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("Markdown", "Custom Languages:Markdown language support:org.intellij.plugins.markdown");
    }

    public static void addRPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("R", "Custom Languages:R language support:R4Intellij");
    }

    protected static void addConfigurationServerPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("Configuration Server", "Team Work:Supports sharing settings between installations of IntelliJ Platform based products used by the same developer on different computers:IdeaServerPlugin");
    }

    public static void addTeamCityPlugin(Map<String, String> featuredPlugins) {
        featuredPlugins.put("TeamCity Integration", "Tools Integration:Integration with JetBrains TeamCity - innovative solution for continuous integration and build management:JetBrains TeamCity Plugin");
    }

    public static void addBigDataToolsPlugin(@NotNull Map<String, String> featuredPlugins) {
        if (featuredPlugins == null) {
            PluginGroups.$$$reportNull$$$0(4);
        }
        featuredPlugins.put("Big Data Tools", "Tools Integration:Zeppelin notebooks and Spark applications support:com.intellij.bigdatatools");
    }

    private void initIfNeeded() {
        if (this.myInitialized) {
            return;
        }
        this.myInitialized = true;
        for (Group g : this.myTree) {
            String groupDescription;
            String group2 = g.getId();
            if (CORE.equals(group2)) continue;
            ArrayList<IdSet> idSets = new ArrayList<IdSet>();
            StringBuilder description = new StringBuilder();
            for (String idDescription : g.getPluginIdDescription()) {
                IdSet idSet = new IdSet(this, idDescription);
                String idSetTitle = idSet.getTitle();
                if (idSetTitle == null) continue;
                idSets.add(idSet);
                if (description.length() > 0) {
                    description.append(", ");
                }
                description.append(idSetTitle);
            }
            this.myGroups.put(group2, idSets);
            if (description.length() > 55) {
                int lastWord = description.lastIndexOf(",", 55);
                description.delete(lastWord, description.length()).append("...");
            }
            if ((groupDescription = g.getDescription()) != null) {
                description = new StringBuilder(groupDescription);
            }
            description.insert(0, "<html><body><center><i>");
            this.myDescriptions.put(group2, description.toString());
        }
    }

    @NotNull
    List<Group> getTree() {
        this.initIfNeeded();
        List<Group> list2 = this.myTree;
        if (list2 == null) {
            PluginGroups.$$$reportNull$$$0(5);
        }
        return list2;
    }

    Map<String, @Nls String> getFeaturedPlugins() {
        return this.myFeaturedPlugins;
    }

    @Nls
    public String getDescription(String group2) {
        this.initIfNeeded();
        return this.myDescriptions.get(group2);
    }

    public List<IdSet> getSets(String group2) {
        this.initIfNeeded();
        return this.myGroups.get(group2);
    }

    @Nullable
    final IdeaPluginDescriptor findPlugin(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginGroups.$$$reportNull$$$0(6);
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : this.myAllPlugins) {
            if (ideaPluginDescriptor.getPluginId() != id2) continue;
            return ideaPluginDescriptor;
        }
        return null;
    }

    boolean isIdSetAllEnabled(IdSet set2) {
        for (PluginId id2 : set2.getIds()) {
            if (this.isPluginEnabled(id2)) continue;
            return false;
        }
        return true;
    }

    void setIdSetEnabled(@NotNull IdSet set2, boolean enabled) {
        if (set2 == null) {
            PluginGroups.$$$reportNull$$$0(7);
        }
        for (PluginId id2 : set2.getIds()) {
            this.setPluginEnabledWithDependencies(id2, enabled);
        }
    }

    @NotNull
    Collection<PluginId> getDisabledPluginIds() {
        Collection<PluginId> collection = Collections.unmodifiableCollection(this.myDisabledPluginIds);
        if (collection == null) {
            PluginGroups.$$$reportNull$$$0(8);
        }
        return collection;
    }

    List<PluginNode> getPluginsFromRepository() {
        return this.myPluginsFromRepository;
    }

    boolean isPluginEnabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginGroups.$$$reportNull$$$0(9);
        }
        this.initIfNeeded();
        return !this.myDisabledPluginIds.contains(pluginId);
    }

    private IdSet getSet(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginGroups.$$$reportNull$$$0(10);
        }
        this.initIfNeeded();
        for (List<IdSet> sets : this.myGroups.values()) {
            for (IdSet set2 : sets) {
                for (PluginId id2 : set2.getIds()) {
                    if (id2 != pluginId) continue;
                    return set2;
                }
            }
        }
        return null;
    }

    void setFeaturedPluginEnabled(String pluginId, boolean enabled) {
        if (enabled) {
            this.myFeaturedIds.add(pluginId);
        } else {
            this.myFeaturedIds.remove(pluginId);
        }
        WelcomeWizardUtil.setFeaturedPluginsToInstall(this.myFeaturedIds);
    }

    void setPluginEnabledWithDependencies(@NotNull PluginId pluginId, boolean enabled) {
        if (pluginId == null) {
            PluginGroups.$$$reportNull$$$0(11);
        }
        this.initIfNeeded();
        HashSet<PluginId> ids = new HashSet<PluginId>();
        HashMap<PluginId, IdeaPluginDescriptorImpl> idToDescriptor = new HashMap<PluginId, IdeaPluginDescriptorImpl>(this.myAllPlugins.size());
        for (IdeaPluginDescriptorImpl pluginDescriptor : this.myAllPlugins) {
            idToDescriptor.put(pluginDescriptor.getPluginId(), pluginDescriptor);
        }
        this.collectInvolvedIds(pluginId, enabled, ids, idToDescriptor);
        HashSet<IdSet> sets = new HashSet<IdSet>();
        for (PluginId id2 : ids) {
            IdSet set2 = this.getSet(id2);
            if (set2 == null) continue;
            sets.add(set2);
        }
        for (IdSet set3 : sets) {
            ids.addAll(set3.getIds());
        }
        for (PluginId id2 : ids) {
            if (enabled) {
                this.myDisabledPluginIds.remove(id2);
                continue;
            }
            this.myDisabledPluginIds.add(id2);
        }
    }

    private void collectInvolvedIds(@NotNull PluginId pluginId, boolean toEnable, @NotNull Set<PluginId> ids, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptor) {
        block7: {
            block6: {
                if (pluginId == null) {
                    PluginGroups.$$$reportNull$$$0(12);
                }
                if (ids == null) {
                    PluginGroups.$$$reportNull$$$0(13);
                }
                if (idToDescriptor == null) {
                    PluginGroups.$$$reportNull$$$0(14);
                }
                ids.add(pluginId);
                if (!toEnable) break block6;
                IdeaPluginDescriptorImpl descriptor2 = idToDescriptor.get(pluginId);
                if (descriptor2 == null) break block7;
                for (PluginDependency dependency : descriptor2.getPluginDependencies()) {
                    if (dependency.isOptional || dependency.id == PluginManagerCore.CORE_ID) continue;
                    this.collectInvolvedIds(dependency.id, true, ids, idToDescriptor);
                }
                break block7;
            }
            for (IdeaPluginDescriptorImpl plugin2 : this.myAllPlugins) {
                for (PluginDependency dependency : plugin2.getPluginDependencies()) {
                    if (dependency.isOptional || dependency.id != pluginId) continue;
                    this.collectInvolvedIds(plugin2.getPluginId(), false, ids, idToDescriptor);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featuredPlugins";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/customize/PluginGroups";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/customize/PluginGroups";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledPluginIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initGroups";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initFeaturedPlugins";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addVcsGroup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addBigDataToolsPlugin";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setIdSetEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPluginEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSet";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setPluginEnabledWithDependencies";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectInvolvedIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Group {
        private final String myId;
        @Nls
        private final String myName;
        private final Icon myIcon;
        @Nls
        private final String myDescription;
        private final List<String> myPluginIdDescription;

        @Deprecated
        public Group(@NonNls @NotNull String name, @Nullable Icon icon2, @Nullable String description, @NonNls @NotNull List<String> pluginIdDescription) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            if (pluginIdDescription == null) {
                Group.$$$reportNull$$$0(1);
            }
            this(name, name, icon2, description, pluginIdDescription);
        }

        public Group(@NotNull String id2, @Nls @NotNull String name, @Nullable Icon icon2, @Nullable @Nls String description, @NonNls @NotNull List<String> pluginIdDescription) {
            if (id2 == null) {
                Group.$$$reportNull$$$0(2);
            }
            if (name == null) {
                Group.$$$reportNull$$$0(3);
            }
            if (pluginIdDescription == null) {
                Group.$$$reportNull$$$0(4);
            }
            this.myId = id2;
            this.myName = name;
            this.myIcon = icon2;
            this.myDescription = description;
            this.myPluginIdDescription = pluginIdDescription;
        }

        public String getId() {
            return this.myId;
        }

        @NotNull
        @Nls
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Group.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Nullable
        @Nls
        public String getDescription() {
            return this.myDescription;
        }

        @NotNull
        public List<String> getPluginIdDescription() {
            List<String> list2 = this.myPluginIdDescription;
            if (list2 == null) {
                Group.$$$reportNull$$$0(6);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginIdDescription";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/customize/PluginGroups$Group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/customize/PluginGroups$Group";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPluginIdDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

