/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.DataManager;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.ActionFromOptionDescriptorProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ChooseByNameWeightedItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.CollectConsumer;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.Matcher;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GotoActionItemProvider
implements ChooseByNameWeightedItemProvider {
    private static final int BONUS_FOR_SPACE_IN_PATTERN = 100;
    private static final int SETTINGS_PENALTY = 100;
    private final ActionManager myActionManager = ActionManager.getInstance();
    private final GotoActionModel myModel;
    private final ClearableLazyValue<Map<String, ApplyIntentionAction>> myIntentions;
    private static final Logger LOG = Logger.getInstance(GotoActionItemProvider.class);

    public GotoActionItemProvider(GotoActionModel model2) {
        this.myModel = model2;
        this.myIntentions = ClearableLazyValue.create(() -> (Map)ReadAction.compute(() -> this.myModel.getAvailableIntentions()));
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, String @NotNull [] names2, @NotNull String pattern) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(1);
        }
        if (names2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(2);
        }
        List<String> list2 = this.filterNames((ChooseByNameViewModel)base, names2, pattern);
        if (list2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameViewModel base, String @NotNull [] names2, @NotNull String pattern) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(5);
        }
        if (names2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(6);
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer2) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(8);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(9);
        }
        if (cancelled == null) {
            GotoActionItemProvider.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(11);
        }
        return this.filterElements((ChooseByNameViewModel)base, pattern, everywhere, cancelled, consumer2);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer2) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(12);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(13);
        }
        if (cancelled == null) {
            GotoActionItemProvider.$$$reportNull$$$0(14);
        }
        if (consumer2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(15);
        }
        return this.filterElementsWithWeights(base, pattern, everywhere, cancelled, descriptor2 -> consumer2.process(descriptor2.getItem()));
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(16);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            GotoActionItemProvider.$$$reportNull$$$0(18);
        }
        if (consumer2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(19);
        }
        return this.filterElementsWithWeights((ChooseByNameViewModel)base, pattern, everywhere, indicator, consumer2);
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer2) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(20);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            GotoActionItemProvider.$$$reportNull$$$0(22);
        }
        if (consumer2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(23);
        }
        return this.filterElements(pattern, (Processor<? super GotoActionModel.MatchedValue>)((Processor)value2 -> {
            if (!everywhere && value2.value instanceof GotoActionModel.ActionWrapper && !((GotoActionModel.ActionWrapper)value2.value).isAvailable()) {
                return true;
            }
            return consumer2.process((Object)new FoundItemDescriptor(value2, value2.getMatchingDegree()));
        }));
    }

    public boolean filterElements(@NotNull String pattern, @NotNull Processor<? super GotoActionModel.MatchedValue> consumer2) {
        DataContext dataContext;
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(24);
        }
        if (consumer2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(25);
        }
        if (!this.processAbbreviations(pattern, consumer2, dataContext = DataManager.getInstance().getDataContext(this.myModel.getContextComponent()))) {
            return false;
        }
        if (!this.processActions(pattern, consumer2, dataContext)) {
            return false;
        }
        if (!this.processTopHits(pattern, consumer2, dataContext)) {
            return false;
        }
        if (!this.processIntentions(pattern, consumer2, dataContext)) {
            return false;
        }
        return this.processOptions(pattern, consumer2, dataContext);
    }

    private boolean processAbbreviations(@NotNull String pattern, Processor<? super GotoActionModel.MatchedValue> consumer2, DataContext context) {
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(26);
        }
        MinusculeMatcher matcher = GotoActionItemProvider.buildWeightMatcher(pattern);
        List actionIds = AbbreviationManager.getInstance().findActions(pattern);
        JBIterable wrappers = JBIterable.from((Iterable)actionIds).filterMap(arg_0 -> ((ActionManager)this.myActionManager).getAction(arg_0)).transform(action2 -> {
            GotoActionModel.ActionWrapper wrapper2 = this.wrapAnAction((AnAction)action2, context);
            int degree = matcher.matchingDegree(pattern);
            return new GotoActionModel.MatchedValue(wrapper2, pattern, degree){

                @Override
                @NotNull
                public String getValueText() {
                    String string = this.pattern;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionItemProvider$1", "getValueText"));
                }
            };
        });
        return GotoActionItemProvider.processItems(pattern, wrappers, consumer2);
    }

    private boolean processTopHits(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer2, DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        CollectConsumer collector = new CollectConsumer();
        String commandAccelerator = SearchTopHitProvider.getTopHitAccelerator();
        for (SearchTopHitProvider provider2 : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
            if (provider2 instanceof OptionsTopHitProvider.CoveredByToggleActions) continue;
            if (provider2 instanceof OptionsSearchTopHitProvider && !StringUtil.startsWith((CharSequence)pattern, (CharSequence)commandAccelerator)) {
                String prefix = commandAccelerator + ((OptionsSearchTopHitProvider)provider2).getId() + " ";
                provider2.consumeTopHits(prefix + pattern, (Consumer)collector, project);
            } else if (project != null && provider2 instanceof OptionsTopHitProvider.ProjectLevelProvidersAdapter) {
                ((OptionsTopHitProvider.ProjectLevelProvidersAdapter)provider2).consumeAllTopHits(pattern, (Consumer<Object>)collector, project);
            }
            provider2.consumeTopHits(pattern, (Consumer)collector, project);
        }
        Collection result2 = collector.getResult();
        JBIterable wrappers = JBIterable.from((Iterable)result2).transform(object -> object instanceof AnAction ? this.wrapAnAction((AnAction)object, dataContext) : object);
        return GotoActionItemProvider.processItems(pattern, wrappers, consumer2);
    }

    private boolean processOptions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer2, DataContext dataContext) {
        Map<@NonNls String, @NlsContexts.ConfigurableName String> map2 = this.myModel.getConfigurablesNames();
        SearchableOptionsRegistrarImpl registrar = (SearchableOptionsRegistrarImpl)SearchableOptionsRegistrar.getInstance();
        ArrayList<GotoActionModel.ActionWrapper> options2 = new ArrayList<GotoActionModel.ActionWrapper>();
        Set<String> words = registrar.getProcessedWords(pattern);
        Set<OptionDescription> optionDescriptions = null;
        String actionManagerName = this.myActionManager.getComponentName();
        boolean filterOutInspections = Registry.is((String)"go.to.action.filter.out.inspections", (boolean)true);
        for (String string : words) {
            Set<OptionDescription> set2 = registrar.getAcceptableDescriptions(string);
            if (set2 != null) {
                set2.removeIf(description -> actionManagerName.equals(description.getPath()) || filterOutInspections && "Inspections".equals(description.getGroupName()));
                if (set2.isEmpty()) continue;
                if (optionDescriptions == null) {
                    optionDescriptions = set2;
                    continue;
                }
                optionDescriptions.retainAll(set2);
                continue;
            }
            optionDescriptions = null;
            break;
        }
        if (!StringUtil.isEmptyOrSpaces((String)pattern)) {
            Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
            if (optionDescriptions == null) {
                optionDescriptions = new THashSet();
            }
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (!matcher.matches(entry.getValue())) continue;
                optionDescriptions.add(new OptionDescription(null, entry.getKey(), entry.getValue(), null, entry.getValue()));
            }
        }
        if (optionDescriptions != null && !optionDescriptions.isEmpty()) {
            HashSet<String> currentHits = new HashSet<String>();
            Iterator iterator2 = optionDescriptions.iterator();
            while (iterator2.hasNext()) {
                OptionDescription optionDescription = (OptionDescription)iterator2.next();
                String hit = optionDescription.getHit();
                if (hit != null && currentHits.add(hit.trim())) continue;
                iterator2.remove();
            }
            for (OptionDescription optionDescription : optionDescriptions) {
                for (ActionFromOptionDescriptorProvider converter : (ActionFromOptionDescriptorProvider[])ActionFromOptionDescriptorProvider.EP.getExtensions()) {
                    AnAction action2 = converter.provide(optionDescription);
                    if (action2 == null) continue;
                    options2.add(new GotoActionModel.ActionWrapper(action2, null, GotoActionModel.MatchMode.NAME, dataContext, this.myModel));
                }
                options2.add((GotoActionModel.ActionWrapper)optionDescription);
            }
        }
        return GotoActionItemProvider.processItems(pattern, JBIterable.from(options2), consumer2);
    }

    private boolean processActions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer2, DataContext dataContext) {
        Set<String> ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
        JBIterable actions = JBIterable.from(ids).filterMap(arg_0 -> ((ActionManager)this.myActionManager).getAction(arg_0));
        Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        QuickActionProvider provider2 = (QuickActionProvider)dataContext.getData(QuickActionProvider.KEY);
        if (provider2 != null) {
            actions = actions.append((Iterable)provider2.getActions(true));
        }
        HashSet<AnAction> seenActions = new HashSet<AnAction>();
        JBIterable actionWrappers = actions.unique().filterMap(action2 -> {
            seenActions.add((AnAction)action2);
            if (action2 instanceof ActionGroup && !((ActionGroup)action2).isSearchable()) {
                return null;
            }
            GotoActionModel.MatchMode mode = this.myModel.actionMatches(pattern, matcher, (AnAction)action2);
            if (mode == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            return new GotoActionModel.ActionWrapper((AnAction)action2, this.myModel.getGroupMapping((AnAction)action2), mode, dataContext, this.myModel);
        });
        if (Registry.is((String)"actionSystem.gotoAction.all.toolwindows")) {
            List<GotoActionModel.ActionWrapper> toolWindowActions = this.collectToolWindowQuickActionProviders(pattern, matcher, seenActions);
            actionWrappers = actionWrappers.append(toolWindowActions);
        }
        return GotoActionItemProvider.processItems(pattern, actionWrappers, consumer2);
    }

    @NotNull
    private List<GotoActionModel.ActionWrapper> collectToolWindowQuickActionProviders(String pattern, Matcher matcher, Set<AnAction> seenActions) {
        ArrayList<GotoActionModel.ActionWrapper> result2 = new ArrayList<GotoActionModel.ActionWrapper>();
        Project project = this.myModel.getProject();
        if (project != null) {
            String[] toolWindowIds;
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
            for (String toolWindowId : toolWindowIds = toolWindowManager.getToolWindowIds()) {
                DataContext dataContext;
                QuickActionProvider provider2;
                Content content2;
                ContentManager contentManager2;
                ToolWindow toolWindow = toolWindowManager.getToolWindow(toolWindowId);
                if (toolWindow == null || !toolWindow.isVisible() || (contentManager2 = toolWindow.getContentManagerIfCreated()) == null || (content2 = contentManager2.getSelectedContent()) == null || (provider2 = (QuickActionProvider)QuickActionProvider.KEY.getData(dataContext = DataManager.getInstance().getDataContext((Component)content2.getComponent()))) == null) continue;
                List providerActions = provider2.getActions(true);
                String title = toolWindow.getTitle();
                if (StringUtil.isEmpty((String)title)) {
                    title = toolWindow.getStripeTitle();
                }
                this.appendActionsFromProvider(pattern, matcher, result2, seenActions, providerActions, dataContext, title);
            }
        }
        ArrayList<GotoActionModel.ActionWrapper> arrayList = result2;
        if (arrayList == null) {
            GotoActionItemProvider.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    private void appendActionsFromProvider(String pattern, Matcher matcher, List<GotoActionModel.ActionWrapper> result2, Set<AnAction> seenActions, List<AnAction> providerActions, DataContext dataContext, @NlsContexts.TabTitle @Nullable String title) {
        for (AnAction action2 : providerActions) {
            if (seenActions.contains(action2)) continue;
            seenActions.add(action2);
            if (action2 instanceof ActionGroup) {
                AnAction[] children2 = ((ActionGroup)action2).getChildren(AnActionEvent.createFromDataContext((String)"GoToAction", null, (DataContext)dataContext));
                this.appendActionsFromProvider(pattern, matcher, result2, seenActions, Arrays.asList(children2), dataContext, title);
                continue;
            }
            GotoActionModel.MatchMode mode = this.myModel.actionMatches(pattern, matcher, action2);
            if (mode == GotoActionModel.MatchMode.NONE) continue;
            result2.add(new GotoActionModel.ActionWrapper(action2, GotoActionModel.GroupMapping.createFromText(title, true), mode, dataContext, this.myModel));
        }
    }

    public void clearIntentions() {
        this.myIntentions.drop();
    }

    @NotNull
    static Matcher buildMatcher(String pattern) {
        Object object = pattern.contains(" ") ? new WordPrefixMatcher(pattern) : NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        if (object == null) {
            GotoActionItemProvider.$$$reportNull$$$0(28);
        }
        return object;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean processIntentions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer2, DataContext dataContext) {
        Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        @NlsActions.ActionText Map intentionMap = (Map)this.myIntentions.getValue();
        JBIterable intentions = JBIterable.from(intentionMap.keySet()).filterMap(intentionText -> {
            ApplyIntentionAction intentionAction = (ApplyIntentionAction)((Object)((Object)intentionMap.get(intentionText)));
            if (this.myModel.actionMatches(pattern, matcher, intentionAction) == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            GotoActionModel.GroupMapping groupMapping = GotoActionModel.GroupMapping.createFromText(intentionText, false);
            return new GotoActionModel.ActionWrapper(intentionAction, groupMapping, GotoActionModel.MatchMode.INTENTION, dataContext, this.myModel);
        });
        return GotoActionItemProvider.processItems(pattern, intentions, consumer2);
    }

    @NotNull
    private GotoActionModel.ActionWrapper wrapAnAction(@NotNull AnAction action2, DataContext dataContext) {
        if (action2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(29);
        }
        return new GotoActionModel.ActionWrapper(action2, this.myModel.getGroupMapping(action2), GotoActionModel.MatchMode.NAME, dataContext, this.myModel);
    }

    private static boolean processItems(String pattern, JBIterable<?> items, Processor<? super GotoActionModel.MatchedValue> consumer2) {
        MinusculeMatcher matcher = GotoActionItemProvider.buildWeightMatcher(pattern);
        ArrayList matched = ContainerUtil.newArrayList((Iterable)items.map(o -> {
            if (o instanceof GotoActionModel.MatchedValue) {
                return (GotoActionModel.MatchedValue)o;
            }
            Integer weight2 = GotoActionItemProvider.calcElementWeight(o, pattern, matcher);
            return weight2 != null ? new GotoActionModel.MatchedValue(o, pattern, weight2) : new GotoActionModel.MatchedValue(o, pattern);
        }));
        try {
            matched.sort((o1, o2) -> o1.compareWeights((GotoActionModel.MatchedValue)o2));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Comparison method violates its general contract with pattern '" + pattern + "'", (Throwable)e);
        }
        return ContainerUtil.process((List)matched, consumer2);
    }

    @Nullable
    private static Integer calcElementWeight(Object element2, String pattern, MinusculeMatcher matcher) {
        Integer degree = GotoActionItemProvider.calculateDegree(matcher, GotoActionItemProvider.getActionText(element2));
        if (degree == null) {
            return null;
        }
        if (Experiments.getInstance().isFeatureEnabled("i18n.match.actions") && degree == 0 && (degree = GotoActionItemProvider.calculateDegree(matcher, (String)DefaultBundleService.getInstance().compute(() -> GotoActionItemProvider.getAnActionOriginalText(GotoActionItemProvider.getAction(element2))))) == null) {
            return null;
        }
        if (pattern.trim().contains(" ")) {
            degree = degree + 100;
        }
        if (element2 instanceof OptionDescription && degree > 0) {
            degree = degree - 100;
        }
        return Math.max(degree, 0);
    }

    @Nullable
    private static Integer calculateDegree(MinusculeMatcher matcher, @Nullable String text2) {
        if (text2 == null) {
            return null;
        }
        return matcher.matchingDegree(text2);
    }

    private static MinusculeMatcher buildWeightMatcher(String pattern) {
        return NameUtil.buildMatcher((String)("*" + pattern)).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE).preferringStartMatches().build();
    }

    @Nullable
    @Nls
    public static String getActionText(Object value2) {
        if (value2 instanceof OptionDescription) {
            return ((OptionDescription)value2).getHit();
        }
        if (value2 instanceof AnAction) {
            return GotoActionItemProvider.getAnActionText((AnAction)value2);
        }
        if (value2 instanceof GotoActionModel.ActionWrapper) {
            return GotoActionItemProvider.getAnActionText(((GotoActionModel.ActionWrapper)value2).getAction());
        }
        return null;
    }

    @Nullable
    private static AnAction getAction(Object value2) {
        if (value2 instanceof AnAction) {
            return (AnAction)value2;
        }
        if (value2 instanceof GotoActionModel.ActionWrapper) {
            return ((GotoActionModel.ActionWrapper)value2).getAction();
        }
        return null;
    }

    @Nullable
    @Nls
    private static String getAnActionText(AnAction value2) {
        Presentation presentation2 = value2.getTemplatePresentation().clone();
        value2.applyTextOverride("GoToAction", presentation2);
        return presentation2.getText();
    }

    @Nullable
    private static String getAnActionOriginalText(@Nullable AnAction value2) {
        if (value2 == null) {
            return null;
        }
        Presentation presentation2 = value2.getTemplatePresentation().clone();
        value2.applyTextOverride("GoToAction", presentation2);
        return ((TextWithMnemonic)presentation2.getTextWithPossibleMnemonic().get()).getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 3: 
            case 7: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionItemProvider";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionItemProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "collectToolWindowQuickActionProviders";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 3: 
            case 7: 
            case 27: 
            case 28: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "filterElementsWithWeights";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processAbbreviations";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "wrapAnAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

