/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.pratt;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.lang.LangBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.pratt.MutableMarker;
import com.intellij.lang.pratt.PathPattern;
import com.intellij.lang.pratt.PrattBuilder;
import com.intellij.lang.pratt.PrattRegistry;
import com.intellij.lang.pratt.TokenParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrattBuilderImpl
extends PrattBuilder {
    private final PsiBuilder myBuilder;
    private final PrattBuilder myParentBuilder;
    private final PrattRegistry myRegistry;
    private final LinkedList<IElementType> myLeftSiblings = new LinkedList();
    private boolean myParsingStarted;
    private @NlsContexts.ParsingError String myExpectedMessage;
    private int myPriority = Integer.MIN_VALUE;
    private MutableMarker myStartMarker;

    private PrattBuilderImpl(PsiBuilder builder2, PrattBuilder parent, PrattRegistry registry) {
        this.myBuilder = builder2;
        this.myParentBuilder = parent;
        this.myRegistry = registry;
    }

    public static PrattBuilder createBuilder(PsiBuilder builder2, PrattRegistry registry) {
        return new PrattBuilderImpl(builder2, null, registry);
    }

    @Override
    public PrattBuilder expecting(@NlsContexts.ParsingError String expectedMessage) {
        this.myExpectedMessage = expectedMessage;
        return this;
    }

    @Override
    public PrattBuilder withLowestPriority(int priority) {
        this.myPriority = priority;
        return this;
    }

    @Override
    public Lexer getLexer() {
        return ((PsiBuilderImpl)this.myBuilder).getLexer();
    }

    @Override
    public void setTokenTypeRemapper(@Nullable ITokenTypeRemapper remapper) {
        this.myBuilder.setTokenTypeRemapper(remapper);
    }

    @Override
    public MutableMarker mark() {
        return new MutableMarker(this.myLeftSiblings, this.myBuilder.mark(), this.myLeftSiblings.size());
    }

    @Override
    @Nullable
    public IElementType parse() {
        this.checkParsed();
        return this.myLeftSiblings.size() != 1 ? null : this.myLeftSiblings.getLast();
    }

    @Override
    protected PrattBuilder createChildBuilder() {
        assert (this.myParsingStarted);
        return new PrattBuilderImpl(this.myBuilder, this, this.myRegistry){

            @Override
            protected void doParse() {
                super.doParse();
                PrattBuilderImpl.this.myLeftSiblings.addAll(this.getResultTypes());
            }
        };
    }

    protected void doParse() {
        if (this.isEof()) {
            this.error(this.myExpectedMessage != null ? this.myExpectedMessage : LangBundle.message((String)"unexpected.eof", (Object[])new Object[0]));
            return;
        }
        TokenParser parser = this.findParser();
        if (parser == null) {
            this.error(this.myExpectedMessage != null ? this.myExpectedMessage : LangBundle.message((String)"unexpected.token", (Object[])new Object[0]));
            return;
        }
        this.myStartMarker = this.mark();
        while (!this.isEof()) {
            int startOffset = this.myBuilder.getCurrentOffset();
            if (!parser.parseToken(this)) break;
            assert (startOffset < this.myBuilder.getCurrentOffset()) : "Endless loop on " + this.getTokenType();
            parser = this.findParser();
            if (parser != null) continue;
            break;
        }
        this.myStartMarker.drop();
    }

    @Nullable
    private TokenParser findParser() {
        IElementType tokenType = this.getTokenType();
        for (Trinity<Integer, PathPattern, TokenParser> trinity : this.myRegistry.getParsers(tokenType)) {
            if ((Integer)trinity.first <= this.myPriority || !((PathPattern)trinity.second).accepts(this)) continue;
            return (TokenParser)trinity.third;
        }
        return null;
    }

    @Override
    public void advance() {
        this.myLeftSiblings.addLast(this.getTokenType());
        this.myBuilder.advanceLexer();
    }

    @Override
    public void error(@NotNull @NlsContexts.ParsingError String errorText) {
        if (errorText == null) {
            PrattBuilderImpl.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.error(errorText);
        marker.drop();
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        return this.myBuilder.getTokenType();
    }

    @Override
    @Nullable
    public String getTokenText() {
        return this.myBuilder.getTokenText();
    }

    @Override
    public void reduce(@NotNull IElementType type) {
        if (type == null) {
            PrattBuilderImpl.$$$reportNull$$$0(1);
        }
        this.myStartMarker.finish(type);
        this.myStartMarker = this.myStartMarker.precede();
    }

    @Override
    @NotNull
    public List<IElementType> getResultTypes() {
        this.checkParsed();
        LinkedList<IElementType> linkedList = this.myLeftSiblings;
        if (linkedList == null) {
            PrattBuilderImpl.$$$reportNull$$$0(2);
        }
        return linkedList;
    }

    private void checkParsed() {
        if (!this.myParsingStarted) {
            this.myParsingStarted = true;
            this.doParse();
        }
    }

    @Override
    public PrattBuilder getParent() {
        return this.myParentBuilder;
    }

    @Override
    public int getPriority() {
        return this.myPriority;
    }

    @Override
    public int getCurrentOffset() {
        return this.myBuilder.getCurrentOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/pratt/PrattBuilderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/pratt/PrattBuilderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

