/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ProgressSlide;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serviceContainer.NonInjectable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName;
    private String myCopyrightStart;
    private String myShortCompanyName;
    private String myCompanyUrl;
    private long myProgressColor;
    private long myCopyrightForeground;
    private long myAboutForeground;
    private long myAboutLinkColor;
    private int[] myAboutLogoRect;
    private String myProgressTailIconName;
    private int myProgressHeight;
    private int myProgressY;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private String myIconUrl;
    private String mySmallIconUrl;
    private String myBigIconUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myToolWindowIconUrl;
    private String myWelcomeScreenLogoUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private String myPackageCode;
    private boolean myShowLicensee;
    private String myCustomizeIDEWizardStepsProvider;
    private String myCustomizeIDEWizardDialog;
    private final ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp;
    private boolean myHasContextHelp;
    private String myWebHelpUrl;
    private final List<PluginId> myEssentialPluginsIds;
    private final String myEventLogSettingsUrl;
    private String myJetBrainsTvUrl;
    private String myEvalLicenseUrl;
    private String myKeyConversionUrl;
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private final List<ProgressSlide> myProgressSlides;
    @NonNls
    private static final String ELEMENT_VERSION = "version";
    @NonNls
    private static final String ATTRIBUTE_MAJOR = "major";
    @NonNls
    private static final String ATTRIBUTE_MINOR = "minor";
    @NonNls
    private static final String ATTRIBUTE_MICRO = "micro";
    @NonNls
    private static final String ATTRIBUTE_PATCH = "patch";
    @NonNls
    private static final String ATTRIBUTE_FULL = "full";
    @NonNls
    private static final String ATTRIBUTE_CODENAME = "codename";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String ELEMENT_BUILD = "build";
    @NonNls
    private static final String ELEMENT_COMPANY = "company";
    @NonNls
    private static final String ATTRIBUTE_NUMBER = "number";
    @NonNls
    private static final String ATTRIBUTE_API_VERSION = "apiVersion";
    @NonNls
    private static final String ATTRIBUTE_DATE = "date";
    @NonNls
    private static final String ATTRIBUTE_MAJOR_RELEASE_DATE = "majorReleaseDate";
    @NonNls
    private static final String ELEMENT_LOGO = "logo";
    @NonNls
    private static final String ATTRIBUTE_URL = "url";
    @NonNls
    private static final String COPYRIGHT_START = "copyrightStart";
    @NonNls
    private static final String ATTRIBUTE_PROGRESS_COLOR = "progressColor";
    @NonNls
    private static final String ATTRIBUTE_ABOUT_FOREGROUND_COLOR = "foreground";
    @NonNls
    private static final String ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR = "copyrightForeground";
    @NonNls
    private static final String ATTRIBUTE_ABOUT_LINK_COLOR = "linkColor";
    @NonNls
    private static final String ATTRIBUTE_PROGRESS_HEIGHT = "progressHeight";
    @NonNls
    private static final String ATTRIBUTE_PROGRESS_Y = "progressY";
    @NonNls
    private static final String ATTRIBUTE_PROGRESS_TAIL_ICON = "progressTailIcon";
    @NonNls
    private static final String ELEMENT_ABOUT = "about";
    @NonNls
    private static final String ELEMENT_ICON = "icon";
    @NonNls
    private static final String ATTRIBUTE_SIZE16 = "size16";
    @NonNls
    private static final String ATTRIBUTE_SIZE12 = "size12";
    @NonNls
    private static final String ELEMENT_PACKAGE = "package";
    @NonNls
    private static final String ATTRIBUTE_CODE = "code";
    @NonNls
    private static final String ELEMENT_LICENSEE = "licensee";
    @NonNls
    private static final String ATTRIBUTE_SHOW = "show";
    @NonNls
    private static final String WELCOME_SCREEN_ELEMENT_NAME = "welcome-screen";
    @NonNls
    private static final String LOGO_URL_ATTR = "logo-url";
    @NonNls
    private static final String UPDATE_URLS_ELEMENT_NAME = "update-urls";
    @NonNls
    private static final String ATTRIBUTE_EAP = "eap";
    @NonNls
    private static final String HELP_ELEMENT_NAME = "help";
    @NonNls
    private static final String ELEMENT_DOCUMENTATION = "documentation";
    @NonNls
    private static final String ELEMENT_SUPPORT = "support";
    @NonNls
    private static final String ELEMENT_YOUTRACK = "youtrack";
    @NonNls
    private static final String ELEMENT_FEEDBACK = "feedback";
    @NonNls
    private static final String ELEMENT_PLUGINS = "plugins";
    @NonNls
    private static final String ATTRIBUTE_LIST_URL = "list-url";
    @NonNls
    private static final String ATTRIBUTE_CHANNEL_LIST_URL = "channel-list-url";
    @NonNls
    private static final String ATTRIBUTE_DOWNLOAD_URL = "download-url";
    @NonNls
    private static final String ATTRIBUTE_BUILTIN_URL = "builtin-url";
    @NonNls
    private static final String ATTRIBUTE_WEBHELP_URL = "webhelp-url";
    @NonNls
    private static final String ATTRIBUTE_HAS_HELP = "has-help";
    @NonNls
    private static final String ATTRIBUTE_HAS_CONTEXT_HELP = "has-context-help";
    @NonNls
    private static final String ELEMENT_WHATS_NEW = "whatsnew";
    @NonNls
    private static final String ELEMENT_KEYMAP = "keymap";
    @NonNls
    private static final String ATTRIBUTE_WINDOWS_URL = "win";
    @NonNls
    private static final String ATTRIBUTE_MAC_URL = "mac";
    @NonNls
    private static final String ELEMENT_STATISTICS = "statistics";
    @NonNls
    private static final String ATTRIBUTE_EVENT_LOG_STATISTICS_SETTINGS = "event-log-settings";
    @NonNls
    private static final String ELEMENT_JB_TV = "jetbrains-tv";
    @NonNls
    private static final String CUSTOMIZE_IDE_WIZARD_STEPS = "customize-ide-wizard";
    @NonNls
    private static final String STEPS_PROVIDER = "provider";
    @NonNls
    private static final String WIZARD_DIALOG = "dialog";
    @NonNls
    private static final String ELEMENT_EVALUATION = "evaluation";
    @NonNls
    private static final String ATTRIBUTE_EVAL_LICENSE_URL = "license-url";
    @NonNls
    private static final String ELEMENT_LICENSING = "licensing";
    @NonNls
    private static final String ATTRIBUTE_KEY_CONVERSION_URL = "key-conversion-url";
    @NonNls
    private static final String ESSENTIAL_PLUGIN = "essential-plugin";
    @NonNls
    private static final String ELEMENT_SUBSCRIPTIONS = "subscriptions";
    @NonNls
    private static final String ATTRIBUTE_SUBSCRIPTIONS_FORM_ID = "formid";
    @NonNls
    private static final String ATTRIBUTE_SUBSCRIPTIONS_NEWS_KEY = "news-key";
    @NonNls
    private static final String ATTRIBUTE_SUBSCRIPTIONS_NEWS_VALUE = "news-value";
    @NonNls
    private static final String ATTRIBUTE_SUBSCRIPTIONS_TIPS_KEY = "tips-key";
    @NonNls
    private static final String ATTRIBUTE_SUBSCRIPTIONS_TIPS_AVAILABLE = "tips-available";
    @NonNls
    private static final String ATTRIBUTE_SUBSCRIPTIONS_ADDITIONAL_FORM_DATA = "additional-form-data";
    @NonNls
    private static final String PROGRESS_SLIDE = "progressSlide";
    @NonNls
    private static final String PROGRESS_PERCENT = "progressPercent";
    static final String DEFAULT_PLUGINS_HOST = "https://plugins.jetbrains.com";
    static final String IDEA_PLUGINS_HOST_PROPERTY = "idea.plugins.host";
    private static volatile ApplicationInfoImpl instance;
    private static volatile boolean myInStressTest;

    private ApplicationInfoImpl() {
        this(ApplicationNamesInfo.initAndGetRawData());
    }

    @NonInjectable
    ApplicationInfoImpl(@NotNull Element element2) {
        Element subscriptionsElement;
        String url;
        Element licensingElement;
        String url2;
        Element evaluationElement;
        List<Element> essentialPluginsElements;
        Element whatsNewElement;
        Element feedbackElement;
        Element youtrackElement;
        Element supportElement;
        Element updateUrls;
        Element helpElement;
        Element wizardSteps;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconEap;
        Element iconElement;
        Element aboutLogoElement;
        Element logoElement;
        Element buildElement;
        Element companyElement;
        if (element2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        this.myCompanyName = "JetBrains s.r.o.";
        this.myCopyrightStart = "2000";
        this.myCompanyUrl = "https://www.jetbrains.com/";
        this.myProgressColor = -1L;
        this.myCopyrightForeground = -1L;
        this.myAboutForeground = -1L;
        this.myAboutLinkColor = -1L;
        this.myProgressHeight = 2;
        this.myProgressY = 350;
        this.myIconUrl = "/icon.png";
        this.mySmallIconUrl = "/icon_small.png";
        this.myToolWindowIconUrl = "/toolwindows/toolWindowProject.png";
        this.myShowLicensee = true;
        this.myHasHelp = true;
        this.myHasContextHelp = true;
        this.myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
        this.myEvalLicenseUrl = "https://www.jetbrains.com/store/license.html";
        this.myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
        this.myProgressSlides = new ArrayList<ProgressSlide>();
        Element versionElement = ApplicationInfoImpl.getChild(element2, ELEMENT_VERSION);
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue(ATTRIBUTE_MAJOR);
            this.myMinorVersion = versionElement.getAttributeValue(ATTRIBUTE_MINOR);
            this.myMicroVersion = versionElement.getAttributeValue(ATTRIBUTE_MICRO);
            this.myPatchVersion = versionElement.getAttributeValue(ATTRIBUTE_PATCH);
            this.myFullVersionFormat = versionElement.getAttributeValue(ATTRIBUTE_FULL);
            this.myCodeName = versionElement.getAttributeValue(ATTRIBUTE_CODENAME);
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue(ATTRIBUTE_EAP));
            this.myVersionSuffix = versionElement.getAttributeValue("suffix");
            if (this.myVersionSuffix == null && this.myEAP) {
                this.myVersionSuffix = "EAP";
            }
        }
        if ((companyElement = ApplicationInfoImpl.getChild(element2, ELEMENT_COMPANY)) != null) {
            this.myCompanyName = companyElement.getAttributeValue(ATTRIBUTE_NAME, this.myCompanyName);
            this.myShortCompanyName = companyElement.getAttributeValue("shortName", ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
            this.myCompanyUrl = companyElement.getAttributeValue(ATTRIBUTE_URL, this.myCompanyUrl);
            this.myCopyrightStart = companyElement.getAttributeValue(COPYRIGHT_START, this.myCopyrightStart);
        }
        if ((buildElement = ApplicationInfoImpl.getChild(element2, ELEMENT_BUILD)) != null) {
            this.readBuildInfo(buildElement);
        }
        if ((logoElement = ApplicationInfoImpl.getChild(element2, ELEMENT_LOGO)) != null) {
            this.readLogoInfo(logoElement);
        }
        if ((aboutLogoElement = ApplicationInfoImpl.getChild(element2, ELEMENT_ABOUT)) != null) {
            String c;
            this.myAboutImageUrl = aboutLogoElement.getAttributeValue(ATTRIBUTE_URL);
            String v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_FOREGROUND_COLOR);
            if (v != null) {
                this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR)) != null) {
                this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((c = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_LINK_COLOR)) != null) {
                this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
            }
            String logoX = aboutLogoElement.getAttributeValue("logoX");
            String logoY = aboutLogoElement.getAttributeValue("logoY");
            String logoW = aboutLogoElement.getAttributeValue("logoW");
            String logoH = aboutLogoElement.getAttributeValue("logoH");
            if (logoX != null && logoY != null && logoW != null && logoH != null) {
                try {
                    this.myAboutLogoRect = new int[]{Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH)};
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((iconElement = ApplicationInfoImpl.getChild(element2, ELEMENT_ICON)) != null) {
            this.myIconUrl = iconElement.getAttributeValue("size32");
            this.mySmallIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE16, this.mySmallIconUrl);
            this.myBigIconUrl = ApplicationInfoImpl.getAttributeValue(iconElement, "size128");
            String toolWindowIcon = ApplicationInfoImpl.getAttributeValue(iconElement, ATTRIBUTE_SIZE12);
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
            this.mySvgIconUrl = iconElement.getAttributeValue("svg");
            this.mySmallSvgIconUrl = iconElement.getAttributeValue("svg-small");
        }
        if ((iconEap = ApplicationInfoImpl.getChild(element2, "icon-eap")) != null) {
            this.mySvgEapIconUrl = iconEap.getAttributeValue("svg");
            this.mySmallSvgEapIconUrl = iconEap.getAttributeValue("svg-small");
        }
        if ((packageElement = ApplicationInfoImpl.getChild(element2, ELEMENT_PACKAGE)) != null) {
            this.myPackageCode = packageElement.getAttributeValue(ATTRIBUTE_CODE);
        }
        if ((showLicensee = ApplicationInfoImpl.getChild(element2, ELEMENT_LICENSEE)) != null) {
            this.myShowLicensee = Boolean.parseBoolean(showLicensee.getAttributeValue(ATTRIBUTE_SHOW));
        }
        if ((welcomeScreen = ApplicationInfoImpl.getChild(element2, WELCOME_SCREEN_ELEMENT_NAME)) != null) {
            this.myWelcomeScreenLogoUrl = welcomeScreen.getAttributeValue(LOGO_URL_ATTR);
        }
        if ((wizardSteps = ApplicationInfoImpl.getChild(element2, CUSTOMIZE_IDE_WIZARD_STEPS)) != null) {
            this.myCustomizeIDEWizardStepsProvider = wizardSteps.getAttributeValue(STEPS_PROVIDER);
            this.myCustomizeIDEWizardDialog = ApplicationInfoImpl.getAttributeValue(wizardSteps, WIZARD_DIALOG);
        }
        if ((helpElement = ApplicationInfoImpl.getChild(element2, HELP_ELEMENT_NAME)) != null) {
            String attValue;
            String webHelpUrl = ApplicationInfoImpl.getAttributeValue(helpElement, ATTRIBUTE_WEBHELP_URL);
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
            this.myHasHelp = (attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_HELP)) == null || Boolean.parseBoolean(attValue);
            attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_CONTEXT_HELP);
            this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
        }
        this.myUpdateUrls = (updateUrls = ApplicationInfoImpl.getChild(element2, UPDATE_URLS_ELEMENT_NAME)) == null ? null : new UpdateUrlsImpl(updateUrls);
        Element documentationElement = ApplicationInfoImpl.getChild(element2, ELEMENT_DOCUMENTATION);
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((supportElement = ApplicationInfoImpl.getChild(element2, ELEMENT_SUPPORT)) != null) {
            this.mySupportUrl = supportElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((youtrackElement = ApplicationInfoImpl.getChild(element2, ELEMENT_YOUTRACK)) != null) {
            this.myYoutrackUrl = youtrackElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((feedbackElement = ApplicationInfoImpl.getChild(element2, ELEMENT_FEEDBACK)) != null) {
            this.myFeedbackUrl = feedbackElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((whatsNewElement = ApplicationInfoImpl.getChild(element2, ELEMENT_WHATS_NEW)) != null) {
            this.myWhatsNewUrl = whatsNewElement.getAttributeValue(ATTRIBUTE_URL);
        }
        this.readPluginInfo(ApplicationInfoImpl.getChild(element2, ELEMENT_PLUGINS));
        Element keymapElement = ApplicationInfoImpl.getChild(element2, ELEMENT_KEYMAP);
        if (keymapElement != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_WINDOWS_URL);
            this.myMacKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_MAC_URL);
        }
        if ((essentialPluginsElements = ApplicationInfoImpl.getChildren(element2, ESSENTIAL_PLUGIN)).isEmpty()) {
            this.myEssentialPluginsIds = Collections.emptyList();
        } else {
            ArrayList<Object> essentialPluginsIds = new ArrayList<Object>(essentialPluginsElements.size());
            for (Element element1 : essentialPluginsElements) {
                String id2 = element1.getTextTrim();
                if (id2.isEmpty()) continue;
                essentialPluginsIds.add(PluginId.getId((String)id2));
            }
            essentialPluginsIds.sort(null);
            this.myEssentialPluginsIds = Collections.unmodifiableList(essentialPluginsIds);
        }
        Element statisticsElement = ApplicationInfoImpl.getChild(element2, ELEMENT_STATISTICS);
        this.myEventLogSettingsUrl = statisticsElement != null ? statisticsElement.getAttributeValue(ATTRIBUTE_EVENT_LOG_STATISTICS_SETTINGS) : "https://resources.jetbrains.com/storage/fus/config/v4/%s/%s.json";
        Element tvElement = ApplicationInfoImpl.getChild(element2, ELEMENT_JB_TV);
        if (tvElement != null) {
            this.myJetBrainsTvUrl = tvElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((evaluationElement = ApplicationInfoImpl.getChild(element2, ELEMENT_EVALUATION)) != null && (url2 = ApplicationInfoImpl.getAttributeValue(evaluationElement, ATTRIBUTE_EVAL_LICENSE_URL)) != null) {
            this.myEvalLicenseUrl = url2.trim();
        }
        if ((licensingElement = ApplicationInfoImpl.getChild(element2, ELEMENT_LICENSING)) != null && (url = ApplicationInfoImpl.getAttributeValue(licensingElement, ATTRIBUTE_KEY_CONVERSION_URL)) != null) {
            this.myKeyConversionUrl = url.trim();
        }
        if ((subscriptionsElement = ApplicationInfoImpl.getChild(element2, ELEMENT_SUBSCRIPTIONS)) != null) {
            this.mySubscriptionFormId = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_FORM_ID);
            this.mySubscriptionNewsKey = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_NEWS_KEY);
            this.mySubscriptionNewsValue = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_NEWS_VALUE, "yes");
            this.mySubscriptionTipsKey = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_TIPS_KEY);
            this.mySubscriptionTipsAvailable = Boolean.parseBoolean(subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_TIPS_AVAILABLE));
            this.mySubscriptionAdditionalFormData = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_ADDITIONAL_FORM_DATA);
        }
    }

    private void readLogoInfo(@NotNull Element element2) {
        if (element2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        this.mySplashImageUrl = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_URL);
        String v = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_PROGRESS_COLOR);
        if (v != null) {
            this.myProgressColor = ApplicationInfoImpl.parseColor(v);
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_PROGRESS_TAIL_ICON)) != null) {
            this.myProgressTailIconName = v;
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_PROGRESS_HEIGHT)) != null) {
            this.myProgressHeight = Integer.parseInt(v);
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_PROGRESS_Y)) != null) {
            this.myProgressY = Integer.parseInt(v);
        }
        for (Element child2 : ApplicationInfoImpl.getChildren(element2, PROGRESS_SLIDE)) {
            String slideUrl = child2.getAttributeValue(ATTRIBUTE_URL);
            assert (slideUrl != null);
            String progressPercentString = child2.getAttributeValue(PROGRESS_PERCENT);
            assert (progressPercentString != null);
            int progressPercentInt = Integer.parseInt(progressPercentString);
            assert (progressPercentInt <= 100 && progressPercentInt >= 0);
            float progressPercentFloat = (float)progressPercentInt / 100.0f;
            this.myProgressSlides.add(new ProgressSlide(slideUrl, progressPercentFloat));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        ApplicationInfoImpl result2 = instance;
        if (result2 != null) {
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(2);
            }
            return applicationInfoImpl;
        }
        Class<ApplicationInfoImpl> clazz = ApplicationInfoImpl.class;
        synchronized (ApplicationInfoImpl.class) {
            result2 = instance;
            if (result2 == null) {
                Activity activity = StartUpMeasurer.startActivity((String)"app info loading");
                try {
                    instance = result2 = new ApplicationInfoImpl(ApplicationNamesInfo.initAndGetRawData());
                }
                finally {
                    activity.end();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(3);
            }
            return applicationInfoImpl;
        }
    }

    public Calendar getBuildDate() {
        return this.myBuildDate;
    }

    @Override
    public Calendar getMajorReleaseBuildDate() {
        return this.myMajorReleaseBuildDate != null ? this.myMajorReleaseBuildDate : this.myBuildDate;
    }

    @NotNull
    public BuildNumber getBuild() {
        BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString((String)this.myBuildNumber));
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        return buildNumber;
    }

    @NotNull
    public String getApiVersion() {
        String string = this.getApiVersionAsNumber().asString();
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public BuildNumber getApiVersionAsNumber() {
        BuildNumber api;
        BuildNumber build2 = this.getBuild();
        if (this.myApiVersion != null && (api = BuildNumber.fromStringWithProductCode((String)this.myApiVersion, (String)build2.getProductCode())) != null) {
            BuildNumber buildNumber = api;
            if (buildNumber == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(6);
            }
            return buildNumber;
        }
        BuildNumber buildNumber = build2;
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(7);
        }
        return buildNumber;
    }

    public String getMajorVersion() {
        return this.myMajorVersion;
    }

    public String getMinorVersion() {
        return this.myMinorVersion;
    }

    public String getMicroVersion() {
        return this.myMicroVersion;
    }

    public String getPatchVersion() {
        return this.myPatchVersion;
    }

    @NotNull
    public String getFullVersion() {
        String result2 = this.myFullVersionFormat != null ? MessageFormat.format(this.myFullVersionFormat, this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion) : StringUtilRt.notNullize((String)this.myMajorVersion, (String)"0") + '.' + StringUtilRt.notNullize((String)this.myMinorVersion, (String)"0");
        if (!StringUtilRt.isEmpty((CharSequence)this.myVersionSuffix)) {
            result2 = result2 + " " + this.myVersionSuffix;
        }
        String string = result2;
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getStrictVersion() {
        String string = this.myMajorVersion + "." + this.myMinorVersion + "." + StringUtilRt.notNullize((String)this.myMicroVersion, (String)"0") + "." + StringUtilRt.notNullize((String)this.myPatchVersion, (String)"0");
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    public String getVersionName() {
        String fullName = ApplicationNamesInfo.getInstance().getFullProductName();
        if (this.myEAP && !StringUtilRt.isEmptyOrSpaces((CharSequence)this.myCodeName)) {
            fullName = fullName + " (" + this.myCodeName + ")";
        }
        return fullName;
    }

    public String getShortCompanyName() {
        return this.myShortCompanyName;
    }

    public String getCompanyName() {
        return this.myCompanyName;
    }

    public String getCompanyURL() {
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(this.myCompanyUrl);
    }

    @Override
    public String getSplashImageUrl() {
        return this.mySplashImageUrl;
    }

    @Override
    public String getAboutImageUrl() {
        return this.myAboutImageUrl;
    }

    @Override
    public long getProgressColor() {
        return this.myProgressColor;
    }

    @Override
    public long getCopyrightForeground() {
        return this.myCopyrightForeground;
    }

    @Override
    public int getProgressHeight() {
        return this.myProgressHeight;
    }

    @Override
    public int getProgressY() {
        return this.myProgressY;
    }

    @Override
    @Nullable
    public String getProgressTailIcon() {
        return this.myProgressTailIconName;
    }

    @Override
    public String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    @NotNull
    public String getSmallIconUrl() {
        String string = this.mySmallIconUrl;
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    public String getBigIconUrl() {
        return this.myBigIconUrl;
    }

    @Override
    @Nullable
    public String getApplicationSvgIconUrl() {
        return this.isEAP() && this.mySvgEapIconUrl != null ? this.mySvgEapIconUrl : this.mySvgIconUrl;
    }

    @Override
    @Nullable
    public String getSmallApplicationSvgIconUrl() {
        return this.isEAP() && this.mySmallSvgEapIconUrl != null ? this.mySmallSvgEapIconUrl : this.mySmallSvgIconUrl;
    }

    @Override
    public String getToolWindowIconUrl() {
        return this.myToolWindowIconUrl;
    }

    @Override
    @Nullable
    public String getWelcomeScreenLogoUrl() {
        return this.myWelcomeScreenLogoUrl;
    }

    @Override
    @Nullable
    public String getCustomizeIDEWizardDialog() {
        return this.myCustomizeIDEWizardDialog;
    }

    @Override
    @Nullable
    public String getCustomizeIDEWizardStepsProvider() {
        return this.myCustomizeIDEWizardStepsProvider;
    }

    @Override
    public String getPackageCode() {
        return this.myPackageCode;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    @Override
    public boolean isMajorEAP() {
        return this.myEAP && (this.myMinorVersion == null || this.myMinorVersion.indexOf(46) < 0);
    }

    @Override
    @Nullable
    public ApplicationInfoEx.UpdateUrls getUpdateUrls() {
        return this.myUpdateUrls;
    }

    @Override
    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    @Override
    public String getSupportUrl() {
        return this.mySupportUrl;
    }

    @Override
    public String getYoutrackUrl() {
        return this.myYoutrackUrl;
    }

    @Override
    public String getFeedbackUrl() {
        return this.myFeedbackUrl;
    }

    @Override
    public String getPluginManagerUrl() {
        return this.myPluginManagerUrl;
    }

    @Override
    public boolean usesJetBrainsPluginRepository() {
        return DEFAULT_PLUGINS_HOST.equalsIgnoreCase(this.myPluginManagerUrl);
    }

    @Override
    public String getPluginsListUrl() {
        return this.myPluginsListUrl;
    }

    @Override
    public String getChannelsListUrl() {
        return this.myChannelsListUrl;
    }

    @Override
    public String getPluginsDownloadUrl() {
        return this.myPluginsDownloadUrl;
    }

    @Override
    public String getBuiltinPluginsUrl() {
        return this.myBuiltinPluginsUrl;
    }

    @Override
    public String getWebHelpUrl() {
        return this.myWebHelpUrl;
    }

    public boolean hasHelp() {
        return this.myHasHelp;
    }

    public boolean hasContextHelp() {
        return this.myHasContextHelp;
    }

    @Override
    public String getWhatsNewUrl() {
        return this.myWhatsNewUrl;
    }

    @Override
    public String getWinKeymapUrl() {
        return this.myWinKeymapUrl;
    }

    @Override
    public String getMacKeymapUrl() {
        return this.myMacKeymapUrl;
    }

    @Override
    public long getAboutForeground() {
        return this.myAboutForeground;
    }

    @Override
    public long getAboutLinkColor() {
        return this.myAboutLinkColor;
    }

    public String getFullApplicationName() {
        return this.getVersionName() + " " + this.getFullVersion();
    }

    @Override
    public boolean showLicenseeInfo() {
        return this.myShowLicensee;
    }

    @Override
    public String getCopyrightStart() {
        return this.myCopyrightStart;
    }

    public String getEventLogSettingsUrl() {
        return this.myEventLogSettingsUrl;
    }

    public String getJetBrainsTvUrl() {
        return this.myJetBrainsTvUrl;
    }

    public String getEvalLicenseUrl() {
        return this.myEvalLicenseUrl;
    }

    public String getKeyConversionUrl() {
        return this.myKeyConversionUrl;
    }

    @Override
    public int @Nullable [] getAboutLogoRect() {
        return this.myAboutLogoRect;
    }

    @Override
    public String getSubscriptionFormId() {
        return this.mySubscriptionFormId;
    }

    @Override
    public String getSubscriptionNewsKey() {
        return this.mySubscriptionNewsKey;
    }

    @Override
    public String getSubscriptionNewsValue() {
        return this.mySubscriptionNewsValue;
    }

    @Override
    public String getSubscriptionTipsKey() {
        return this.mySubscriptionTipsKey;
    }

    @Override
    public boolean areSubscriptionTipsAvailable() {
        return this.mySubscriptionTipsAvailable;
    }

    @Override
    @Nullable
    public String getSubscriptionAdditionalFormData() {
        return this.mySubscriptionAdditionalFormData;
    }

    @Override
    public List<ProgressSlide> getProgressSlides() {
        return this.myProgressSlides;
    }

    @Nullable
    private static String getAttributeValue(@NotNull Element element2, @NotNull String name) {
        String value2;
        if (element2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(11);
        }
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(12);
        }
        return (value2 = element2.getAttributeValue(name)) == null || value2.isEmpty() ? null : value2;
    }

    private void readBuildInfo(@NotNull Element element2) {
        String majorReleaseDateString;
        if (element2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(13);
        }
        this.myBuildNumber = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_NUMBER);
        this.myApiVersion = ApplicationInfoImpl.getAttributeValue(element2, ATTRIBUTE_API_VERSION);
        String dateString = element2.getAttributeValue(ATTRIBUTE_DATE);
        if ("__BUILD_DATE__".equals(dateString)) {
            this.myBuildDate = new GregorianCalendar();
            try (JarFile bootstrapJar2 = new JarFile(PathManager.getHomePath() + "/lib/bootstrap.jar");){
                JarEntry jarEntry = bootstrapJar2.entries().nextElement();
                this.myBuildDate.setTime(new Date(jarEntry.getTime()));
            }
            catch (Exception bootstrapJar2) {}
        } else {
            this.myBuildDate = dateString == null ? Calendar.getInstance() : ApplicationInfoImpl.parseDate(dateString);
        }
        if ((majorReleaseDateString = element2.getAttributeValue(ATTRIBUTE_MAJOR_RELEASE_DATE)) != null) {
            this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
        }
    }

    private void readPluginInfo(@Nullable Element element2) {
        String pluginsHost;
        String pluginManagerUrl = DEFAULT_PLUGINS_HOST;
        String pluginsListUrl = null;
        this.myChannelsListUrl = null;
        this.myPluginsDownloadUrl = null;
        if (element2 != null) {
            String builtinPluginsUrl;
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url = element2.getAttributeValue(ATTRIBUTE_URL);
            if (url != null) {
                String string = pluginManagerUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            }
            if ((listUrl = element2.getAttributeValue(ATTRIBUTE_LIST_URL)) != null) {
                pluginsListUrl = listUrl;
            }
            if ((channelListUrl = element2.getAttributeValue(ATTRIBUTE_CHANNEL_LIST_URL)) != null) {
                this.myChannelsListUrl = channelListUrl;
            }
            if ((downloadUrl = element2.getAttributeValue(ATTRIBUTE_DOWNLOAD_URL)) != null) {
                this.myPluginsDownloadUrl = downloadUrl;
            }
            if (StringUtil.isNotEmpty((String)(builtinPluginsUrl = element2.getAttributeValue(ATTRIBUTE_BUILTIN_URL)))) {
                this.myBuiltinPluginsUrl = builtinPluginsUrl;
            }
        }
        if ((pluginsHost = System.getProperty(IDEA_PLUGINS_HOST_PROPERTY)) != null) {
            pluginManagerUrl = pluginsHost.endsWith("/") ? pluginsHost.substring(0, pluginsHost.length() - 1) : pluginsHost;
            this.myPluginsDownloadUrl = null;
            this.myChannelsListUrl = null;
            pluginsListUrl = null;
        }
        this.myPluginManagerUrl = pluginManagerUrl;
        String string = this.myPluginsListUrl = pluginsListUrl == null ? pluginManagerUrl + "/plugins/list/" : pluginsListUrl;
        if (this.myChannelsListUrl == null) {
            this.myChannelsListUrl = pluginManagerUrl + "/channels/list/";
        }
        if (this.myPluginsDownloadUrl == null) {
            this.myPluginsDownloadUrl = pluginManagerUrl + "/pluginManager/";
        }
    }

    @NotNull
    private static List<Element> getChildren(@NotNull Element parentNode, @NotNull String name) {
        if (parentNode == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(15);
        }
        List list2 = parentNode.getChildren(name, parentNode.getNamespace());
        if (list2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    private static Element getChild(@NotNull Element parentNode, @NotNull String name) {
        if (parentNode == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(17);
        }
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(18);
        }
        return parentNode.getChild(name, parentNode.getNamespace());
    }

    @TestOnly
    static String shortenCompanyName(@NotNull String name) {
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(19);
        }
        if (name.endsWith(" s.r.o.")) {
            name = name.substring(0, name.length() - " s.r.o.".length());
        }
        if (name.endsWith(" Inc.")) {
            name = name.substring(0, name.length() - " Inc.".length());
        }
        return name;
    }

    @NotNull
    private static GregorianCalendar parseDate(@NotNull String dateString) {
        if (dateString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(20);
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GregorianCalendar gregorianCalendar = calendar;
        if (gregorianCalendar == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(21);
        }
        return gregorianCalendar;
    }

    public static long parseColor(@NotNull String colorString) {
        if (colorString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(22);
        }
        return Long.parseLong(colorString, 16);
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(23);
        }
        return "com.intellij".equals(pluginId) || this.isEssentialPlugin(PluginId.getId((String)pluginId));
    }

    @Override
    public boolean isEssentialPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(24);
        }
        return PluginManagerCore.CORE_ID == pluginId || Collections.binarySearch(this.myEssentialPluginsIds, pluginId) >= 0;
    }

    @Override
    @NotNull
    public List<PluginId> getEssentialPluginsIds() {
        List<PluginId> list2 = this.myEssentialPluginsIds;
        if (list2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(25);
        }
        return list2;
    }

    public static boolean isInStressTest() {
        return myInStressTest;
    }

    @TestOnly
    public static void setInStressTest(boolean inStressTest) {
        myInStressTest = inStressTest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateString";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorString";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersionAsNumber";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallIconUrl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDate";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEssentialPluginsIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readLogoInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readBuildInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shortenCompanyName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseColor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private final String myCheckingUrl;
        private final String myPatchesUrl;

        private UpdateUrlsImpl(@NotNull Element element2) {
            if (element2 == null) {
                UpdateUrlsImpl.$$$reportNull$$$0(0);
            }
            this.myCheckingUrl = element2.getAttributeValue("check");
            this.myPatchesUrl = element2.getAttributeValue("patches");
        }

        @Override
        public String getCheckingUrl() {
            return this.myCheckingUrl;
        }

        @Override
        public String getPatchesUrl() {
            return this.myPatchesUrl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/application/impl/ApplicationInfoImpl$UpdateUrlsImpl", "<init>"));
        }
    }
}

