/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.EditorChangeAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UndoableGroup
implements Dumpable {
    private static final Logger LOG = Logger.getInstance(UndoableGroup.class);
    private static final int BULK_MODE_ACTION_THRESHOLD = 50;
    private final @NlsContexts.Command String myCommandName;
    private final boolean myGlobal;
    private final int myCommandTimestamp;
    private final boolean myTransparent;
    private final List<UndoableAction> myActions;
    private EditorAndState myStateBefore;
    private EditorAndState myStateAfter;
    private final Project myProject;
    private final UndoConfirmationPolicy myConfirmationPolicy;
    private boolean myTemporary;
    private boolean myValid;

    UndoableGroup(@NlsContexts.Command String commandName2, boolean isGlobal, UndoManagerImpl manager2, EditorAndState stateBefore, EditorAndState stateAfter, List<UndoableAction> actions, UndoConfirmationPolicy confirmationPolicy, boolean transparent, boolean valid) {
        this.myCommandName = commandName2;
        this.myGlobal = isGlobal;
        this.myCommandTimestamp = manager2.nextCommandTimestamp();
        this.myActions = actions;
        this.myProject = manager2.getProject();
        this.myStateBefore = stateBefore;
        this.myStateAfter = stateAfter;
        this.myConfirmationPolicy = confirmationPolicy;
        this.myTransparent = transparent;
        this.myValid = valid;
        this.composeStartFinishGroup(manager2.getUndoStacksHolder());
        this.myTemporary = transparent;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public boolean isTransparent() {
        return this.myTransparent;
    }

    public boolean isTemporary() {
        return this.myTemporary;
    }

    public void makePermanent() {
        this.myTemporary = false;
    }

    public boolean isUndoable() {
        for (UndoableAction action2 : this.myActions) {
            if (!(action2 instanceof NonUndoableAction)) continue;
            return false;
        }
        return true;
    }

    public void undo() {
        this.undoOrRedo(true);
    }

    public void redo() {
        this.undoOrRedo(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoOrRedo(boolean isUndo) {
        LocalHistoryAction action2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing " + (isUndo ? "undo" : "redo") + " for " + this.dumpState());
        }
        if (this.myProject != null && this.isGlobal()) {
            String actionName = IdeBundle.message((String)(isUndo ? "undo.command" : "redo.command"), (Object[])new Object[]{this.myCommandName});
            action2 = LocalHistory.getInstance().startAction(actionName);
        } else {
            action2 = LocalHistoryAction.NULL;
        }
        try {
            this.doUndoOrRedo(isUndo);
        }
        finally {
            action2.finish();
        }
    }

    private void doUndoOrRedo(boolean isUndo) {
        UnexpectedUndoException[] exception = new UnexpectedUndoException[]{null};
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                List actionsList = isUndo ? ContainerUtil.reverse(this.myActions) : this.myActions;
                int toProcess = 0;
                int toProcessInBulk = 0;
                int actionCount = actionsList.size();
                for (int i2 = 0; i2 < actionCount; ++i2) {
                    UndoableAction action2 = (UndoableAction)actionsList.get(i2);
                    DocumentEx newDocument = UndoableGroup.getDocumentToSetBulkMode(action2);
                    if (newDocument != null) continue;
                    if (i2 - toProcessInBulk > 50) {
                        UndoableGroup.performActions(actionsList.subList(toProcess, toProcessInBulk), isUndo, false);
                        UndoableGroup.performActions(actionsList.subList(toProcessInBulk, i2), isUndo, true);
                        toProcess = i2;
                    }
                    toProcessInBulk = i2 + 1;
                }
                if (actionCount - toProcessInBulk > 50) {
                    UndoableGroup.performActions(actionsList.subList(toProcess, toProcessInBulk), isUndo, false);
                    UndoableGroup.performActions(actionsList.subList(toProcessInBulk, actionCount), isUndo, true);
                } else {
                    UndoableGroup.performActions(actionsList.subList(toProcess, actionCount), isUndo, false);
                }
            }
            catch (UnexpectedUndoException e) {
                exception[0] = e;
            }
        });
        if (exception[0] != null) {
            this.reportUndoProblem(exception[0], isUndo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performActions(@NotNull Collection<? extends UndoableAction> actions, boolean isUndo, boolean useBulkMode) throws UnexpectedUndoException {
        if (actions == null) {
            UndoableGroup.$$$reportNull$$$0(0);
        }
        HashSet<DocumentEx> bulkDocuments = new HashSet<DocumentEx>();
        try {
            for (UndoableAction undoableAction : actions) {
                if (useBulkMode) {
                    DocumentEx newDocument = UndoableGroup.getDocumentToSetBulkMode(undoableAction);
                    if (newDocument == null) {
                        for (DocumentEx document : bulkDocuments) {
                            document.setInBulkUpdate(false);
                        }
                        bulkDocuments.clear();
                    } else if (bulkDocuments.add(newDocument)) {
                        newDocument.setInBulkUpdate(true);
                    }
                }
                if (isUndo) {
                    undoableAction.undo();
                    continue;
                }
                undoableAction.redo();
            }
        }
        finally {
            for (DocumentEx documentEx : bulkDocuments) {
                documentEx.setInBulkUpdate(false);
            }
        }
    }

    @NotNull
    public String dumpState() {
        String string = "UndoableGroup[project=" + this.myProject + ", name=" + this.myCommandName + ", global=" + this.myGlobal + ", transparent=" + this.myTransparent + ", stamp=" + this.myCommandTimestamp + ", policy=" + this.myConfirmationPolicy + ", temporary=" + this.myTemporary + ", valid=" + this.myValid + ", actions=" + this.myActions + ", documents=" + this.getAffectedDocuments() + "]";
        if (string == null) {
            UndoableGroup.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static DocumentEx getDocumentToSetBulkMode(UndoableAction action2) {
        if (!(action2 instanceof EditorChangeAction)) {
            return null;
        }
        DocumentReference newDocumentRef = action2.getAffectedDocuments()[0];
        if (newDocumentRef == null) {
            return null;
        }
        VirtualFile file2 = newDocumentRef.getFile();
        if (file2 != null && !file2.isValid()) {
            return null;
        }
        return (DocumentEx)newDocumentRef.getDocument();
    }

    boolean isInsideStartFinishGroup(boolean isUndo, boolean isInsideStartFinishGroup) {
        int finishNmb;
        ArrayList<FinishMarkAction> finishMarks = new ArrayList<FinishMarkAction>();
        ArrayList<StartMarkAction> startMarks = new ArrayList<StartMarkAction>();
        for (UndoableAction action2 : this.myActions) {
            if (action2 instanceof StartMarkAction) {
                startMarks.add((StartMarkAction)action2);
                continue;
            }
            if (!(action2 instanceof FinishMarkAction)) continue;
            finishMarks.add((FinishMarkAction)action2);
        }
        int startNmb = startMarks.size();
        if (startNmb != (finishNmb = finishMarks.size())) {
            if (isUndo) {
                return finishNmb > startNmb;
            }
            return startNmb > finishNmb;
        }
        return isInsideStartFinishGroup;
    }

    void composeStartFinishGroup(UndoRedoStacksHolder holder) {
        FinishMarkAction finishMark = this.getFinishMark();
        if (finishMark != null) {
            boolean global = false;
            String commandName2 = null;
            LinkedList<UndoableGroup> stack = holder.getStack(finishMark.getAffectedDocument());
            Iterator<UndoableGroup> iterator2 = stack.descendingIterator();
            while (iterator2.hasNext()) {
                UndoableGroup group2 = iterator2.next();
                if (group2.isGlobal()) {
                    global = true;
                    commandName2 = group2.getCommandName();
                    break;
                }
                if (group2.getStartMark() == null) continue;
                break;
            }
            if (global) {
                finishMark.setGlobal(true);
                finishMark.setCommandName(commandName2);
            }
        }
    }

    private boolean shouldAskConfirmationForStartFinishGroup(boolean redo) {
        if (redo) {
            StartMarkAction mark = this.getStartMark();
            if (mark != null) {
                return mark.isGlobal();
            }
        } else {
            FinishMarkAction finishMark = this.getFinishMark();
            if (finishMark != null) {
                return finishMark.isGlobal();
            }
        }
        return false;
    }

    private void reportUndoProblem(UnexpectedUndoException e, boolean isUndo) {
        Object message;
        String title;
        if (isUndo) {
            title = IdeBundle.message((String)"cannot.undo.title", (Object[])new Object[0]);
            message = IdeBundle.message((String)"cannot.undo.message", (Object[])new Object[0]);
        } else {
            title = IdeBundle.message((String)"cannot.redo.title", (Object[])new Object[0]);
            message = IdeBundle.message((String)"cannot.redo.message", (Object[])new Object[0]);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (e.getMessage() != null) {
                message = (String)message + ".\n" + e.getMessage();
            }
            Messages.showMessageDialog((Project)this.myProject, (String)message, (String)title, (Icon)Messages.getErrorIcon());
        } else {
            LOG.error((Throwable)e);
        }
    }

    public List<UndoableAction> getActions() {
        return this.myActions;
    }

    @NotNull
    public Collection<DocumentReference> getAffectedDocuments() {
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>();
        for (UndoableAction action2 : this.myActions) {
            DocumentReference[] refs = action2.getAffectedDocuments();
            if (refs == null) continue;
            Collections.addAll(result2, refs);
        }
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoableGroup.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public EditorAndState getStateBefore() {
        return this.myStateBefore;
    }

    public EditorAndState getStateAfter() {
        return this.myStateAfter;
    }

    public void setStateBefore(EditorAndState stateBefore) {
        this.myStateBefore = stateBefore;
    }

    public void setStateAfter(EditorAndState stateAfter) {
        this.myStateAfter = stateAfter;
    }

    @NlsContexts.Command
    public String getCommandName() {
        for (UndoableAction action2 : this.myActions) {
            String commandName2;
            if (!(action2 instanceof StartMarkAction ? (commandName2 = ((StartMarkAction)action2).getCommandName()) != null : action2 instanceof FinishMarkAction && (commandName2 = ((FinishMarkAction)action2).getCommandName()) != null)) continue;
            return commandName2;
        }
        return this.myCommandName;
    }

    public int getCommandTimestamp() {
        return this.myCommandTimestamp;
    }

    @Nullable
    public StartMarkAction getStartMark() {
        for (UndoableAction action2 : this.myActions) {
            if (!(action2 instanceof StartMarkAction)) continue;
            return (StartMarkAction)action2;
        }
        return null;
    }

    @Nullable
    public FinishMarkAction getFinishMark() {
        for (UndoableAction action2 : this.myActions) {
            if (!(action2 instanceof FinishMarkAction)) continue;
            return (FinishMarkAction)action2;
        }
        return null;
    }

    public boolean shouldAskConfirmation(boolean redo) {
        if (this.shouldAskConfirmationForStartFinishGroup(redo)) {
            return true;
        }
        return this.myConfirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION || this.myConfirmationPolicy != UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION && this.myGlobal;
    }

    public void invalidateActionsFor(DocumentReference ref) {
        if (this.getAffectedDocuments().contains(ref)) {
            this.myValid = false;
        }
    }

    public boolean isValid() {
        return this.myValid;
    }

    public String toString() {
        boolean multiline;
        StringBuilder result2 = new StringBuilder("UndoableGroup[");
        boolean bl = multiline = this.myActions.size() > 1;
        if (multiline) {
            result2.append("\n");
        }
        result2.append(StringUtil.join(this.myActions, each -> (multiline ? "  " : "") + each.toString(), (String)",\n"));
        if (multiline) {
            result2.append("\n");
        }
        result2.append("]");
        return result2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoableGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoableGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performActions";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

