/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PersistentRangeHighlighterImpl
extends RangeHighlighterImpl {
    private int myLine;

    @NotNull
    static PersistentRangeHighlighterImpl create(@NotNull MarkupModelImpl model2, int offset, int layer, @NotNull HighlighterTargetArea target2, @Nullable TextAttributesKey textAttributesKey, boolean normalizeStartOffset) {
        if (model2 == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(0);
        }
        if (target2 == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(1);
        }
        int line = model2.getDocument().getLineNumber(offset);
        int startOffset = normalizeStartOffset ? model2.getDocument().getLineStartOffset(line) : offset;
        return new PersistentRangeHighlighterImpl(model2, startOffset, line, layer, target2, textAttributesKey);
    }

    private PersistentRangeHighlighterImpl(@NotNull MarkupModelImpl model2, int startOffset, int line, int layer, @NotNull HighlighterTargetArea target2, @Nullable TextAttributesKey textAttributesKey) {
        if (model2 == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(2);
        }
        if (target2 == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(3);
        }
        super(model2, startOffset, model2.getDocument().getLineEndOffset(line), layer, target2, textAttributesKey, false, false);
        this.myLine = line;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            PersistentRangeHighlighterImpl.$$$reportNull$$$0(4);
        }
        this.myLine = this.persistentHighlighterUpdate(e, this.myLine, this.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE);
    }

    @Override
    @NonNls
    public String toString() {
        return "PersistentRangeHighlighter" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " - " + this.myLine + (this.isGreedyToRight() ? "]" : ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/PersistentRangeHighlighterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "changedUpdateImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

