/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.RawTextWithMarkup;
import com.intellij.openapi.util.registry.Registry;
import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSyntaxAwareInputStreamTransferableData
extends InputStream
implements RawTextWithMarkup {
    private static final Logger LOG = Logger.getInstance(AbstractSyntaxAwareInputStreamTransferableData.class);
    String myRawText;
    @NotNull
    final SyntaxInfo mySyntaxInfo;
    @NotNull
    private final DataFlavor myDataFlavor;
    @Nullable
    private transient InputStream myDelegate;

    AbstractSyntaxAwareInputStreamTransferableData(@NotNull SyntaxInfo syntaxInfo, @NotNull DataFlavor flavor) {
        if (syntaxInfo == null) {
            AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(0);
        }
        if (flavor == null) {
            AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(1);
        }
        this.mySyntaxInfo = syntaxInfo;
        this.myDataFlavor = flavor;
    }

    @Override
    public DataFlavor getFlavor() {
        return this.myDataFlavor;
    }

    @Override
    public int getOffsetCount() {
        return 0;
    }

    @Override
    public int getOffsets(int[] offsets2, int index) {
        return index;
    }

    @Override
    public int setOffsets(int[] offsets2, int index) {
        return index;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        if (b == null) {
            AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(2);
        }
        return this.getDelegate().read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.myDelegate = null;
    }

    @Override
    public void setRawText(String rawText) {
        this.myRawText = rawText;
    }

    @NotNull
    private InputStream getDelegate() {
        if (this.myDelegate != null) {
            InputStream inputStream2 = this.myDelegate;
            if (inputStream2 == null) {
                AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(3);
            }
            return inputStream2;
        }
        int maxLength = Registry.intValue((String)"editor.richcopy.max.size.megabytes") * 0x100000;
        StringBuilder buffer = new StringBuilder();
        try {
            this.build(buffer, maxLength);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        String s = buffer.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting text: \n" + s);
        }
        try {
            this.myDelegate = new ByteArrayInputStream(s.getBytes(this.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        InputStream inputStream3 = this.myDelegate;
        if (inputStream3 == null) {
            AbstractSyntaxAwareInputStreamTransferableData.$$$reportNull$$$0(4);
        }
        return inputStream3;
    }

    protected abstract void build(@NotNull StringBuilder var1, int var2);

    @NotNull
    protected abstract String getCharset();

    @Override
    public synchronized void mark(int readlimit) {
        this.getDelegate().mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.getDelegate().reset();
    }

    @Override
    public boolean markSupported() {
        return this.getDelegate().markSupported();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareInputStreamTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/view/AbstractSyntaxAwareInputStreamTransferableData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

