/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExternalSystemToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    protected AbstractExternalSystemToolWindowFactory(@NotNull ProjectSystemId id2) {
        if (id2 == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(0);
        }
        this.myExternalSystemId = id2;
    }

    public boolean isApplicable(@NotNull Project project) {
        ExternalSystemManager manager2;
        if (project == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(1);
        }
        AbstractExternalSystemSettings settings = (manager2 = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId)) == null ? null : (AbstractExternalSystemSettings)manager2.getSettingsProvider().fun((Object)project);
        return settings != null && !settings.getLinkedProjectsSettings().isEmpty();
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(2);
        }
        if (toolWindow == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(3);
        }
        toolWindow.setTitle(this.myExternalSystemId.getReadableName());
        ContentManager contentManager2 = toolWindow.getContentManager();
        contentManager2.addContent((Content)new ContentImpl(this.createInitializingLabel(), "", false));
        ExternalProjectsManager.getInstance((Project)project).runWhenInitialized(() -> {
            ExternalProjectsViewImpl projectsView = new ExternalProjectsViewImpl(project, (ToolWindowEx)toolWindow, this.myExternalSystemId);
            ExternalProjectsManagerImpl.getInstance(project).registerView(projectsView);
            ContentImpl tasksContent = new ContentImpl((JComponent)((Object)projectsView), "", true);
            contentManager2.removeAllContents(true);
            contentManager2.addContent((Content)tasksContent);
        });
    }

    @NotNull
    private JLabel createInitializingLabel() {
        JLabel label2 = new JLabel(ExternalSystemBundle.message((String)"initializing.0.projects.data", (Object[])new Object[]{this.myExternalSystemId.getReadableName()}), 0);
        label2.setOpaque(true);
        JLabel jLabel = label2;
        if (jLabel == null) {
            AbstractExternalSystemToolWindowFactory.$$$reportNull$$$0(4);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ui/AbstractExternalSystemToolWindowFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitializingLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

