/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginListLayout;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.PluginUpdateResult;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUpdateDialog
extends DialogWrapper {
    private static final LinkListener<Object> NULL_LISTENER = (source, linkData) -> {};
    private final Collection<PluginDownloader> myDownloaders;
    private final MyPluginModel myPluginModel;
    private final PluginsGroupComponent myPluginsPanel;
    private final PluginsGroup myGroup;
    private final PluginDetailsPageComponent myDetailsPage;
    private final Action myIgnoreAction;
    private static Set<String> myIgnoredPluginsWithVersions;

    public PluginUpdateDialog(@Nullable Project project, @NotNull Collection<PluginDownloader> updatedPlugins, final @NotNull Collection<IdeaPluginDescriptor> customRepositoryPlugins) {
        if (updatedPlugins == null) {
            PluginUpdateDialog.$$$reportNull$$$0(0);
        }
        if (customRepositoryPlugins == null) {
            PluginUpdateDialog.$$$reportNull$$$0(1);
        }
        super(true);
        this.setTitle(IdeBundle.message((String)"dialog.title.plugin.updates", (Object[])new Object[0]));
        this.myDownloaders = updatedPlugins;
        this.myIgnoreAction = new AbstractAction(IdeBundle.message((String)"updates.ignore.updates.button", (Object[])new Object[]{updatedPlugins.size()})){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginUpdateDialog.this.close(1);
                PluginUpdateDialog.ignorePlugins(ContainerUtil.map(PluginUpdateDialog.this.myGroup.ui.plugins, component2 -> component2.myUpdateDescriptor));
            }
        };
        this.myPluginModel = new MyPluginModel(project){

            @Override
            public void runRestartButton(@NotNull Component component2) {
                if (component2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                PluginUpdateDialog.this.doOKAction();
            }

            @Override
            @NotNull
            protected Collection<IdeaPluginDescriptor> getCustomRepoPlugins() {
                Collection collection = customRepositoryPlugins;
                if (collection == null) {
                    2.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCustomRepoPlugins";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "runRestartButton";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myPluginModel.setTopController(Configurable.TopComponentController.EMPTY);
        this.myPluginModel.setPluginUpdatesService(new PluginUpdatesService(){

            @Override
            public void finishUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
                if (descriptor2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                PluginUpdateDialog.this.updateButtons();
            }

            @Override
            public void finishUpdate() {
                PluginUpdateDialog.this.updateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$3", "finishUpdate"));
            }
        });
        this.myDetailsPage = new PluginDetailsPageComponent(this.myPluginModel, NULL_LISTENER, false){

            @Override
            public void showProgress() {
            }
        };
        this.myDetailsPage.setOnlyUpdateMode();
        MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
        this.myPluginsPanel = new PluginsGroupComponent((LayoutManager)((Object)new PluginListLayout()), eventHandler, (Function<? super IdeaPluginDescriptor, ? extends ListPluginComponent>)((Function)descriptor2 -> this.createListComponent((IdeaPluginDescriptor)descriptor2)));
        PluginManagerConfigurable.registerCopyProvider(this.myPluginsPanel);
        this.myPluginsPanel.setSelectionListener(__ -> {
            List<ListPluginComponent> selection = this.myPluginsPanel.getSelection();
            int size = selection.size();
            this.myDetailsPage.showPlugin(size == 1 ? selection.get(0) : null, size > 1);
        });
        this.myGroup = new PluginsGroup(IdeBundle.message((String)"title.plugin.updates.available", (Object[])new Object[0]));
        for (PluginDownloader plugin2 : updatedPlugins) {
            this.myGroup.descriptors.add(plugin2.getDescriptor());
        }
        this.myGroup.sortByName();
        this.myPluginsPanel.addGroup(this.myGroup);
        this.setOKButtonText(false, false);
        this.setCancelButtonText(IdeBundle.message((String)"updates.remind.later.button", (Object[])new Object[0]));
        this.init();
        JRootPane rootPane = this.getPeer().getRootPane();
        if (rootPane != null) {
            rootPane.setPreferredSize((Dimension)new JBDimension(800, 600));
        }
    }

    private void updateButtons() {
        int count = this.myGroup.ui.plugins.size();
        int restart = 0;
        int progress2 = 0;
        int updatedWithoutRestart = 0;
        for (ListPluginComponent plugin2 : this.myGroup.ui.plugins) {
            if (plugin2.isRestartEnabled()) {
                ++restart;
                continue;
            }
            if (plugin2.underProgress()) {
                ++progress2;
                continue;
            }
            if (!plugin2.isUpdatedWithoutRestart()) continue;
            ++updatedWithoutRestart;
        }
        this.setOKButtonText(restart + progress2 > 0, updatedWithoutRestart == count);
        this.getCancelAction().setEnabled(restart + updatedWithoutRestart < count);
        this.myIgnoreAction.setEnabled(restart + progress2 + updatedWithoutRestart == 0);
    }

    private void setOKButtonText(boolean restart, boolean close2) {
        if (close2) {
            this.setOKButtonText(CommonBundle.getCloseButtonText());
        } else {
            this.setOKButtonText(IdeBundle.message((String)"button.text.ide.restart.shutdown", (Object[])new Object[]{restart ? 0 : 1, ApplicationManager.getApplication().isRestartCapable() ? 0 : 1}));
        }
    }

    protected void doOKAction() {
        super.doOKAction();
        ArrayList<PluginDownloader> toDownloads = new ArrayList<PluginDownloader>();
        ArrayList<IdeaPluginDescriptor> toIgnore = new ArrayList<IdeaPluginDescriptor>();
        int index = 0;
        boolean restart = false;
        for (PluginDownloader downloader : this.myDownloaders) {
            ListPluginComponent component2;
            if ((component2 = this.myGroup.ui.plugins.get(index++)).isRestartEnabled() || component2.underProgress()) {
                restart = true;
                continue;
            }
            if (component2.isUpdatedWithoutRestart()) continue;
            toDownloads.add(downloader);
            toIgnore.add(component2.myUpdateDescriptor);
        }
        boolean background = this.myPluginModel.toBackground();
        if (toDownloads.size() != this.myDownloaders.size() || background) {
            if (!toIgnore.isEmpty()) {
                PluginUpdateDialog.ignorePlugins(toIgnore);
            }
            if (!background && restart) {
                ApplicationManager.getApplication().invokeLater(() -> ApplicationManagerEx.getApplicationEx().restart(true));
            }
            return;
        }
        PluginUpdateDialog.runUpdateAll(toDownloads, this.getContentPanel());
    }

    public static void runUpdateAll(final @NotNull Collection<PluginDownloader> toDownloads, final @Nullable JComponent ownerComponent) {
        if (toDownloads == null) {
            PluginUpdateDialog.$$$reportNull$$$0(2);
        }
        String message = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        new Task.Backgroundable(null, message, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                List<PluginDownloader> downloaders;
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (!(downloaders = UpdateInstaller.downloadPluginUpdates(toDownloads, indicator)).isEmpty()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        PluginUpdateResult result2 = UpdateInstaller.installDownloadedPluginUpdates(downloaders, ownerComponent, true);
                        if (result2.getPluginsInstalled().size() > 0) {
                            if (result2.getRestartRequired()) {
                                if (WelcomeFrame.getInstance() == null) {
                                    PluginManagerMain.notifyPluginsUpdated(null);
                                } else {
                                    PluginManagerConfigurable.shutdownOrRestartApp();
                                }
                            } else {
                                String message = PluginUpdateInfoDialog.notificationText(result2);
                                UpdateChecker.getNotificationGroup().createNotification(message, NotificationType.INFORMATION).notify(this.myProject);
                            }
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$5", "run"));
            }
        }.queue();
    }

    public void doCancelAction() {
        this.close(1);
        if (this.myPluginModel.toBackground()) {
            return;
        }
        for (ListPluginComponent plugin2 : this.myGroup.ui.plugins) {
            if (!plugin2.isRestartEnabled()) continue;
            ApplicationManager.getApplication().invokeLater(() -> PluginManagerConfigurable.shutdownOrRestartApp());
            return;
        }
    }

    protected Action @NotNull [] createLeftSideActions() {
        Action[] actionArray = (Action[])ContainerUtil.ar((Object[])new Action[]{this.myIgnoreAction});
        if (actionArray == null) {
            PluginUpdateDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            PluginUpdateDialog.$$$reportNull$$$0(4);
        }
        return dialogStyle;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog";
    }

    @NotNull
    private ListPluginComponent createListComponent(IdeaPluginDescriptor updateDescriptor) {
        IdeaPluginDescriptor descriptor2 = PluginManagerCore.getPlugin(updateDescriptor.getPluginId());
        assert (descriptor2 != null) : updateDescriptor;
        ListPluginComponent component2 = new ListPluginComponent(this.myPluginModel, descriptor2, NULL_LISTENER, false){

            @Override
            public void updateErrors() {
            }

            @Override
            public void showProgress() {
                super.showProgress();
                PluginUpdateDialog.this.updateButtons();
            }
        };
        component2.setOnlyUpdateMode(updateDescriptor);
        ListPluginComponent listPluginComponent = component2;
        if (listPluginComponent == null) {
            PluginUpdateDialog.$$$reportNull$$$0(5);
        }
        return listPluginComponent;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.45f){

            protected Divider createDivider() {
                Divider divider = super.createDivider();
                divider.setBackground(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR);
                return divider;
            }
        };
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add(PluginManagerConfigurable.createScrollPane(this.myPluginsPanel, true));
        OpaquePanel titlePanel = new OpaquePanel((LayoutManager)new BorderLayout(), PluginManagerConfigurable.MAIN_BG_COLOR);
        titlePanel.setBorder((Border)JBUI.Borders.empty((int)6, (int)10));
        leftPanel.add((Component)titlePanel, "South");
        JLabel titleComponent = new JLabel(IdeBundle.message((String)"label.plugins.can.be.updated.later.in.0.plugins", (Object[])new Object[]{CommonBundle.settingsTitle()}));
        titleComponent.setForeground(PluginsGroupComponent.SECTION_HEADER_FOREGROUND);
        titlePanel.add((Component)titleComponent);
        ((JComponent)this.myGroup.ui.panel).setBorder((Border)JBUI.Borders.empty((int)6, (int)10));
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent((JComponent)this.myDetailsPage);
        return splitter;
    }

    @NotNull
    private static File getDisabledUpdateFile() {
        return new File(PathManager.getConfigPath(), "plugin_disabled_updates.txt");
    }

    @NotNull
    private static Set<String> getIgnoredPlugins() {
        if (myIgnoredPluginsWithVersions == null) {
            myIgnoredPluginsWithVersions = new HashSet<String>();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    File file2 = PluginUpdateDialog.getDisabledUpdateFile();
                    if (file2.isFile()) {
                        myIgnoredPluginsWithVersions.addAll(FileUtil.loadLines((File)file2));
                    }
                }
                catch (IOException e) {
                    Logger.getInstance(UpdateChecker.class).error((Throwable)e);
                }
            }
        }
        Set<String> set2 = myIgnoredPluginsWithVersions;
        if (set2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(6);
        }
        return set2;
    }

    static void ignorePlugins(@NotNull List<IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(7);
        }
        Set<String> ignoredPlugins = PluginUpdateDialog.getIgnoredPlugins();
        for (IdeaPluginDescriptor descriptor2 : descriptors2) {
            ignoredPlugins.add(PluginUpdateDialog.getIdVersionValue(descriptor2));
        }
        try {
            FileUtil.writeToFile((File)PluginUpdateDialog.getDisabledUpdateFile(), (String)StringUtil.join(ignoredPlugins, (String)LineSeparator.getSystemLineSeparator().getSeparatorString()));
        }
        catch (IOException e) {
            Logger.getInstance(UpdateChecker.class).error((Throwable)e);
        }
    }

    public static boolean isIgnored(@NotNull IdeaPluginDescriptor descriptor2) {
        Set<String> plugins;
        if (descriptor2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(8);
        }
        if ((plugins = PluginUpdateDialog.getIgnoredPlugins()).isEmpty()) {
            return false;
        }
        return plugins.contains(PluginUpdateDialog.getIdVersionValue(descriptor2));
    }

    @NotNull
    private static String getIdVersionValue(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(9);
        }
        String string = descriptor2.getPluginId().getIdString() + "+" + descriptor2.getVersion();
        if (string == null) {
            PluginUpdateDialog.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedPlugins";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customRepositoryPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDownloads";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createListComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredPlugins";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdVersionValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runUpdateAll";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ignorePlugins";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIdVersionValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

