/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.application.options.schemes.AbstractDescriptionAwareSchemesPanel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.DescriptionAwareSchemeActions;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.lang.LangBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesModel;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileSchemesPanel
extends AbstractDescriptionAwareSchemesPanel<InspectionProfileModifiableModel> {
    private static final Logger LOG = Logger.getInstance(InspectionProfileSchemesPanel.class);
    private final Project myProject;
    private final BaseInspectionProfileManager myAppProfileManager;
    private final BaseInspectionProfileManager myProjectProfileManager;
    private final InspectionToolsConfigurable myConfigurable;
    private final InspectionProfileSchemesModel myModel;

    InspectionProfileSchemesPanel(@NotNull Project project, @NotNull BaseInspectionProfileManager appProfileManager, @NotNull BaseInspectionProfileManager projectProfileManager, @NotNull InspectionToolsConfigurable configurable2) {
        if (project == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(0);
        }
        if (appProfileManager == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(1);
        }
        if (projectProfileManager == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(2);
        }
        if (configurable2 == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myAppProfileManager = appProfileManager;
        this.myProjectProfileManager = projectProfileManager;
        this.myConfigurable = configurable2;
        this.myModel = new InspectionProfileSchemesModel(appProfileManager, projectProfileManager){

            @Override
            protected void onProfileRemoved(@NotNull SingleInspectionProfilePanel profilePanel) {
                if (profilePanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                InspectionProfileSchemesPanel.this.myConfigurable.removeProfilePanel(profilePanel);
                List currentProfiles = ContainerUtil.map(InspectionProfileSchemesPanel.this.getModel().getProfilePanels(), SingleInspectionProfilePanel::getProfile);
                InspectionProfileSchemesPanel.this.resetSchemes(currentProfiles);
                InspectionProfileSchemesPanel.this.selectScheme((InspectionProfileModifiableModel)ContainerUtil.getFirstItem((List)currentProfiles));
            }

            @Override
            @NotNull
            protected SingleInspectionProfilePanel createPanel(@NotNull InspectionProfileModifiableModel model2) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                SingleInspectionProfilePanel singleInspectionProfilePanel = InspectionProfileSchemesPanel.this.myConfigurable.createPanel(model2);
                if (singleInspectionProfilePanel == null) {
                    1.$$$reportNull$$$0(2);
                }
                return singleInspectionProfilePanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profilePanel";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesPanel$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "onProfileRemoved";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createPanel";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public InspectionProfileSchemesModel getModel() {
        InspectionProfileSchemesModel inspectionProfileSchemesModel = this.myModel;
        if (inspectionProfileSchemesModel == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(4);
        }
        return inspectionProfileSchemesModel;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return true;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return false;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return false;
    }

    @Override
    protected boolean hideDeleteActionIfUnavailable() {
        return false;
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<InspectionProfileModifiableModel> createSchemeActions() {
        return new DescriptionAwareSchemeActions<InspectionProfileModifiableModel>((AbstractDescriptionAwareSchemesPanel)this){

            @Override
            @Nullable
            public String getDescription(@NotNull InspectionProfileModifiableModel scheme) {
                SingleInspectionProfilePanel inspectionProfile;
                if (scheme == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (inspectionProfile = ((InspectionProfileSchemesModel)this.getModel()).getProfilePanel(scheme)) == null ? null : inspectionProfile.getProfile().getDescription();
            }

            @Override
            protected void setDescription(@NotNull InspectionProfileModifiableModel scheme, @NlsContexts.DetailedDescription @NotNull String newDescription) {
                InspectionProfileModifiableModel inspectionProfile;
                if (scheme == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (newDescription == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!Comparing.strEqual((String)newDescription, (String)(inspectionProfile = InspectionProfileSchemesPanel.this.getModel().getProfilePanel(scheme).getProfile()).getDescription())) {
                    inspectionProfile.setDescription(newDescription);
                    inspectionProfile.setModified(true);
                }
            }

            @Override
            protected void importScheme(@NotNull String importerName) {
                if (importerName == null) {
                    2.$$$reportNull$$$0(3);
                }
                FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file2) {
                        return FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)StdFileTypes.XML);
                    }
                };
                descriptor2.setDescription(AnalysisBundle.message((String)"inspections.settings.profile.file.chooser.description", (Object[])new Object[0]));
                FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)InspectionProfileSchemesPanel.this.myProject, null, file2 -> {
                    if (file2 != null) {
                        try {
                            InspectionProfileImpl profile = InspectionProfileSchemesPanel.importInspectionProfile(JDOMUtil.load((InputStream)file2.getInputStream()), InspectionProfileSchemesPanel.this.myAppProfileManager, InspectionProfileSchemesPanel.this.myProject);
                            if (profile == null) {
                                Messages.showErrorDialog((Project)InspectionProfileSchemesPanel.this.myProject, (String)AnalysisBundle.message((String)"inspections.settings.invalid.format.warning", (Object[])new Object[]{file2.getName()}), (String)CommonBundle.getErrorTitle());
                                return;
                            }
                            SingleInspectionProfilePanel existed = InspectionProfileSchemesPanel.this.getModel().getProfilePanel(profile);
                            if (existed != null) {
                                if (Messages.showOkCancelDialog((Project)InspectionProfileSchemesPanel.this.myProject, (String)AnalysisBundle.message((String)"inspections.settings.profile.already.exists.dialog.message", (Object[])new Object[]{profile.getName()}), (String)AnalysisBundle.message((String)"inspections.settings.overwrite.warning.title", (Object[])new Object[0]), (String)AnalysisBundle.message((String)"inspections.settings.overwrite.action.text", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getInformationIcon()) != 0) {
                                    return;
                                }
                                this.getModel().removeScheme(existed.getProfile());
                            }
                            InspectionProfileModifiableModel model2 = new InspectionProfileModifiableModel(profile);
                            model2.setModified(true);
                            InspectionProfileSchemesPanel.this.addProfile(model2);
                            InspectionProfileSchemesPanel.this.selectScheme(model2);
                        }
                        catch (InvalidDataException | IOException | JDOMException e) {
                            LOG.error(e);
                        }
                    }
                });
            }

            @Override
            protected void resetScheme(@NotNull InspectionProfileModifiableModel scheme) {
                if (scheme == null) {
                    2.$$$reportNull$$$0(4);
                }
                SingleInspectionProfilePanel panel2 = InspectionProfileSchemesPanel.this.getModel().getProfilePanel(scheme);
                panel2.performProfileReset();
            }

            @Override
            protected void duplicateScheme(@NotNull InspectionProfileModifiableModel scheme, @NotNull String newName2) {
                if (scheme == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (newName2 == null) {
                    2.$$$reportNull$$$0(6);
                }
                InspectionProfileModifiableModel newProfile = InspectionProfileSchemesPanel.this.copyToNewProfile(scheme, InspectionProfileSchemesPanel.this.myProject, newName2, false);
                InspectionProfileSchemesPanel.this.addProfile(newProfile);
                InspectionProfileSchemesPanel.this.myConfigurable.selectProfile(newProfile);
                InspectionProfileSchemesPanel.this.selectScheme(newProfile);
            }

            @Override
            protected void onSchemeChanged(@Nullable InspectionProfileModifiableModel scheme) {
                super.onSchemeChanged(scheme);
                if (scheme != null) {
                    InspectionProfileSchemesPanel.this.myConfigurable.selectProfile(scheme);
                }
            }

            @Override
            protected void renameScheme(@NotNull InspectionProfileModifiableModel scheme, @NotNull String newName2) {
                if (scheme == null) {
                    2.$$$reportNull$$$0(7);
                }
                if (newName2 == null) {
                    2.$$$reportNull$$$0(8);
                }
                scheme.setName(newName2);
            }

            @Override
            protected void copyToProject(@NotNull InspectionProfileModifiableModel scheme) {
                if (scheme == null) {
                    2.$$$reportNull$$$0(9);
                }
                this.copyToAnotherLevel(scheme, true);
            }

            @Override
            protected void copyToIDE(@NotNull InspectionProfileModifiableModel scheme) {
                if (scheme == null) {
                    2.$$$reportNull$$$0(10);
                }
                this.copyToAnotherLevel(scheme, false);
            }

            @Override
            @NotNull
            protected Class<InspectionProfileModifiableModel> getSchemeType() {
                return InspectionProfileModifiableModel.class;
            }

            private void copyToAnotherLevel(@NotNull InspectionProfileModifiableModel profile, boolean copyToProject) {
                if (profile == null) {
                    2.$$$reportNull$$$0(11);
                }
                this.getSchemesPanel().editNewSchemeName(profile.getName(), copyToProject, newName2 -> {
                    InspectionProfileModifiableModel newProfile = InspectionProfileSchemesPanel.this.copyToNewProfile(profile, InspectionProfileSchemesPanel.this.myProject, (String)newName2, true);
                    InspectionProfileSchemesPanel.this.addProfile(newProfile);
                    InspectionProfileSchemesPanel.this.selectScheme(newProfile);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newDescription";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "importerName";
                        break;
                    }
                    case 6: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profile";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesPanel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDescription";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setDescription";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "importScheme";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "resetScheme";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "duplicateScheme";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "renameScheme";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "copyToProject";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "copyToIDE";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "copyToAnotherLevel";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    protected String getSchemeTypeName() {
        String string = LangBundle.message((String)"inspection.profile.scheme.type.name.panel", (Object[])new Object[0]);
        if (string == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    void apply() {
        this.getModel().apply((InspectionProfileModifiableModel)this.getSelectedScheme(), (Consumer<? super InspectionProfileImpl>)((Consumer)p -> {
            if (this.myConfigurable.setActiveProfileAsDefaultOnApply()) {
                this.myConfigurable.applyRootProfile(p.getName(), p.isProjectLevel());
            }
        }));
    }

    void reset() {
        this.getModel().reset();
        this.getModel().updatePanel(this);
    }

    @NotNull
    private InspectionProfileModifiableModel copyToNewProfile(@NotNull InspectionProfileImpl selectedProfile, @NotNull Project project, @NotNull String newName2, boolean modifyLevel) {
        boolean isProjectLevel;
        if (selectedProfile == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(6);
        }
        if (project == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(7);
        }
        if (newName2 == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(8);
        }
        BaseInspectionProfileManager profileManager = (isProjectLevel = selectedProfile.isProjectLevel() ^ modifyLevel) ? this.myProjectProfileManager : this.myAppProfileManager;
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(newName2, (InspectionToolsSupplier)InspectionToolRegistrar.getInstance(), profileManager);
        inspectionProfile.copyFrom(selectedProfile);
        inspectionProfile.setName(newName2);
        inspectionProfile.initInspectionTools(project);
        inspectionProfile.setProjectLevel(isProjectLevel);
        InspectionProfileModifiableModel modifiableModel = new InspectionProfileModifiableModel(inspectionProfile);
        modifiableModel.setModified(true);
        InspectionProfileModifiableModel inspectionProfileModifiableModel = modifiableModel;
        if (inspectionProfileModifiableModel == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(9);
        }
        return inspectionProfileModifiableModel;
    }

    private void addProfile(@NotNull InspectionProfileModifiableModel profile) {
        if (profile == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(10);
        }
        InspectionProfileModifiableModel selected2 = (InspectionProfileModifiableModel)this.getSelectedScheme();
        this.getModel().addProfile(profile);
        this.getModel().updatePanel(this);
        this.selectScheme(selected2);
    }

    @Override
    @NotNull
    protected JComponent getConfigurableFocusComponent() {
        JComponent jComponent = this.myConfigurable.getPreferredFocusedComponent();
        if (jComponent == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(11);
        }
        return jComponent;
    }

    public void selectAnyProfile() {
        List<SingleInspectionProfilePanel> panels = this.myModel.getProfilePanels();
        if (panels.isEmpty()) {
            LOG.error("No profiles to select.");
            return;
        }
        this.selectScheme(panels.get(0).getProfile());
        if (this.getSelectedScheme() == null) {
            LOG.error("Selected scheme is still null.");
        }
    }

    @Nullable(value="returns null if xml has invalid format")
    public static @Nullable(value="returns null if xml has invalid format") InspectionProfileImpl importInspectionProfile(@NotNull Element rootElement, @NotNull BaseInspectionProfileManager profileManager, @NotNull Project project) {
        String profileName;
        if (rootElement == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(12);
        }
        if (profileManager == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(13);
        }
        if (project == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(14);
        }
        if (Comparing.strEqual((String)rootElement.getName(), (String)"component")) {
            rootElement = (Element)rootElement.getChildren().get(0);
        }
        if ((profileName = InspectionProfileSchemesPanel.getProfileName(rootElement)) == null) {
            return null;
        }
        InspectionProfileImpl profile = new InspectionProfileImpl(profileName, (InspectionToolsSupplier)InspectionToolRegistrar.getInstance(), profileManager);
        HashSet<String> levels = new HashSet<String>();
        for (Element inspectElement : rootElement.getChildren("inspection_tool")) {
            ContainerUtil.addAllNotNull(levels, (Object[])new String[]{inspectElement.getAttributeValue("level")});
            for (Element s : inspectElement.getChildren("scope")) {
                ContainerUtil.addAllNotNull(levels, (Object[])new String[]{s.getAttributeValue("level")});
            }
        }
        levels.removeIf(level -> profileManager.getSeverityRegistrar().getSeverity((String)level) != null);
        if (!levels.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                if (Messages.showYesNoDialog((Project)project, (String)AnalysisBundle.message((String)"inspections.settings.undefined.severities.detected.dialog.message", (Object[])new Object[]{StringUtil.join(levels, (String)", ")}), (String)CommonBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) == 0) {
                    for (String level2 : levels) {
                        TextAttributes textAttributes = CodeInsightColors.WARNINGS_ATTRIBUTES.getDefaultAttributes();
                        HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(new HighlightSeverity(level2, 50), TextAttributesKey.createTextAttributesKey((String)level2));
                        profileManager.getSeverityRegistrar().registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
                    }
                }
            } else {
                throw new AssertionError((Object)("All of levels must exist in unit-test mode, but actual not exist levels = " + levels));
            }
        }
        profile.readExternal(rootElement);
        profile.setProjectLevel(false);
        profile.initInspectionTools(project);
        return profile;
    }

    private static String getProfileName(@NotNull Element rootElement) {
        if (rootElement == null) {
            InspectionProfileSchemesPanel.$$$reportNull$$$0(15);
        }
        for (Element option2 : rootElement.getChildren("option")) {
            String optionName = option2.getAttributeValue("name");
            if (!"myName".equals(optionName)) continue;
            return option2.getAttributeValue("value");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appProfileManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesPanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProfile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeTypeName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToNewProfile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurableFocusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyToNewProfile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addProfile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "importInspectionProfile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProfileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

