/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.search.impl.LanguageInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.search.LeafOccurrence;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.search.LowLevelSearchUtilKt;
import com.intellij.psi.impl.search.RequestProcessors;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringSearcher;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u0007B%\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J5\u0010\u0016\u001a'\u0012#\u0012!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u00070\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/psi/impl/search/InjectionAwareOccurrenceProcessor;", "Lkotlin/Function1;", "Lcom/intellij/psi/impl/search/LeafOccurrence;", "Lkotlin/ParameterName;", "name", "occurrence", "", "Lcom/intellij/psi/impl/search/OccurrenceProcessor;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processors", "Lcom/intellij/psi/impl/search/RequestProcessors;", "manager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "searcher", "Lcom/intellij/util/text/StringSearcher;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/psi/impl/search/RequestProcessors;Lcom/intellij/lang/injection/InjectedLanguageManager;Lcom/intellij/util/text/StringSearcher;)V", "processedInjections", "Ljava/util/HashSet;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/collections/HashSet;", "findInjectionAtOffset", "getLanguageProcessors", "", "injectionLanguage", "Lcom/intellij/lang/Language;", "invoke", "(Lcom/intellij/psi/impl/search/LeafOccurrence;)Ljava/lang/Boolean;", "processHost", "intellij.platform.indexing.impl"})
public final class InjectionAwareOccurrenceProcessor
implements Function1<LeafOccurrence, Boolean> {
    private final HashSet<PsiElement> processedInjections;
    private final ProgressIndicator progress;
    private final RequestProcessors processors;
    private final InjectedLanguageManager manager;
    private final StringSearcher searcher;

    @NotNull
    public Boolean invoke(@NotNull LeafOccurrence occurrence) {
        Intrinsics.checkNotNullParameter((Object)occurrence, (String)"occurrence");
        if (this.processors.getInjectionProcessors().isEmpty()) {
            return this.processHost(occurrence);
        }
        PsiElement injected = this.findInjectionAtOffset(occurrence);
        if (injected == null) {
            return this.processHost(occurrence);
        }
        if (!this.processedInjections.add(injected)) {
            return true;
        }
        Language language = injected.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"injected.language");
        Collection<Function1<LeafOccurrence, Boolean>> injectionProcessors = this.getLanguageProcessors(language);
        if (injectionProcessors.isEmpty()) {
            return true;
        }
        int[] offsets2 = LowLevelSearchUtil.getTextOccurrencesInScope(injected, this.searcher);
        int patternLength = this.searcher.getPatternLength();
        Intrinsics.checkNotNullExpressionValue((Object)offsets2, (String)"offsets");
        return LowLevelSearchUtilKt.processOffsets(injected, offsets2, patternLength, this.progress, LowLevelSearchUtilKt.compound(injectionProcessors, this.progress));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Function1<LeafOccurrence, Boolean>> getLanguageProcessors(Language injectionLanguage) {
        Map<LanguageInfo, Collection<Function1<LeafOccurrence, Boolean>>> injectionProcessors = this.processors.getInjectionProcessors();
        SmartList result2 = new SmartList();
        Object object = injectionProcessors;
        boolean bl = false;
        for (Map.Entry<LanguageInfo, Collection<Function1<LeafOccurrence, Boolean>>> entry : object.entrySet()) {
            void languageInfo;
            Object object2 = entry;
            boolean bl2 = false;
            object = object2.getKey();
            object2 = entry;
            bl2 = false;
            Collection<Function1<LeafOccurrence, Boolean>> processors = object2.getValue();
            if (!Intrinsics.areEqual((Object)languageInfo, (Object)LanguageInfo.NoLanguage.INSTANCE) && (!(languageInfo instanceof LanguageInfo.InLanguage) || !((LanguageInfo.InLanguage)languageInfo).getMatcher().matchesLanguage(injectionLanguage))) continue;
            object2 = (Collection)result2;
            bl2 = false;
            CollectionsKt.addAll((Collection)object2, (Iterable)processors);
        }
        return (Collection)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findInjectionAtOffset(LeafOccurrence occurrence) {
        PsiElement psiElement = LowLevelSearchUtilKt.elementsUp(occurrence);
        boolean bl = false;
        PsiElement psiElement2 = psiElement;
        while (psiElement2.hasNext()) {
            List injectedFiles;
            void currentElement;
            kotlin.Pair<PsiElement, Integer> pair = psiElement2.next();
            psiElement = (PsiElement)pair.component1();
            int currentOffset = ((Number)pair.component2()).intValue();
            this.progress.checkCanceled();
            if (this.manager.getInjectedPsiFiles((PsiElement)currentElement) == null) {
                continue;
            }
            for (Pair pair2 : injectedFiles) {
                void injected;
                PsiElement psiElement3 = (PsiElement)ExtensionsKt.component1((Pair)pair2);
                TextRange range2 = (TextRange)ExtensionsKt.component2((Pair)pair2);
                if (!range2.containsRange(currentOffset, currentOffset + this.searcher.getPatternLength())) continue;
                return injected;
            }
        }
        return null;
    }

    private final boolean processHost(LeafOccurrence occurrence) {
        return LowLevelSearchUtilKt.runProcessors(this.processors.getHostProcessors(), this.progress, occurrence);
    }

    public InjectionAwareOccurrenceProcessor(@NotNull ProgressIndicator progress2, @NotNull RequestProcessors processors, @NotNull InjectedLanguageManager manager2, @NotNull StringSearcher searcher) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)processors, (String)"processors");
        Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        this.progress = progress2;
        this.processors = processors;
        this.manager = manager2;
        this.searcher = searcher;
        this.processedInjections = new HashSet();
    }
}

