/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PackagePrefixFileSystemItem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceCompletion;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.NullFileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingBundle;
import java.net.URI;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReference
implements PsiFileReference,
FileReferenceOwner,
PsiPolyVariantReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider,
BindablePsiReference {
    private static final Logger LOG = Logger.getInstance(FileReference.class);
    public static final FileReference[] EMPTY = new FileReference[0];
    private final int myIndex;
    private TextRange myRange;
    private final String myText;
    @NotNull
    private final FileReferenceSet myFileReferenceSet;

    public FileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range2, int index, String text2) {
        if (fileReferenceSet == null) {
            FileReference.$$$reportNull$$$0(0);
        }
        this.myFileReferenceSet = fileReferenceSet;
        this.myIndex = index;
        this.myRange = range2;
        this.myText = text2;
    }

    public FileReference(FileReference original) {
        this(original.myFileReferenceSet, original.myRange, original.myIndex, original.myText);
    }

    @Nullable
    public static FileReference findFileReference(@NotNull PsiReference original) {
        PsiFileReference fileReference;
        if (original == null) {
            FileReference.$$$reportNull$$$0(1);
        }
        if (original instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)original;
            for (PsiReference reference2 : multiReference.getReferences()) {
                if (!(reference2 instanceof FileReference)) continue;
                return (FileReference)reference2;
            }
        } else if (original instanceof FileReferenceOwner && (fileReference = ((FileReferenceOwner)original).getLastFileReference()) instanceof FileReference) {
            return (FileReference)fileReference;
        }
        return null;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getContexts() {
        FileReference contextRef = this.getContextReference();
        ArrayList<PsiFileSystemItem> result2 = new ArrayList<PsiFileSystemItem>();
        if (contextRef == null) {
            Collection<PsiFileSystemItem> defaultContexts = this.myFileReferenceSet.getDefaultContexts();
            for (PsiFileSystemItem context : defaultContexts) {
                if (context != null) continue;
                LOG.error((Throwable)PluginException.createByClass((String)"Null context", null, this.myFileReferenceSet.getClass()));
            }
            result2.addAll(defaultContexts);
        } else {
            ResolveResult[] resolveResults;
            for (ResolveResult resolveResult : resolveResults = contextRef.multiResolve(false)) {
                if (resolveResult.getElement() == null) continue;
                result2.add((PsiFileSystemItem)resolveResult.getElement());
            }
        }
        result2.addAll(this.myFileReferenceSet.getExtraContexts());
        ArrayList<PsiFileSystemItem> arrayList = result2;
        if (arrayList == null) {
            FileReference.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getElement().getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(file2.getProject()).resolveWithCaching(this, MyResolver.INSTANCE, false, false, file2);
        if (resolveResultArray == null) {
            FileReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        int resultCount;
        String referenceText;
        if (containingFile == null) {
            FileReference.$$$reportNull$$$0(4);
        }
        if ((referenceText = this.getText()).isEmpty() && this.myIndex == 0) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)containingFile)};
            if (resolveResultArray == null) {
                FileReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }
        Collection contexts = (Collection)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> this.getContexts());
        if (contexts == null) {
            LOG.error("Recursion occurred for " + this.getClass() + " on " + this.getElement().getText());
            if (ResolveResult.EMPTY_ARRAY == null) {
                FileReference.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        LinkedHashSet<ResolveResult> result2 = new LinkedHashSet<ResolveResult>();
        for (PsiFileSystemItem context : contexts) {
            this.innerResolveInContext(referenceText, context, result2, caseSensitive);
        }
        if (contexts.isEmpty() && this.isAllowedEmptyPath(referenceText)) {
            result2.add((ResolveResult)new PsiElementResolveResult((PsiElement)containingFile));
        }
        ResolveResult[] resolveResultArray = (resultCount = result2.size()) > 0 ? result2.toArray(new ResolveResult[resultCount]) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            FileReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    protected void innerResolveInContext(@NotNull String text2, @NotNull PsiFileSystemItem context, final Collection<ResolveResult> result2, final boolean caseSensitive) {
        if (text2 == null) {
            FileReference.$$$reportNull$$$0(8);
        }
        if (context == null) {
            FileReference.$$$reportNull$$$0(9);
        }
        if (this.isAllowedEmptyPath(text2) || ".".equals(text2) || "/".equals(text2)) {
            if (context instanceof FileReferenceResolver) {
                ContainerUtil.addIfNotNull(result2, (Object)this.resolveFileReferenceResolver((FileReferenceResolver)context, text2));
                return;
            }
            result2.add((ResolveResult)new PsiElementResolveResult((PsiElement)context));
        } else if ("..".equals(text2)) {
            if (context instanceof FileReferenceResolver) {
                ContainerUtil.addIfNotNull(result2, (Object)this.resolveFileReferenceResolver((FileReferenceResolver)context, text2));
                return;
            }
            PsiFileSystemItem resolved = context.getParent();
            if (resolved != null) {
                result2.add((ResolveResult)new PsiElementResolveResult((PsiElement)resolved));
            }
        } else {
            int separatorIndex = text2.indexOf(47);
            if (separatorIndex >= 0) {
                ArrayList<ResolveResult> resolvedContexts = new ArrayList<ResolveResult>();
                if (separatorIndex == 0 && "/".equals(context.getName())) {
                    resolvedContexts.add((ResolveResult)new PsiElementResolveResult((PsiElement)context));
                } else {
                    this.innerResolveInContext(text2.substring(0, separatorIndex), context, resolvedContexts, caseSensitive);
                }
                String restOfText = text2.substring(separatorIndex + 1);
                for (ResolveResult contextVariant : resolvedContexts) {
                    PsiFileSystemItem item = (PsiFileSystemItem)contextVariant.getElement();
                    if (item == null) continue;
                    this.innerResolveInContext(restOfText, item, result2, caseSensitive);
                }
            } else {
                ResolveResult child2;
                final String decoded = this.decode(text2);
                if (context instanceof PackagePrefixFileSystemItem) {
                    context = ((PackagePrefixFileSystemItem)context).getDirectory();
                } else if (context instanceof FileReferenceResolver && (child2 = this.resolveFileReferenceResolver((FileReferenceResolver)context, decoded)) != null) {
                    result2.add(child2);
                    return;
                }
                if (context.getParent() == null && FileUtil.namesEqual((String)decoded, (String)context.getName())) {
                    result2.add((ResolveResult)new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(context)));
                } else if (context instanceof PsiDirectory && FileReference.caseSensitivityApplies((PsiDirectory)context, caseSensitive)) {
                    PsiDirectory directory = (PsiDirectory)context;
                    PsiFile child3 = directory.findFile(decoded);
                    if (child3 == null) {
                        child3 = directory.findSubdirectory(decoded);
                    }
                    if (child3 != null) {
                        result2.add((ResolveResult)new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile((PsiFileSystemItem)child3)));
                    }
                } else {
                    FileReference.processVariants(context, new PsiFileSystemItemProcessor(){

                        @Override
                        public boolean acceptItem(@NotNull String name, boolean isDirectory) {
                            if (name == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return caseSensitive ? decoded.equals(name) : decoded.compareToIgnoreCase(name) == 0;
                        }

                        public boolean execute(@NotNull PsiFileSystemItem element2) {
                            if (element2 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            result2.add(new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(element2)));
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "element";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "acceptItem";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "execute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
            }
        }
    }

    @NotNull
    @NlsSafe
    public String getFileNameToCreate() {
        String string = this.decode(this.getCanonicalText());
        if (string == null) {
            FileReference.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getNewFileTemplateName() {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(this.myText);
        if (fileType != UnknownFileType.INSTANCE) {
            return fileType.getName() + " File." + fileType.getDefaultExtension();
        }
        return null;
    }

    @Nullable
    private ResolveResult resolveFileReferenceResolver(@NotNull FileReferenceResolver fileReferenceResolver, @NotNull String text2) {
        PsiFileSystemItem resolve2;
        if (fileReferenceResolver == null) {
            FileReference.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            FileReference.$$$reportNull$$$0(12);
        }
        return (resolve2 = fileReferenceResolver.resolveFileReference(this, text2)) != null ? new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(resolve2)) : null;
    }

    private static boolean caseSensitivityApplies(PsiDirectory context, boolean caseSensitive) {
        return context.getVirtualFile().isCaseSensitive() == caseSensitive;
    }

    private boolean isAllowedEmptyPath(String text2) {
        return text2.isEmpty() && this.isLast() && (StringUtil.isEmpty((String)this.myFileReferenceSet.getPathString()) && this.myFileReferenceSet.isEmptyPathAllowed() || !this.myFileReferenceSet.isEndingSlashNotAllowed() && this.myIndex > 0);
    }

    @NotNull
    @Contract(pure=true)
    public String decode(@NotNull String text2) {
        if (text2 == null) {
            FileReference.$$$reportNull$$$0(13);
        }
        if (SystemInfo.isMac) {
            text2 = Normalizer.normalize(text2, Normalizer.Form.NFC);
        }
        String _text = text2;
        int paramIndex = text2.lastIndexOf(63);
        if (paramIndex >= 0) {
            _text = text2.substring(0, paramIndex);
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            String string;
            try {
                string = StringUtil.notNullize((String)new URI(_text).getPath(), (String)text2);
            }
            catch (Exception ignored) {
                String string2 = text2;
                if (string2 == null) {
                    FileReference.$$$reportNull$$$0(15);
                }
                return string2;
            }
            if (string == null) {
                FileReference.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = _text;
        if (string == null) {
            FileReference.$$$reportNull$$$0(16);
        }
        return string;
    }

    public Object @NotNull [] getVariants() {
        FileReferenceCompletion completion = FileReferenceCompletion.getInstance();
        if (completion != null) {
            Object[] objectArray = completion.getFileReferenceCompletionVariants(this);
            if (objectArray == null) {
                FileReference.$$$reportNull$$$0(17);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            FileReference.$$$reportNull$$$0(18);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    protected Object createLookupItem(PsiElement candidate) {
        return null;
    }

    protected static PsiFileSystemItem getOriginalFile(PsiFileSystemItem fileSystemItem) {
        PsiFile psiFile;
        PsiManager psiManager;
        VirtualFile file2 = fileSystemItem.getVirtualFile();
        if (file2 != null && !file2.isDirectory() && (psiManager = fileSystemItem.getManager()) != null && (psiFile = psiManager.findFile(file2)) != null) {
            fileSystemItem = psiFile;
        }
        return fileSystemItem;
    }

    @Nullable
    protected String encode(String name, PsiElement psiElement) {
        try {
            return new URI(null, null, name, null).toString();
        }
        catch (Exception ignored) {
            return name;
        }
    }

    protected static void processVariants(PsiFileSystemItem context, PsiFileSystemItemProcessor processor2) {
        context.processChildren((PsiElementProcessor)processor2);
    }

    @Nullable
    private FileReference getContextReference() {
        return this.myIndex > 0 ? this.myFileReferenceSet.getReference(this.myIndex - 1) : null;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myFileReferenceSet.getElement();
        if (psiElement == null) {
            FileReference.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    public PsiFileSystemItem resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    @Nullable
    public PsiFileSystemItem innerSingleResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        ResolveResult[] resolveResults;
        if (containingFile == null) {
            FileReference.$$$reportNull$$$0(20);
        }
        return (resolveResults = this.innerResolve(caseSensitive, containingFile)).length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element2) {
        if (element2 == null) {
            FileReference.$$$reportNull$$$0(21);
        }
        if (!(element2 instanceof PsiFileSystemItem)) {
            return false;
        }
        PsiFileSystemItem item = this.resolve();
        return item != null && FileReferenceHelperRegistrar.areElementsEquivalent(item, (PsiFileSystemItem)element2);
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            FileReference.$$$reportNull$$$0(22);
        }
        return textRange;
    }

    @NotNull
    @NlsSafe
    public String getCanonicalText() {
        String string = this.myText;
        if (string == null) {
            FileReference.$$$reportNull$$$0(23);
        }
        return string;
    }

    public String getText() {
        return this.myText;
    }

    public boolean isSoft() {
        return this.myFileReferenceSet.isSoft();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            FileReference.$$$reportNull$$$0(24);
        }
        ElementManipulator<PsiElement> manipulator = CachingReference.getManipulator(this.getElement());
        this.myFileReferenceSet.setElement(manipulator.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName));
        int delta = newElementName.length() - this.myRange.getLength();
        this.myRange = new TextRange(this.getRangeInElement().getStartOffset(), this.getRangeInElement().getStartOffset() + newElementName.length());
        FileReference[] references = this.myFileReferenceSet.getAllReferences();
        for (int idx = this.myIndex + 1; idx < references.length; ++idx) {
            references[idx].myRange = references[idx].myRange.shiftRight(delta);
        }
        return this.myFileReferenceSet.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element2, boolean absolute) throws IncorrectOperationException {
        String newName2;
        VirtualFile curVFile;
        if (element2 == null) {
            FileReference.$$$reportNull$$$0(25);
        }
        if (!(element2 instanceof PsiFileSystemItem)) {
            throw new IncorrectOperationException("Cannot bind to element, should be instanceof PsiFileSystemItem: " + element2);
        }
        if (this.getCanonicalText().isEmpty() && element2 == this.getElement().getContainingFile()) {
            return this.getElement();
        }
        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element2;
        VirtualFile dstVFile = fileSystemItem.getVirtualFile();
        if (dstVFile == null) {
            throw new IncorrectOperationException("Cannot bind to non-physical element:" + element2);
        }
        PsiFile file2 = this.getElement().getContainingFile();
        PsiLanguageInjectionHost contextPsiFile = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2);
        if (contextPsiFile != null) {
            file2 = contextPsiFile.getContainingFile();
        }
        if ((curVFile = file2.getVirtualFile()) == null) {
            throw new IncorrectOperationException("Cannot bind from non-physical element:" + file2);
        }
        Project project = element2.getProject();
        if (absolute) {
            String relativePath;
            PsiFileSystemItem root = null;
            PsiFileSystemItem dstItem = null;
            for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
                PsiFileSystemItem _root;
                PsiFileSystemItem _dstItem;
                if (!helper.isMine(project, dstVFile) || (_dstItem = helper.getPsiFileSystemItem(project, dstVFile)) == null || (_root = helper.findRoot(project, dstVFile)) == null) continue;
                root = _root;
                dstItem = _dstItem;
                break;
            }
            if (root == null) {
                PsiFileSystemItem _root;
                PsiFileSystemItem _dstItem = NullFileReferenceHelper.INSTANCE.getPsiFileSystemItem(project, dstVFile);
                if (_dstItem != null && (_root = NullFileReferenceHelper.INSTANCE.findRoot(project, dstVFile)) != null) {
                    root = _root;
                    dstItem = _dstItem;
                }
                if (root == null) {
                    return this.getElement();
                }
            }
            if ((relativePath = PsiFileSystemItemUtil.findRelativePath(root, dstItem)) == null) {
                return this.getElement();
            }
            newName2 = this.myFileReferenceSet.getNewAbsolutePath(root, relativePath);
        } else {
            FileReferenceHelper helper = FileReferenceHelperRegistrar.getNotNullHelper(file2);
            Collection<PsiFileSystemItem> contexts = this.getContextsForBindToElement(curVFile, project, helper);
            for (PsiFileSystemItem context : contexts) {
                String path;
                VirtualFile contextFile = context.getVirtualFile();
                assert (contextFile != null);
                if (!VfsUtilCore.isAncestor((VirtualFile)contextFile, (VirtualFile)dstVFile, (boolean)true) || (path = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)contextFile, (char)'/')) == null) continue;
                return this.rename(path);
            }
            PsiFileSystemItem dstItem = helper.getPsiFileSystemItem(project, dstVFile);
            PsiFileSystemItem curItem = helper.getPsiFileSystemItem(project, curVFile);
            if (curItem == null) {
                throw new IncorrectOperationException("Cannot find path between files; src = " + curVFile.getPresentableUrl() + "; dst = " + dstVFile.getPresentableUrl() + "; Contexts: " + contexts);
            }
            if (curItem.equals(dstItem)) {
                if (this.getCanonicalText().equals(dstItem.getName())) {
                    return this.getElement();
                }
                return this.fixRefText(file2.getName());
            }
            newName2 = PsiFileSystemItemUtil.findRelativePath(curItem, dstItem);
            if (newName2 == null) {
                return this.getElement();
            }
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            newName2 = this.encode(newName2, element2);
        }
        return this.rename(newName2);
    }

    protected Collection<PsiFileSystemItem> getContextsForBindToElement(VirtualFile curVFile, Project project, FileReferenceHelper helper) {
        return helper.getContexts(project, curVFile);
    }

    protected PsiElement fixRefText(String name) {
        return ElementManipulators.handleContentChange((PsiElement)this.getElement(), (TextRange)this.getRangeInElement(), (String)name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            FileReference.$$$reportNull$$$0(26);
        }
        return this.bindToElement(element2, this.myFileReferenceSet.isAbsolutePathReference());
    }

    protected PsiElement rename(String newName2) throws IncorrectOperationException {
        TextRange range2 = new TextRange(this.myFileReferenceSet.getStartInElement(), this.getRangeInElement().getEndOffset());
        PsiElement element2 = this.getElement();
        try {
            return CachingReference.getManipulator(element2).handleContentChange(element2, range2, newName2);
        }
        catch (IncorrectOperationException e) {
            LOG.error("Cannot rename " + this.getClass() + " from " + this.myFileReferenceSet.getClass() + " to " + newName2, (Throwable)e);
            throw e;
        }
    }

    protected static FileReferenceHelper @NotNull [] getHelpers() {
        FileReferenceHelper[] fileReferenceHelperArray = FileReferenceHelperRegistrar.getHelpers();
        if (fileReferenceHelperArray == null) {
            FileReference.$$$reportNull$$$0(27);
        }
        return fileReferenceHelperArray;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getUnresolvedMessagePattern() {
        String string = AnalysisBundle.message((String)"error.cannot.resolve.file.or.dir", (Object[])new Object[]{IndexingBundle.message((String)(this.isLast() ? "terms.file" : "terms.directory"), (Object[])new Object[0]), StringUtil.escapePattern((String)this.decode(this.getCanonicalText()))});
        if (string == null) {
            FileReference.$$$reportNull$$$0(28);
        }
        return string;
    }

    public final boolean isLast() {
        return this.myIndex == this.myFileReferenceSet.getAllReferences().length - 1;
    }

    @NotNull
    public FileReferenceSet getFileReferenceSet() {
        FileReferenceSet fileReferenceSet = this.myFileReferenceSet;
        if (fileReferenceSet == null) {
            FileReference.$$$reportNull$$$0(29);
        }
        return fileReferenceSet;
    }

    public LocalQuickFix[] getQuickFixes() {
        ArrayList<? extends LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        for (FileReferenceHelper helper : FileReference.getHelpers()) {
            result2.addAll(helper.registerFixes(this));
        }
        return result2.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @Override
    public FileReference getLastFileReference() {
        return this.myFileReferenceSet.getLastReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceResolver";
                break;
            }
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameToCreate";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpers";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileReference";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileReferenceResolver";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "innerSingleResolve";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantContextResolver<FileReference> {
        static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        @Override
        public ResolveResult @NotNull [] resolve(@NotNull FileReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            ResolveResult[] resolveResultArray = ref.innerResolve(ref.getFileReferenceSet().isCaseSensitive(), containingFile);
            if (resolveResultArray == null) {
                MyResolver.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$MyResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$MyResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

