/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.BranchChangeListener;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.context.ConfigureBranchContextDialog;
import com.intellij.tasks.context.WorkingContextManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BranchContextTracker
implements BranchChangeListener {
    public static final NotificationGroup NOTIFICATION = new NotificationGroup("Branch Context group", NotificationDisplayType.BALLOON, true);
    private final Project myProject;
    private String myLastBranch;

    public BranchContextTracker(@NotNull Project project) {
        if (project == null) {
            BranchContextTracker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    private WorkingContextManager getContextManager() {
        return WorkingContextManager.getInstance(this.myProject);
    }

    public void branchWillChange(@NotNull String branchName) {
        if (branchName == null) {
            BranchContextTracker.$$$reportNull$$$0(1);
        }
        this.myLastBranch = branchName;
        this.getContextManager().saveContext(BranchContextTracker.getContextName(branchName), null);
    }

    public void branchHasChanged(@NotNull String branchName) {
        LocalTask task2;
        List branches;
        if (branchName == null) {
            BranchContextTracker.$$$reportNull$$$0(2);
        }
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (!vcsConfiguration.RELOAD_CONTEXT) {
            return;
        }
        TaskManager manager2 = TaskManager.getManager((Project)this.myProject);
        if (manager2 != null && (branches = (task2 = manager2.getActiveTask()).getBranches(false)).stream().anyMatch(info -> branchName.equals(info.name))) {
            return;
        }
        String contextName = BranchContextTracker.getContextName(branchName);
        if (!this.getContextManager().hasContext(contextName)) {
            return;
        }
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> this.switchContext(branchName, contextName));
    }

    private void switchContext(@NotNull String branchName, String contextName) {
        if (branchName == null) {
            BranchContextTracker.$$$reportNull$$$0(3);
        }
        final WorkingContextManager contextManager = this.getContextManager();
        contextManager.clearContext();
        contextManager.loadContext(contextName);
        Notification notification2 = NOTIFICATION.createNotification(TaskBundle.message("workspace.associated.with.branch.has.been.restored", branchName), NotificationType.INFORMATION);
        if (this.myLastBranch != null && contextManager.hasContext(BranchContextTracker.getContextName(this.myLastBranch))) {
            notification2.addAction((AnAction)new NotificationAction(TaskBundle.messagePointer("action.Anonymous.text.rollback", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    contextManager.clearContext();
                    contextManager.loadContext(BranchContextTracker.getContextName(BranchContextTracker.this.myLastBranch));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/tasks/context/BranchContextTracker$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        notification2.addAction((AnAction)new NotificationAction(TaskBundle.messagePointer("action.Anonymous.text.configure.tree.dots", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                new ConfigureBranchContextDialog(BranchContextTracker.this.myProject).show();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/tasks/context/BranchContextTracker$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setContextHelpAction(new AnAction(TaskBundle.messagePointer("action.BranchContextTracker.Anonymous.text.what.is.a.workspace", new Object[0]), TaskBundle.messagePointer("action.BranchContextTracker.Anonymous.description", new Object[0]), null){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/context/BranchContextTracker$2", "actionPerformed"));
            }
        }).notify(this.myProject);
    }

    @NotNull
    private static String getContextName(String branchName) {
        String string = "__branch_context_" + branchName;
        if (string == null) {
            BranchContextTracker.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/context/BranchContextTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/context/BranchContextTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "branchWillChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "branchHasChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "switchContext";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

