/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.layout.singleRowLayout;

import com.intellij.application.options.editor.EditorTabPlacementKt;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayout;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.ui.tabs.layout.singleRowLayout.SingleRowLayout;
import com.intellij.ui.tabs.layout.singleRowLayout.SingleRowPassInfo;
import com.intellij.ui.tabs.layout.singleRowLayout.TabsSideSplitter;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollableSingleRowLayout
extends SingleRowLayout {
    public static final int DEADZONE_FOR_DECLARE_TAB_HIDDEN = 10;
    private final Alarm afterScrollAlarm = new Alarm();
    private int myScrollOffset = 0;
    private boolean myMouseInsideTabsArea = false;
    private TabsSideSplitter mySplitter = null;

    @Override
    int getScrollOffset() {
        return this.myScrollOffset;
    }

    @Override
    public void scroll(int units) {
        this.myScrollOffset += units;
        this.clampScrollOffsetToBounds(this.myLastSingRowLayout);
    }

    @Override
    protected boolean checkLayoutLabels(SingleRowPassInfo data2, boolean isForcedLayout) {
        TabInfo selectedInfo = this.myCallback.getSelectedInfo();
        boolean scrollSelectionInViewPending = this.isTabOutOfView(selectedInfo);
        if (scrollSelectionInViewPending) {
            return true;
        }
        return super.checkLayoutLabels(data2, isForcedLayout);
    }

    private void clampScrollOffsetToBounds(@Nullable SingleRowPassInfo data2) {
        if (data2 == null) {
            return;
        }
        this.myScrollOffset = data2.requiredLength < data2.toFitLength ? 0 : Math.max(0, Math.min(this.myScrollOffset, data2.requiredLength - data2.toFitLength + this.getStrategy().getMoreRectAxisSize()));
    }

    @Override
    public int getScrollUnitIncrement() {
        List visibleInfos;
        if (this.myLastSingRowLayout != null && (visibleInfos = this.myLastSingRowLayout.myVisibleInfos).size() > 0) {
            TabInfo info = (TabInfo)visibleInfos.get(0);
            return this.getStrategy().getScrollUnitIncrement(this.myCallback.getTabLabel(info));
        }
        return 0;
    }

    private void doScrollSelectionInView(SingleRowPassInfo passInfo) {
        if (this.myMouseInsideTabsArea) {
            return;
        }
        int offset = -this.myScrollOffset;
        for (TabInfo info : passInfo.myVisibleInfos) {
            int length = this.getRequiredLength(info);
            if (info == this.myCallback.getSelectedInfo()) {
                if (offset < 0) {
                    this.scroll(offset);
                    break;
                }
                int maxLength = passInfo.toFitLength - this.getStrategy().getMoreRectAxisSize();
                if (offset + length <= maxLength) break;
                if (length < maxLength) {
                    this.scroll(offset + length - maxLength);
                    break;
                }
                this.scroll(offset);
                break;
            }
            offset += length;
        }
    }

    @Override
    protected void recomputeToLayout(SingleRowPassInfo data2) {
        this.calculateRequiredLength(data2);
        this.doScrollSelectionInView(data2);
        this.clampScrollOffsetToBounds(data2);
    }

    @Override
    protected void layoutMoreButton(SingleRowPassInfo data2) {
        if (data2.requiredLength > data2.toFitLength) {
            data2.moreRect = this.getStrategy().getMoreRect(data2);
            Rectangle bounds2 = new Rectangle(data2.moreRect);
            Dimension preferredSize = this.myMoreToolbar.getComponent().getPreferredSize();
            int xDelta = bounds2.width - preferredSize.width;
            int yDelta = bounds2.height - preferredSize.height;
            bounds2.x += xDelta / 2;
            bounds2.width -= xDelta;
            bounds2.y += yDelta / 2;
            bounds2.height -= yDelta;
            this.myMoreToolbar.getComponent().setBounds(bounds2);
        } else {
            this.myMoreToolbar.getComponent().setBounds(new Rectangle());
        }
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data2, TabLabel label2, int length) {
        int moreRectSize;
        if (data2.requiredLength > data2.toFitLength && data2.position + (length = this.getStrategy().getLengthIncrement(label2.getPreferredSize())) > data2.toFitLength - (moreRectSize = this.getStrategy().getMoreRectAxisSize())) {
            int clippedLength = this.getStrategy().drawPartialOverflowTabs() ? data2.toFitLength - data2.position - moreRectSize : 0;
            super.applyTabLayout(data2, label2, clippedLength);
            label2.setAlignmentToCenter(false);
            return false;
        }
        return super.applyTabLayout(data2, label2, length);
    }

    @Override
    public boolean isTabOutOfView(TabInfo tabInfo) {
        TabLabel label2 = this.myCallback.getTabLabel(tabInfo);
        if (label2 == null) {
            return false;
        }
        Rectangle bounds2 = label2.getBounds();
        return this.getStrategy().getMinPosition(bounds2) < -10 || bounds2.width < label2.getPreferredSize().width - 10 || bounds2.height < label2.getPreferredSize().height - 10;
    }

    @Override
    protected int getSplitterSideTabsLimit() {
        return this.mySplitter == null ? 0 : this.mySplitter.getSideTabsLimit();
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.afterScrollAlarm);
        this.detachSplitter();
    }

    @Override
    protected SingleRowPassInfo doLayout(List<TabInfo> infosToShow, boolean isForced) {
        LayoutPassInfo data2 = super.doLayout((List)infosToShow, isForced);
        this.dealWithSplitter((SingleRowPassInfo)data2);
        return data2;
    }

    private void dealWithSplitter(SingleRowPassInfo data2) {
        if (this.myCallback.getTabsPosition().isSide()) {
            this.attachSplitter();
            this.setUpSplitter(data2);
        } else {
            this.detachSplitter();
        }
    }

    private void attachSplitter() {
        if (this.mySplitter == null) {
            this.mySplitter = new TabsSideSplitter(this.myCallback);
            this.mySplitter.getDivider().setOpaque(false);
        }
        OnePixelDivider divider = this.mySplitter.getDivider();
        JComponent component2 = this.myCallback.getComponent();
        if (divider.getParent() != component2) {
            component2.add((Component)divider);
        }
    }

    private void setUpSplitter(SingleRowPassInfo data2) {
        int dividerX = this.myCallback.getTabsPosition() == JBTabsPosition.left ? data2.insets.left + data2.tabRectangle.width : data2.layoutSize.width - data2.insets.right - data2.tabRectangle.width;
        int dividerHeight = data2.layoutRectWithoutInsets.height;
        this.mySplitter.getDivider().setBounds(dividerX, data2.insets.top, 1, dividerHeight);
    }

    private void detachSplitter() {
        OnePixelDivider divider;
        if (this.mySplitter != null && (divider = this.mySplitter.getDivider()).getParent() != null) {
            this.myCallback.getComponent().remove((Component)divider);
        }
    }

    @Override
    @Nullable
    public MouseWheelListener getMouseWheelListener() {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                int units = event.getUnitsToScroll();
                if (units == 0) {
                    return;
                }
                if (ScrollableSingleRowLayout.this.myLastSingRowLayout != null) {
                    ScrollableSingleRowLayout.this.scroll((int)(event.getPreciseWheelRotation() * (double)ScrollableSingleRowLayout.this.getScrollUnitIncrement()));
                    ScrollableSingleRowLayout.this.myCallback.relayout(false, false);
                }
            }
        };
    }

    @Override
    public void mouseMotionEventDispatched(MouseEvent mouseMotionEvent) {
        if (this.myLastSingRowLayout == null) {
            return;
        }
        Point point = mouseMotionEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseMotionEvent.getComponent());
        Rectangle rect = this.myCallback.getComponent().getVisibleRect();
        rect = rect.intersection(this.myLastSingRowLayout.tabRectangle);
        Point p = rect.getLocation();
        SwingUtilities.convertPointToScreen(p, this.myCallback.getComponent());
        rect.setLocation(p);
        boolean inside = rect.contains(point);
        if (inside != this.myMouseInsideTabsArea) {
            this.myMouseInsideTabsArea = inside;
            this.afterScrollAlarm.cancelAllRequests();
            if (!inside) {
                this.afterScrollAlarm.addRequest(() -> {
                    if (!this.myMouseInsideTabsArea) {
                        this.myCallback.relayout(false, false);
                    }
                }, 500);
            }
        }
    }

    @Override
    public boolean ignoreTabLabelLimitedWidthWhenPaint() {
        return true;
    }

    public static class ScrollableSingleRowTabsLayoutInfo
    extends TabsLayoutInfo {
        @NonNls
        private static final String ID = "ScrollableSingleRowTabsLayoutInfo";
        private JPanel myPanel;
        public JCheckBox myCheckBox;

        @NotNull
        public String getId() {
            return ID;
        }

        @NotNull
        public String getName() {
            String string = IdeBundle.message((String)"tabs.layout.scrollable.single.row.name", (Object[])new Object[0]);
            if (string == null) {
                ScrollableSingleRowTabsLayoutInfo.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        protected TabsLayout createTabsLayoutInstance() {
            return new ScrollableSingleRowLayout();
        }

        @Nullable
        public Integer[] getAvailableTabsPositions() {
            return EditorTabPlacementKt.getTAB_PLACEMENTS();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/layout/singleRowLayout/ScrollableSingleRowLayout$ScrollableSingleRowTabsLayoutInfo", "getName"));
        }
    }
}

