/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointDependencyState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XDependentBreakpointManager {
    private final Map<XBreakpoint<?>, XDependentBreakpointInfo> mySlave2Info;
    private final MultiMap<XBreakpointBase, XDependentBreakpointInfo> myMaster2Info;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final XDependentBreakpointListener myEventPublisher;

    public XDependentBreakpointManager(@NotNull XBreakpointManagerImpl breakpointManager, @NotNull MessageBusConnection messageBusConnection) {
        if (breakpointManager == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(0);
        }
        if (messageBusConnection == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(1);
        }
        this.mySlave2Info = new HashMap();
        this.myMaster2Info = new MultiMap();
        this.myBreakpointManager = breakpointManager;
        this.myEventPublisher = (XDependentBreakpointListener)breakpointManager.getProject().getMessageBus().syncPublisher(XDependentBreakpointListener.TOPIC);
        messageBusConnection.subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
                Collection infos;
                XDependentBreakpointInfo info;
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((info = XDependentBreakpointManager.this.mySlave2Info.remove(breakpoint)) != null) {
                    XDependentBreakpointManager.this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
                }
                if ((infos = XDependentBreakpointManager.this.myMaster2Info.remove((Object)((XBreakpointBase)breakpoint))) != null) {
                    for (XDependentBreakpointInfo breakpointInfo : infos) {
                        XDependentBreakpointInfo removed = XDependentBreakpointManager.this.mySlave2Info.remove(breakpointInfo.mySlaveBreakpoint);
                        if (removed == null) continue;
                        XDependentBreakpointManager.this.myEventPublisher.dependencyCleared(breakpointInfo.mySlaveBreakpoint);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager$1", "breakpointRemoved"));
            }
        });
    }

    public void loadState() {
        XBreakpointDependencyState state;
        XBreakpointBase<?, ?, ?>[] allBreakpoints;
        this.mySlave2Info.clear();
        this.myMaster2Info.clear();
        HashMap id2Breakpoint = new HashMap();
        for (XBreakpointBase<?, ?, ?> breakpoint : allBreakpoints = this.myBreakpointManager.getAllBreakpoints()) {
            String id2;
            state = breakpoint.getDependencyState();
            if (state == null || (id2 = state.getId()) == null) continue;
            id2Breakpoint.put(id2, breakpoint);
        }
        for (XBreakpointBase<?, ?, ?> breakpoint : allBreakpoints) {
            XBreakpointBase master;
            String masterId;
            state = breakpoint.getDependencyState();
            if (state == null || (masterId = state.getMasterBreakpointId()) == null || (master = (XBreakpointBase)id2Breakpoint.get(masterId)) == null) continue;
            this.addDependency(master, breakpoint, state.isLeaveEnabled());
        }
    }

    public void saveState() {
        HashMap<XBreakpointBase, String> breakpointToId = new HashMap<XBreakpointBase, String>();
        int id2 = 0;
        for (XBreakpointBase xBreakpointBase : this.myMaster2Info.keySet()) {
            breakpointToId.put(xBreakpointBase, String.valueOf(id2++));
        }
        for (XDependentBreakpointInfo xDependentBreakpointInfo : this.mySlave2Info.values()) {
            XBreakpointDependencyState state = new XBreakpointDependencyState((String)breakpointToId.get(xDependentBreakpointInfo.mySlaveBreakpoint), (String)breakpointToId.get(xDependentBreakpointInfo.myMasterBreakpoint), xDependentBreakpointInfo.myLeaveEnabled);
            xDependentBreakpointInfo.mySlaveBreakpoint.setDependencyState(state);
        }
        for (Map.Entry entry : breakpointToId.entrySet()) {
            if (this.mySlave2Info.containsKey(entry.getKey())) continue;
            ((XBreakpointBase)entry.getKey()).setDependencyState(new XBreakpointDependencyState((String)entry.getValue()));
        }
    }

    public void setMasterBreakpoint(@NotNull XBreakpoint<?> slave, @NotNull XBreakpoint<?> master, boolean leaveEnabled) {
        XDependentBreakpointInfo info;
        if (slave == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(2);
        }
        if (master == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(3);
        }
        if ((info = this.mySlave2Info.get(slave)) == null) {
            this.addDependency((XBreakpointBase)master, (XBreakpointBase)slave, leaveEnabled);
        } else if (info.myMasterBreakpoint == master) {
            info.myLeaveEnabled = leaveEnabled;
        } else {
            this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
            info.myMasterBreakpoint = (XBreakpointBase)master;
            info.myLeaveEnabled = leaveEnabled;
            this.myMaster2Info.putValue((Object)((XBreakpointBase)master), (Object)info);
        }
        this.myEventPublisher.dependencySet(slave, master);
    }

    public void clearMasterBreakpoint(@NotNull XBreakpoint<?> slave) {
        XDependentBreakpointInfo info;
        if (slave == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(4);
        }
        if ((info = this.mySlave2Info.remove(slave)) != null) {
            this.myMaster2Info.remove((Object)info.myMasterBreakpoint, (Object)info);
            this.myEventPublisher.dependencyCleared(slave);
        }
    }

    private void addDependency(@NotNull XBreakpointBase<?, ?, ?> master, XBreakpointBase<?, ?, ?> slave, boolean leaveEnabled) {
        if (master == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(5);
        }
        XDependentBreakpointInfo info = new XDependentBreakpointInfo(master, slave, leaveEnabled);
        this.mySlave2Info.put(slave, info);
        this.myMaster2Info.putValue(master, (Object)info);
    }

    @Nullable
    public XBreakpoint<?> getMasterBreakpoint(@NotNull XBreakpoint<?> slave) {
        XDependentBreakpointInfo info;
        if (slave == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(6);
        }
        return (info = this.mySlave2Info.get(slave)) != null ? info.myMasterBreakpoint : null;
    }

    public boolean isLeaveEnabled(@NotNull XBreakpoint<?> slave) {
        XDependentBreakpointInfo info;
        if (slave == null) {
            XDependentBreakpointManager.$$$reportNull$$$0(7);
        }
        return (info = this.mySlave2Info.get(slave)) != null && info.myLeaveEnabled;
    }

    public List<XBreakpoint<?>> getSlaveBreakpoints(XBreakpoint<?> breakpoint) {
        Collection slaveInfos = this.myMaster2Info.get((Object)((XBreakpointBase)breakpoint));
        if (slaveInfos.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList breakpoints = new SmartList();
        for (XDependentBreakpointInfo slaveInfo : slaveInfos) {
            breakpoints.add(slaveInfo.mySlaveBreakpoint);
        }
        return breakpoints;
    }

    public boolean isMasterOrSlave(XBreakpoint<?> breakpoint) {
        return this.myMaster2Info.containsKey((Object)((XBreakpointBase)breakpoint)) || this.mySlave2Info.containsKey(breakpoint);
    }

    public Set<XBreakpoint<?>> getAllSlaveBreakpoints() {
        return this.mySlave2Info.keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBusConnection";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slave";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "master";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setMasterBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearMasterBreakpoint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addDependency";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getMasterBreakpoint";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isLeaveEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    class DependenciesData {
        private final Collection<XDependentBreakpointInfo> myDependencies = new SmartList();
        private final XBreakpointBase myBreakpoint;

        DependenciesData(XBreakpointBase breakpoint) {
            this.myBreakpoint = breakpoint;
            ContainerUtil.addIfNotNull(this.myDependencies, (Object)XDependentBreakpointManager.this.mySlave2Info.get(breakpoint));
            this.myDependencies.addAll(XDependentBreakpointManager.this.myMaster2Info.get((Object)breakpoint));
        }

        void restore(XBreakpointBase breakpoint) {
            this.myDependencies.forEach(d -> XDependentBreakpointManager.this.addDependency(this.replaceSelf(d.myMasterBreakpoint, breakpoint), this.replaceSelf(d.mySlaveBreakpoint, breakpoint), d.myLeaveEnabled));
        }

        private XBreakpointBase replaceSelf(XBreakpointBase breakpoint, XBreakpointBase self) {
            return breakpoint == this.myBreakpoint ? self : breakpoint;
        }
    }

    private static final class XDependentBreakpointInfo {
        private XBreakpointBase myMasterBreakpoint;
        private final XBreakpointBase mySlaveBreakpoint;
        private boolean myLeaveEnabled;

        private XDependentBreakpointInfo(@NotNull XBreakpointBase masterBreakpoint, XBreakpointBase slaveBreakpoint, boolean leaveEnabled) {
            if (masterBreakpoint == null) {
                XDependentBreakpointInfo.$$$reportNull$$$0(0);
            }
            this.myMasterBreakpoint = masterBreakpoint;
            this.myLeaveEnabled = leaveEnabled;
            this.mySlaveBreakpoint = slaveBreakpoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterBreakpoint", "com/intellij/xdebugger/impl/breakpoints/XDependentBreakpointManager$XDependentBreakpointInfo", "<init>"));
        }
    }
}

