/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;

public class XDebuggerTreeInlayPopup<D> {
    public static final String ACTION_PLACE = "XDebuggerTreeInlayPopup";
    protected final DebuggerTreeCreator<D> myTreeCreator;
    private final XSourcePosition myPresentationPosition;
    @NotNull
    protected final XDebugSession mySession;
    @NonNls
    private static final String DIMENSION_SERVICE_KEY = "DebuggerActiveHint";
    private JBPopup myPopup;
    private final Editor myEditor;
    private final Point myPoint;
    @Nullable
    private final Runnable myHideRunnable;
    private final XValueNodeImpl myValueNode;
    private JComponent myToolbar;

    private XDebuggerTreeInlayPopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull Editor editor, @NotNull Point point, @NotNull XSourcePosition presentationPosition, @NotNull XDebugSession session2, @Nullable Runnable hideRunnable, @NotNull XValueNodeImpl valueNode) {
        if (creator == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(1);
        }
        if (point == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(2);
        }
        if (presentationPosition == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(3);
        }
        if (session2 == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(4);
        }
        if (valueNode == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(5);
        }
        this.myTreeCreator = creator;
        this.myPresentationPosition = presentationPosition;
        this.mySession = session2;
        this.myEditor = editor;
        this.myPoint = point;
        this.myHideRunnable = hideRunnable;
        this.myValueNode = valueNode;
    }

    protected BorderLayoutPanel createMainPanel(Tree tree) {
        return this.fillMainPanel(JBUI.Panels.simplePanel(), tree);
    }

    protected BorderLayoutPanel fillMainPanel(BorderLayoutPanel mainPanel, Tree tree) {
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree, (boolean)true);
        JComponent toolbar = this.createToolbar((JPanel)mainPanel, tree);
        tree.setBackground(UIUtil.getToolTipBackground());
        toolbar.setBackground(UIUtil.getToolTipActionBackground());
        WindowMoveListener moveListener = new WindowMoveListener((Component)mainPanel);
        toolbar.addMouseListener(moveListener);
        toolbar.addMouseMotionListener(moveListener);
        return mainPanel.addToCenter((Component)scrollPane).addToBottom((Component)toolbar);
    }

    protected void updateTree(@NotNull D selectedItem) {
        if (selectedItem == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(6);
        }
        this.updateContainer(this.myTreeCreator.createTree(selectedItem));
    }

    private JComponent createToolbar(JPanel mainPanel, Tree tree) {
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        toolbarActions.addAll(DebuggerSessionTabBase.getCustomizedActionGroup("XDebugger.Watches.Inline.Popup"));
        if (Registry.is((String)"debugger.watches.inline.enabled")) {
            AnAction watchAction = this.myValueNode instanceof InlineWatchNodeImpl ? new EditInlineWatch() : new AddInlineWatch();
            toolbarActions.add(watchAction, Constraints.LAST);
        }
        DefaultActionGroup wrappedActions = new DefaultActionGroup();
        for (AnAction action2 : toolbarActions.getChildren(null)) {
            ActionWrapper actionLink = new ActionWrapper(action2);
            actionLink.setDataProvider((Component)tree);
            wrappedActions.add((AnAction)actionLink);
        }
        this.myToolbar = new ActionToolbarImpl(ACTION_PLACE, (ActionGroup)wrappedActions, true);
        for (AnAction action2 : wrappedActions.getChildren(null)) {
            action2.registerCustomShortcutSet(action2.getShortcutSet(), (JComponent)mainPanel);
        }
        this.myToolbar.setBorder(BorderFactory.createEmptyBorder());
        return this.myToolbar;
    }

    protected static void registerTreeDisposable(Disposable disposable2, Tree tree) {
        if (tree instanceof Disposable) {
            Disposer.register((Disposable)disposable2, (Disposable)((Disposable)tree));
        }
    }

    public static void showTreePopup(XDebuggerTreeCreator creator, Pair<XValue, String> initialItem, XValueNodeImpl valueNode, @NotNull Editor editor, @NotNull Point point, @NotNull XSourcePosition position, @NotNull XDebugSession session2, Runnable hideRunnable) {
        if (editor == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(7);
        }
        if (point == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(8);
        }
        if (position == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(9);
        }
        if (session2 == null) {
            XDebuggerTreeInlayPopup.$$$reportNull$$$0(10);
        }
        new XDebuggerTreeInlayPopup<Pair<XValue, String>>(creator, editor, point, position, session2, hideRunnable, valueNode).updateTree(initialItem);
    }

    private TreeModelListener createTreeListener(final Tree tree) {
        return new TreeModelAdapter(){

            public void treeStructureChanged(TreeModelEvent e) {
                XDebuggerTreeInlayPopup.this.resize(e.getTreePath(), (JTree)tree);
            }
        };
    }

    protected void updateContainer(final Tree tree) {
        if (this.myPopup != null) {
            this.myPopup.cancel();
        }
        tree.getModel().addTreeModelListener(this.createTreeListener(tree));
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.createMainPanel(tree), (JComponent)tree).setRequestFocus(true).setResizable(true).setMovable(true).setDimensionServiceKey(this.mySession.getProject(), DIMENSION_SERVICE_KEY, false).setMayBeParent(true).setCancelOnOtherWindowOpen(true).setKeyEventHandler(event -> {
            if (AbstractPopup.isCloseRequest(event)) {
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply((JComponent)tree);
                return supply != null && StringUtil.isEmpty((String)supply.getEnteredPrefix());
            }
            return false;
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (XDebuggerTreeInlayPopup.this.myHideRunnable != null) {
                    XDebuggerTreeInlayPopup.this.myHideRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$2", "onClosed"));
            }
        }).setCancelCallback(() -> {
            Window parent = SwingUtilities.getWindowAncestor((Component)tree);
            if (parent != null) {
                for (Window child2 : parent.getOwnedWindows()) {
                    if (!child2.isShowing()) continue;
                    return false;
                }
            }
            return true;
        }).createPopup();
        XDebuggerTreeInlayPopup.registerTreeDisposable((Disposable)this.myPopup, tree);
        if (this.myEditor.getComponent().getRootPane() == null) {
            this.myPopup.cancel();
            return;
        }
        this.myPopup.setSize(new Dimension(0, 0));
        this.myPopup.show(new RelativePoint((Component)this.myEditor.getContentComponent(), this.myPoint));
        ((XDebuggerTree)tree).addTreeListener(new XDebuggerTreeListener(){

            @Override
            public void childrenLoaded(@NotNull XDebuggerTreeNode node, @NotNull List<? extends XValueContainerNode<?>> children2, boolean last) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (children2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (last) {
                    XDebuggerTreeInlayPopup.this.updateInitialBounds(tree);
                    ((XDebuggerTree)tree).removeTreeListener(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "children";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$3";
                objectArray[2] = "childrenLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.updateInitialBounds(tree);
    }

    private void resize(TreePath path, JTree tree) {
        if (this.myPopup == null || !this.myPopup.isVisible() || this.myPopup.isDisposed()) {
            return;
        }
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        if (popupWindow == null) {
            return;
        }
        Dimension size = tree.getPreferredSize();
        Point location = popupWindow.getLocation();
        Rectangle windowBounds = popupWindow.getBounds();
        Rectangle bounds2 = tree.getPathBounds(path);
        if (bounds2 == null) {
            return;
        }
        Rectangle targetBounds = new Rectangle(location.x, location.y, Math.max(Math.max(size.width, bounds2.width) + 20, windowBounds.width), Math.max(tree.getRowCount() * bounds2.height + 55, windowBounds.height));
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        popupWindow.setBounds(targetBounds);
        popupWindow.validate();
        popupWindow.repaint();
    }

    private void updateInitialBounds(Tree tree) {
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        Dimension size = tree.getPreferredSize();
        Point location = popupWindow.getLocation();
        int width = Math.max(size.width, this.myToolbar.getPreferredSize().width) + 150;
        int maxWidth = 600;
        int row = Math.min(12, tree.getRowCount() - 1);
        Rectangle bounds2 = tree.getRowBounds(row);
        int margin = 30;
        int height = this.myToolbar.getHeight() + margin + (bounds2 == null ? 0 : bounds2.y + bounds2.height);
        Rectangle targetBounds = new Rectangle(location.x, location.y, Math.min(width, maxWidth), height);
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        popupWindow.setBounds(targetBounds);
        popupWindow.validate();
        popupWindow.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationPosition";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedItem";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTree";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showTreePopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ActionLinkButton
    extends ActionLink {
        @Nullable
        private final DataProvider myDataProvider;
        boolean isEnabled;

        ActionLinkButton(@NotNull AnAction action2, @NotNull Presentation presentation2, @Nullable DataProvider contextComponent) {
            if (action2 == null) {
                ActionLinkButton.$$$reportNull$$$0(0);
            }
            if (presentation2 == null) {
                ActionLinkButton.$$$reportNull$$$0(1);
            }
            super(presentation2.getText(), action2);
            this.isEnabled = presentation2.isEnabled();
            this.myDataProvider = contextComponent;
            presentation2.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "text") {
                        this.setText((String)evt.getNewValue());
                        this.repaint();
                    }
                    if (evt.getPropertyName() == "enabled") {
                        isEnabled = (Boolean)evt.getNewValue();
                        this.repaint();
                    }
                }
            });
            this.setFont(UIUtil.getToolTipFont());
        }

        protected Color getTextColor() {
            return this.isEnabled ? super.getTextColor() : ActionLinkButton.getDisabledColor();
        }

        private static Color getDisabledColor() {
            return JBUI.CurrentTheme.Label.disabledForeground();
        }

        public Object getData(@NotNull @NonNls String dataId) {
            Object data2;
            if (dataId == null) {
                ActionLinkButton.$$$reportNull$$$0(2);
            }
            if ((data2 = super.getData(dataId)) != null) {
                return data2;
            }
            return this.myDataProvider != null ? this.myDataProvider.getData(dataId) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$ActionLinkButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ActionWrapper
    extends AnAction
    implements CustomComponentAction {
        private final AnAction myDelegate;
        private Component myProvider;

        ActionWrapper(AnAction delegate) {
            super(delegate.getTemplateText());
            this.copyFrom(delegate);
            this.myDelegate = delegate;
        }

        public void setDataProvider(Component provider2) {
            this.myProvider = provider2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ActionWrapper.$$$reportNull$$$0(0);
            }
            AnActionEvent delegateEvent = AnActionEvent.createFromAnAction((AnAction)this.myDelegate, (InputEvent)e.getInputEvent(), (String)XDebuggerTreeInlayPopup.ACTION_PLACE, (DataContext)DataManager.getInstance().getDataContext(this.myProvider));
            this.myDelegate.actionPerformed(delegateEvent);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ActionWrapper.$$$reportNull$$$0(1);
            }
            this.myDelegate.update(e);
        }

        public boolean isDumbAware() {
            return this.myDelegate.isDumbAware();
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                ActionWrapper.$$$reportNull$$$0(2);
            }
            if (place == null) {
                ActionWrapper.$$$reportNull$$$0(3);
            }
            this.myDelegate.applyTextOverride(XDebuggerTreeInlayPopup.ACTION_PLACE, presentation2);
            JPanel actionPanel = new JPanel(new GridBagLayout());
            GridBag gridBag = new GridBag().fillCellHorizontally().anchor(17);
            int topInset = 5;
            int bottomInset = 4;
            ActionLinkButton button2 = new ActionLinkButton(this, presentation2, (DataProvider)this.myProvider);
            actionPanel.add((Component)((Object)button2), gridBag.next().insets(topInset, 10, bottomInset, 4));
            Shortcut[] shortcuts = this.getShortcutSet().getShortcuts();
            String shortcutsText = KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
            if (!shortcutsText.isEmpty()) {
                JComponent keymapHint = ActionWrapper.createKeymapHint(shortcutsText);
                actionPanel.add((Component)keymapHint, gridBag.next().insets(topInset, 4, bottomInset, 12));
            }
            actionPanel.setBackground(UIUtil.getToolTipActionBackground());
            JPanel jPanel2 = actionPanel;
            if (jPanel2 == null) {
                ActionWrapper.$$$reportNull$$$0(4);
            }
            return jPanel2;
        }

        private static JComponent createKeymapHint(@NlsContexts.Label String shortcutRunAction) {
            JBLabel shortcutHint = new JBLabel(shortcutRunAction){

                public Color getForeground() {
                    return ActionWrapper.getKeymapColor();
                }
            };
            shortcutHint.setBorder((Border)JBUI.Borders.empty());
            shortcutHint.setFont(UIUtil.getToolTipFont());
            return shortcutHint;
        }

        private static Color getKeymapColor() {
            return JBColor.namedColor((String)"ToolTip.Actions.infoForeground", (Color)new JBColor(10069165, 0x919191));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$ActionWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$ActionWrapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class EditInlineWatch
    extends AnAction {
        EditInlineWatch() {
            super(XDebuggerBundle.message((String)"debugger.inline.watches.edit.watch.expression.text", (Object[])new Object[0]));
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                EditInlineWatch.$$$reportNull$$$0(0);
            }
            InlineWatchNodeImpl watch = (InlineWatchNodeImpl)XDebuggerTreeInlayPopup.this.myValueNode;
            XDebuggerWatchesManager watchesManager = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)XDebuggerTreeInlayPopup.this.mySession.getProject())).getWatchesManager();
            XDebugSession session2 = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
            if (session2 == null && (project = e.getProject()) != null) {
                session2 = XDebuggerManager.getInstance((Project)project).getCurrentSession();
            }
            if (session2 != null) {
                XDebuggerTreeInlayPopup.this.myPopup.cancel();
                watchesManager.inlineWatchesRemoved(Collections.singletonList(watch.getWatch()), null);
                watchesManager.showInplaceEditor(watch.getPosition(), XDebuggerTreeInlayPopup.this.myEditor, session2, watch.getExpression());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$EditInlineWatch", "actionPerformed"));
        }
    }

    private class AddInlineWatch
    extends XDebuggerTreeActionBase {
        private AddInlineWatch() {
            ActionUtil.mergeFrom((AnAction)this, (String)"Debugger.AddInlineWatch");
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setText(XDebuggerBundle.message((String)"debugger.inline.watches.popup.action.add.as.inline.watch", (Object[])new Object[0]));
        }

        @Override
        protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
            if (nodeName == null) {
                AddInlineWatch.$$$reportNull$$$0(0);
            }
            ((XValue)node.getValueContainer()).calculateEvaluationExpression().thenAsync(expr -> {
                if (expr == null && node != XDebuggerTreeInlayPopup.this.myValueNode) {
                    return ((XValue)XDebuggerTreeInlayPopup.this.myValueNode.getValueContainer()).calculateEvaluationExpression();
                }
                return Promises.resolvedPromise((Object)expr);
            }).onSuccess(expr -> AppUIUtil.invokeOnEdt(() -> {
                XDebuggerWatchesManager manager2 = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)XDebuggerTreeInlayPopup.this.mySession.getProject())).getWatchesManager();
                manager2.showInplaceEditor(XDebuggerTreeInlayPopup.this.myPresentationPosition, XDebuggerTreeInlayPopup.this.myEditor, XDebuggerTreeInlayPopup.this.mySession, (XExpression)expr);
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/xdebugger/impl/inline/XDebuggerTreeInlayPopup$AddInlineWatch", "perform"));
        }
    }
}

