/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

public class ApkContentFilter {
    public boolean checkEntry(String name) {
        String[] segments = name.split("/");
        if (segments.length == 0) {
            return false;
        }
        for (int i = 0; i < segments.length - 1; ++i) {
            if (ApkContentFilter.checkFolderForPackaging(segments[i])) continue;
            return false;
        }
        String fileName = segments[segments.length - 1];
        return ApkContentFilter.checkFileForPackaging(fileName);
    }

    public static boolean checkFolderForPackaging(String folderName) {
        return !folderName.equals("CVS") && !folderName.equals(".svn") && !folderName.equals("SCCS") && !folderName.equals("META-INF") && !folderName.startsWith("_");
    }

    public static boolean checkFileForPackaging(String fileName) {
        String[] fileSegments = fileName.split("\\.");
        String fileExt = "";
        if (fileSegments.length > 1) {
            fileExt = fileSegments[fileSegments.length - 1];
        }
        return ApkContentFilter.checkFileForPackaging(fileName, fileExt);
    }

    public static boolean checkFileForPackaging(String fileName, String extension) {
        if (fileName.charAt(0) == '.') {
            return false;
        }
        return !"aidl".equalsIgnoreCase(extension) && !"java".equalsIgnoreCase(extension) && !"class".equalsIgnoreCase(extension) && !"scc".equalsIgnoreCase(extension) && !"swp".equalsIgnoreCase(extension) && !"package.html".equalsIgnoreCase(fileName) && !"overview.html".equalsIgnoreCase(fileName) && !".cvsignore".equalsIgnoreCase(fileName) && !".DS_Store".equals(fileName) && fileName.charAt(fileName.length() - 1) != '~';
    }
}

