/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.android.tools.build.apkzlib.sign.SigningOptions;
import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.ApkZFileCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.android.tools.build.apkzlib.zip.Compressor;
import com.android.tools.build.apkzlib.zip.ZFileOptions;
import com.android.tools.build.apkzlib.zip.compress.DeflateExecutionCompressor;
import com.google.common.base.Predicate;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.Nullable;

public class SafeSignedJarBuilder
implements AutoCloseable {
    private final String myOutFilePath;
    private final ApkCreator apkCreator;

    public SafeSignedJarBuilder(PrivateKey key, X509Certificate certificate, String outFilePath) throws IOException {
        ZFileOptions options = new ZFileOptions();
        options.setNoTimestamps(true);
        options.setCoverEmptySpaceUsingExtraField(true);
        options.setAutoSortFiles(true);
        options.setCompressor((Compressor)new DeflateExecutionCompressor((Executor)AppExecutorUtil.getAppExecutorService(), 1));
        ApkZFileCreatorFactory factory = new ApkZFileCreatorFactory(options);
        Path apkPath = new File(outFilePath).toPath();
        if (Files.isRegularFile(apkPath, new LinkOption[0]) && Files.size(apkPath) == 0L) {
            Files.delete(apkPath);
        }
        ApkCreatorFactory.CreationData.Builder creationData = ApkCreatorFactory.CreationData.builder().setApkPath(apkPath.toFile()).setBuiltBy("IntelliJ IDEA").setCreatedBy("IntelliJ IDEA").setIncremental(false).setNativeLibrariesPackagingMode(NativeLibrariesPackagingMode.UNCOMPRESSED_AND_ALIGNED);
        if (key != null && certificate != null) {
            SigningOptions signingOptions = SigningOptions.builder().setCertificates(new X509Certificate[]{certificate}).setKey(key).setV1SigningEnabled(true).setMinSdkVersion(1).build();
            creationData.setSigningOptions(signingOptions);
        }
        this.apkCreator = factory.make(creationData.build());
        this.myOutFilePath = FileUtil.toSystemDependentName((String)outFilePath);
    }

    public void writeFile(File inputFile, String jarPath) throws IOException {
        if (FileUtil.pathsEqual((String)inputFile.getPath(), (String)this.myOutFilePath)) {
            throw new IOException("Cannot pack file " + this.myOutFilePath + " into itself");
        }
        this.apkCreator.writeFile(inputFile, jarPath);
    }

    @Override
    public void close() throws IOException {
        this.apkCreator.close();
    }

    public void writeZip(File zip, @Nullable Predicate<String> isIgnored) throws IOException {
        this.apkCreator.writeZip(zip, null, isIgnored);
    }
}

