/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.ThreadObj;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.Collection;

public class Heap {
    private final int mId;
    private final String mName;
    TIntObjectHashMap<ThreadObj> mThreads = new TIntObjectHashMap();
    TLongObjectHashMap<ClassObj> mClassesById = new TLongObjectHashMap();
    Multimap<String, ClassObj> mClassesByName = ArrayListMultimap.create();
    private final TLongObjectHashMap<Instance> mInstances = new TLongObjectHashMap();
    Snapshot mSnapshot;

    public Heap(int id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public final void addThread(ThreadObj thread, int serialNumber) {
        this.mThreads.put(serialNumber, (Object)thread);
    }

    public final ThreadObj getThread(int serialNumber) {
        return (ThreadObj)this.mThreads.get(serialNumber);
    }

    public final void addInstance(long id, Instance instance) {
        this.mInstances.put(id, (Object)instance);
    }

    public final Instance getInstance(long id) {
        return (Instance)this.mInstances.get(id);
    }

    public final void addClass(long id, ClassObj theClass) {
        this.mClassesById.put(id, (Object)theClass);
        this.mClassesByName.put((Object)theClass.mClassName, (Object)theClass);
    }

    public final ClassObj getClass(long id) {
        return (ClassObj)this.mClassesById.get(id);
    }

    public final ClassObj getClass(String name) {
        Collection classes = this.mClassesByName.get((Object)name);
        if (classes.size() == 1) {
            return (ClassObj)classes.iterator().next();
        }
        return null;
    }

    public final Collection<ClassObj> getClasses(String name) {
        return this.mClassesByName.get((Object)name);
    }

    public final void dumpInstanceCounts() {
        for (Object value : this.mClassesById.getValues()) {
            ClassObj theClass = (ClassObj)value;
            int count = theClass.getInstanceCount();
            if (count <= 0) continue;
            System.out.println(theClass + ": " + count);
        }
    }

    public final void dumpSubclasses() {
        for (Object value : this.mClassesById.getValues()) {
            ClassObj theClass = (ClassObj)value;
            int count = theClass.mSubclasses.size();
            if (count <= 0) continue;
            System.out.println(theClass);
            theClass.dumpSubclasses();
        }
    }

    public final void dumpSizes() {
        for (Object value : this.mClassesById.getValues()) {
            ClassObj theClass = (ClassObj)value;
            int size = 0;
            for (Instance instance : theClass.getHeapInstances(this.getId())) {
                size += instance.getCompositeSize();
            }
            if (size <= 0) continue;
            System.out.println(theClass + ": base " + theClass.getSize() + ", composite " + size);
        }
    }

    public Collection<ClassObj> getClasses() {
        return this.mClassesByName.values();
    }

    public void forEachInstance(TObjectProcedure<Instance> procedure) {
        this.mInstances.forEachValue(procedure);
    }

    public int getInstancesCount() {
        return this.mInstances.size();
    }
}

