/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.io;

import com.android.tools.perflib.captures.DataBuffer;
import java.nio.ByteBuffer;

public class InMemoryBuffer
implements DataBuffer {
    private final ByteBuffer mBuffer;

    public InMemoryBuffer(int capacity) {
        this.mBuffer = ByteBuffer.allocateDirect(capacity);
    }

    public InMemoryBuffer(byte[] data) {
        this.mBuffer = ByteBuffer.wrap(data);
    }

    public InMemoryBuffer(ByteBuffer data) {
        this.mBuffer = data;
        this.mBuffer.rewind();
    }

    @Override
    public void dispose() {
    }

    public ByteBuffer getDirectBuffer() {
        return this.mBuffer;
    }

    @Override
    public byte readByte() {
        return this.mBuffer.get();
    }

    @Override
    public void append(byte[] data) {
    }

    @Override
    public void read(byte[] b) {
        this.mBuffer.get(b);
    }

    @Override
    public void readSubSequence(byte[] b, int sourceStart, int sourceEnd) {
        ((ByteBuffer)this.mBuffer.slice().position(sourceStart)).get(b);
    }

    @Override
    public char readChar() {
        return this.mBuffer.getChar();
    }

    @Override
    public short readShort() {
        return this.mBuffer.getShort();
    }

    @Override
    public int readInt() {
        return this.mBuffer.getInt();
    }

    @Override
    public long readLong() {
        return this.mBuffer.getLong();
    }

    @Override
    public float readFloat() {
        return this.mBuffer.getFloat();
    }

    @Override
    public double readDouble() {
        return this.mBuffer.getDouble();
    }

    @Override
    public void setPosition(long position) {
        this.mBuffer.position((int)position);
    }

    @Override
    public long position() {
        return this.mBuffer.position();
    }

    @Override
    public boolean hasRemaining() {
        return this.mBuffer.hasRemaining();
    }

    @Override
    public long remaining() {
        return this.mBuffer.remaining();
    }
}

