/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.memoryanalyzer.Printer;
import com.android.tools.perflib.heap.memoryanalyzer.Report;
import com.android.tools.perflib.heap.memoryanalyzer.TopMemoryOffendersAnalyzerTask;
import java.util.List;

public final class TopMemoryOffendersReport
implements Report {
    private List<AnalysisResultEntry<?>> mResults;

    @Override
    public void generate(List<AnalysisResultEntry<?>> data) {
        this.mResults = data;
    }

    @Override
    public void print(Printer printer) {
        TopMemoryOffendersAnalyzerTask task = new TopMemoryOffendersAnalyzerTask();
        printer.addHeading(2, task.getTaskName() + " Report");
        printer.addParagraph(task.getTaskDescription());
        if (this.mResults == null || this.mResults.isEmpty()) {
            printer.addParagraph("Top offenders not found.");
            return;
        }
        printer.startTable("Total Retained Size", "Instance");
        for (AnalysisResultEntry<?> entry : this.mResults) {
            if (entry.getOffender().getOffenders().isEmpty()) continue;
            Instance instance = (Instance)entry.getOffender().getOffenders().get(0);
            String totalRetainedSize = Long.toString(instance.getTotalRetainedSize());
            String instanceString = printer.formatInstance(instance);
            printer.addRow(totalRetainedSize, instanceString);
        }
        printer.endTable();
    }
}

