/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationMethod;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastSpecialExpressionKind;
import org.jetbrains.uast.UastUtils;

final class AnnotationContext {
    private static final AnnotationContext EMPTY = new AnnotationContext(null, null);
    @Nullable
    private final PsiModifierListOwner myOwner;
    @Nullable
    private final PsiType myType;
    @Nullable
    private final Supplier<Stream<PsiModifierListOwner>> myNext;

    private AnnotationContext(@Nullable PsiModifierListOwner owner, @Nullable PsiType type) {
        this(owner, type, null);
    }

    private AnnotationContext(@Nullable PsiModifierListOwner owner, @Nullable PsiType type, @Nullable Supplier<Stream<PsiModifierListOwner>> next) {
        this.myOwner = owner;
        this.myType = type;
        this.myNext = next;
    }

    AnnotationContext withType(PsiType type) {
        return new AnnotationContext(this.myOwner, type, this.myNext);
    }

    @Nullable
    public PsiModifierListOwner getOwner() {
        return this.myOwner;
    }

    @NotNull
    public Stream<PsiModifierListOwner> secondaryItems() {
        Stream<PsiModifierListOwner> stream = this.myNext == null ? Stream.empty() : this.myNext.get();
        if (stream == null) {
            AnnotationContext.$$$reportNull$$$0(0);
        }
        return stream;
    }

    @NotNull
    public Stream<PsiAnnotationOwner> allItems() {
        AbstractStreamEx abstractStreamEx = ((StreamEx)StreamEx.ofNullable((Object)this.myType).append((Stream)StreamEx.ofNullable(this.myOwner == null ? null : this.myOwner.getModifierList()))).append(this.secondaryItems().map(PsiModifierListOwner::getModifierList));
        if (abstractStreamEx == null) {
            AnnotationContext.$$$reportNull$$$0(1);
        }
        return abstractStreamEx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationContext context = (AnnotationContext)o;
        return Objects.equals(this.myOwner, context.myOwner) && Objects.equals(this.myType, context.myType);
    }

    public int hashCode() {
        return Objects.hash(this.myOwner, this.myType);
    }

    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    @NotNull
    static AnnotationContext fromModifierListOwner(@Nullable PsiModifierListOwner owner) {
        int index;
        PsiParameter parameter;
        PsiMethod method;
        if (owner instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)owner;
            return new AnnotationContext(owner, method2.getReturnType(), () -> {
                HashSet visited = new HashSet();
                return StreamEx.ofNullable((Object)AnnotationContext.getKotlinProperty(owner)).append((Stream)StreamEx.ofTree((Object)method2, m -> StreamEx.of((Object[])m.findSuperMethods()).filter(visited::add)).skip(1L));
            });
        }
        if (owner instanceof PsiParameter && (method = (PsiMethod)ObjectUtils.tryCast((Object)(parameter = (PsiParameter)owner).getDeclarationScope(), PsiMethod.class)) != null && (index = method.getParameterList().getParameterIndex(parameter)) >= 0) {
            Supplier<Stream<PsiModifierListOwner>> supplier = () -> {
                HashSet visited = new HashSet();
                return ((StreamEx)StreamEx.ofTree((Object)method, m -> StreamEx.of((Object[])m.findSuperMethods()).filter(visited::add)).skip(1L)).map(m -> m.getParameterList().getParameter(index)).select(PsiModifierListOwner.class);
            };
            return new AnnotationContext(owner, ((PsiVariable)owner).getType(), supplier);
        }
        if (owner instanceof PsiVariable) {
            return new AnnotationContext(owner, ((PsiVariable)owner).getType());
        }
        AnnotationContext annotationContext = EMPTY;
        if (annotationContext == null) {
            AnnotationContext.$$$reportNull$$$0(2);
        }
        return annotationContext;
    }

    @NotNull
    static AnnotationContext fromExpression(@NotNull UExpression expression) {
        AnnotationContext context;
        if (expression == null) {
            AnnotationContext.$$$reportNull$$$0(3);
        }
        if ((context = AnnotationContext.fromMethodReturn(expression)) != EMPTY) {
            AnnotationContext annotationContext = context;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(4);
            }
            return annotationContext;
        }
        context = AnnotationContext.fromArgument(expression);
        if (context != EMPTY) {
            AnnotationContext annotationContext = context;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(5);
            }
            return annotationContext;
        }
        return AnnotationContext.fromInitializer(expression);
    }

    @NotNull
    private static AnnotationContext fromMethodReturn(@NotNull UExpression expression) {
        PsiMethod method;
        UAnnotation anno;
        if (expression == null) {
            AnnotationContext.$$$reportNull$$$0(6);
        }
        PsiType returnType = null;
        PsiParameter next = null;
        UElement parent = expression.getUastParent();
        if (parent instanceof UCallExpression && (anno = (UAnnotation)UastContextKt.toUElement((PsiElement)parent.getSourcePsi(), UAnnotation.class)) != null) {
            parent = anno;
        }
        if (parent instanceof UAnnotationMethod) {
            UExpression defaultValue = ((UAnnotationMethod)parent).getUastDefaultValue();
            if (defaultValue == null || !AnnotationContext.expressionsAreEquivalent(defaultValue, expression)) {
                AnnotationContext annotationContext = EMPTY;
                if (annotationContext == null) {
                    AnnotationContext.$$$reportNull$$$0(7);
                }
                return annotationContext;
            }
            method = ((UAnnotationMethod)parent).getPsi();
        } else if (parent instanceof UNamedExpression) {
            method = UastUtils.getAnnotationMethod((UNamedExpression)((UNamedExpression)parent));
        } else if (parent instanceof UAnnotation) {
            PsiClass psiClass = ((UAnnotation)parent).resolve();
            if (psiClass == null || !psiClass.isAnnotationType()) {
                AnnotationContext annotationContext = EMPTY;
                if (annotationContext == null) {
                    AnnotationContext.$$$reportNull$$$0(8);
                }
                return annotationContext;
            }
            method = (PsiMethod)ArrayUtil.getFirstElement((Object[])psiClass.findMethodsByName("value", false));
        } else {
            UElement jumpTarget = null;
            if (parent instanceof UReturnExpression) {
                jumpTarget = ((UReturnExpression)parent).getJumpTarget();
            } else if (parent instanceof ULambdaExpression && expression instanceof UBlockExpression) {
                jumpTarget = parent;
            }
            if (jumpTarget instanceof UMethod) {
                method = ((UMethod)jumpTarget).getJavaPsi();
            } else if (jumpTarget instanceof ULambdaExpression) {
                next = AnnotationContext.getFunctionalParameter((ULambdaExpression)jumpTarget);
                PsiType type = ((ULambdaExpression)jumpTarget).getFunctionalInterfaceType();
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type);
                if (type == null) {
                    return AnnotationContext.fromModifierListOwner((PsiModifierListOwner)next);
                }
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
            } else {
                AnnotationContext annotationContext = EMPTY;
                if (annotationContext == null) {
                    AnnotationContext.$$$reportNull$$$0(9);
                }
                return annotationContext;
            }
        }
        if (method == null) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(10);
            }
            return annotationContext;
        }
        AnnotationContext result = AnnotationContext.fromModifierListOwner((PsiModifierListOwner)method).withType(returnType);
        if (next != null) {
            PsiParameter finalNext = next;
            return new AnnotationContext(result.myOwner, result.myType, () -> AnnotationContext.lambda$fromMethodReturn$5((PsiModifierListOwner)finalNext, result));
        }
        AnnotationContext annotationContext = result;
        if (annotationContext == null) {
            AnnotationContext.$$$reportNull$$$0(11);
        }
        return annotationContext;
    }

    @Nullable
    private static PsiModifierListOwner getKotlinProperty(@NotNull PsiModifierListOwner owner) {
        PsiElement javaPsi;
        if (owner == null) {
            AnnotationContext.$$$reportNull$$$0(12);
        }
        if (!(owner instanceof PsiMethod)) {
            return null;
        }
        if (!owner.getClass().getSimpleName().equals("KtUltraLightMethodForSourceDeclaration")) {
            return null;
        }
        UElement element = UastContextKt.toUElement((PsiElement)owner.getNavigationElement());
        if (element instanceof UField && (javaPsi = element.getJavaPsi()) instanceof PsiField) {
            return (PsiField)javaPsi;
        }
        return null;
    }

    @Nullable
    private static PsiParameter getFunctionalParameter(ULambdaExpression function) {
        PsiMethod calledMethod;
        UCallExpression call = (UCallExpression)ObjectUtils.tryCast((Object)function.getUastParent(), UCallExpression.class);
        if (call != null && (calledMethod = call.resolve()) != null) {
            return AnnotationContext.getParameter(calledMethod, call, (UExpression)function);
        }
        return null;
    }

    @NotNull
    private static AnnotationContext fromArgument(@NotNull UExpression expression) {
        UElement parent;
        UCallExpression callExpression;
        if (expression == null) {
            AnnotationContext.$$$reportNull$$$0(13);
        }
        if ((callExpression = UastUtils.getUCallExpression((UElement)(parent = expression.getUastParent()), (int)1)) == null) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(14);
            }
            return annotationContext;
        }
        PsiMethod method = callExpression.resolve();
        if (method == null) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(15);
            }
            return annotationContext;
        }
        PsiParameter parameter = AnnotationContext.getParameter(method, callExpression, expression);
        if (parameter == null) {
            AnnotationContext annotationContext = EMPTY;
            if (annotationContext == null) {
                AnnotationContext.$$$reportNull$$$0(16);
            }
            return annotationContext;
        }
        PsiType parameterType = parameter.getType();
        PsiElement psi = callExpression.getSourcePsi();
        if (psi instanceof PsiMethodCallExpression) {
            PsiSubstitutor substitutor = ((PsiMethodCallExpression)psi).getMethodExpression().advancedResolve(false).getSubstitutor();
            parameterType = substitutor.substitute(parameterType);
        }
        AnnotationContext annotationContext = AnnotationContext.fromModifierListOwner((PsiModifierListOwner)parameter).withType(parameterType);
        if (annotationContext == null) {
            AnnotationContext.$$$reportNull$$$0(17);
        }
        return annotationContext;
    }

    @NotNull
    private static AnnotationContext fromInitializer(UExpression expression) {
        UExpression selector;
        USwitchExpression switchExpression;
        UElement parent = expression.getUastParent();
        PsiModifierListOwner var = null;
        if (parent instanceof UVariable) {
            var = (PsiModifierListOwner)ObjectUtils.tryCast((Object)parent.getJavaPsi(), PsiModifierListOwner.class);
        } else if (parent instanceof UBinaryExpression) {
            UBinaryExpression binOp = (UBinaryExpression)parent;
            UastBinaryOperator operator = binOp.getOperator();
            UExpression rightOperand = binOp.getRightOperand();
            if ((operator == UastBinaryOperator.ASSIGN || operator == UastBinaryOperator.PLUS_ASSIGN) && AnnotationContext.expressionsAreEquivalent(expression, rightOperand)) {
                PsiParameter[] parameters;
                UExpression leftOperand = UastUtils.skipParenthesizedExprDown((UExpression)binOp.getLeftOperand());
                UReferenceExpression lValue = (UReferenceExpression)ObjectUtils.tryCast((Object)leftOperand, UReferenceExpression.class);
                if (lValue instanceof UQualifiedReferenceExpression) {
                    lValue = (UReferenceExpression)ObjectUtils.tryCast((Object)((UQualifiedReferenceExpression)lValue).getSelector(), UReferenceExpression.class);
                }
                if (lValue != null) {
                    var = (PsiModifierListOwner)ObjectUtils.tryCast((Object)lValue.resolve(), PsiModifierListOwner.class);
                } else {
                    while (leftOperand instanceof UArrayAccessExpression) {
                        leftOperand = ((UArrayAccessExpression)leftOperand).getReceiver();
                    }
                    if (leftOperand instanceof UResolvable) {
                        var = (PsiModifierListOwner)ObjectUtils.tryCast((Object)((UResolvable)leftOperand).resolve(), PsiModifierListOwner.class);
                    }
                }
                if (var != null && var.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && var instanceof PsiMethod && PsiType.VOID.equals((Object)((PsiMethod)var).getReturnType()) && (parameters = ((PsiMethod)var).getParameterList().getParameters()).length == 1) {
                    var = parameters[0];
                }
            }
        } else if (parent instanceof USwitchClauseExpression && ((USwitchClauseExpression)parent).getCaseValues().contains(AnnotationContext.normalize(expression)) && (switchExpression = (USwitchExpression)UastUtils.getParentOfType((UElement)parent, USwitchExpression.class)) != null && (selector = switchExpression.getExpression()) instanceof UResolvable) {
            var = (PsiModifierListOwner)ObjectUtils.tryCast((Object)((UResolvable)selector).resolve(), PsiModifierListOwner.class);
        }
        return AnnotationContext.fromModifierListOwner(var);
    }

    static boolean expressionsAreEquivalent(@NotNull UExpression expr1, @NotNull UExpression expr2) {
        if (expr1 == null) {
            AnnotationContext.$$$reportNull$$$0(18);
        }
        if (expr2 == null) {
            AnnotationContext.$$$reportNull$$$0(19);
        }
        return AnnotationContext.normalize(expr1).equals(AnnotationContext.normalize(expr2));
    }

    @NotNull
    static UExpression normalize(@NotNull UExpression expression) {
        List operands;
        if (expression == null) {
            AnnotationContext.$$$reportNull$$$0(20);
        }
        if (expression instanceof UPolyadicExpression && ((UPolyadicExpression)expression).getOperator() == UastBinaryOperator.PLUS && (operands = ((UPolyadicExpression)expression).getOperands()).size() == 1) {
            UExpression uExpression = (UExpression)operands.get(0);
            if (uExpression == null) {
                AnnotationContext.$$$reportNull$$$0(21);
            }
            return uExpression;
        }
        UExpression uExpression = expression;
        if (uExpression == null) {
            AnnotationContext.$$$reportNull$$$0(22);
        }
        return uExpression;
    }

    @Nullable
    static PsiParameter getParameter(PsiMethod method, UCallExpression call, UExpression arg) {
        UElement parent;
        PsiParameter[] params = method.getParameterList().getParameters();
        while (!call.equals(parent = arg.getUastParent())) {
            if (!(parent instanceof UExpression)) {
                return null;
            }
            arg = (UExpression)parent;
        }
        arg = AnnotationContext.normalize(arg);
        for (int i = 0; i < params.length; ++i) {
            UExpression argument = call.getArgumentForParameter(i);
            if (!arg.equals(argument) && (!(argument instanceof UExpressionList) || ((UExpressionList)argument).getKind() != UastSpecialExpressionKind.VARARGS || !((UExpressionList)argument).getExpressions().contains(arg))) continue;
            return params[i];
        }
        return null;
    }

    private static /* synthetic */ Stream lambda$fromMethodReturn$5(PsiModifierListOwner finalNext, AnnotationContext result) {
        return StreamEx.of((Object)finalNext).append(result.secondaryItems());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/AnnotationContext";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr1";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "secondaryItems";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "allItems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromModifierListOwner";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/AnnotationContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromExpression";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethodReturn";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "fromArgument";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromMethodReturn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getKotlinProperty";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fromArgument";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "expressionsAreEquivalent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

