/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.accessor;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.NettyKt;
import java.awt.Component;
import java.awt.Point;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.swing.JFrame;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.references.MarkdownAnchorReference;
import org.intellij.plugins.markdown.ui.preview.MarkdownSplitEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SafeLinkOpener {
    private static final Logger LOG = Logger.getInstance(SafeLinkOpener.class);
    private static final Set<String> SCHEMES = Set.of("http", "https");
    private static final Set<String> SAFE_LOCAL_EXTENSIONS = Set.of("md", "png", "gif", "jpg", "jpeg", "bmp", "svg", "html");

    private SafeLinkOpener() {
    }

    static void openLink(@NotNull String link) {
        URI uri;
        if (link == null) {
            SafeLinkOpener.$$$reportNull$$$0(0);
        }
        try {
            uri = !BrowserUtil.isAbsoluteURL((String)link) ? new URI("http://" + link) : new URI(link);
        }
        catch (URISyntaxException e) {
            LOG.info((Throwable)e);
            return;
        }
        if (SafeLinkOpener.tryOpenInEditor(uri)) {
            return;
        }
        if (!SafeLinkOpener.isHttpScheme(uri.getScheme()) || SafeLinkOpener.isLocalHost(uri.getHost()) && !SafeLinkOpener.isSafeExtension(uri.getPath())) {
            LOG.warn("Bad URL", (Throwable)new InaccessibleURLOpenedException(link));
            return;
        }
        BrowserUtil.browse((URI)uri);
    }

    private static boolean tryOpenInEditor(@NotNull URI uri) {
        if (uri == null) {
            SafeLinkOpener.$$$reportNull$$$0(1);
        }
        if (!"file".equals(uri.getScheme())) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            String anchor = uri.getFragment();
            String path = uri.getPath();
            VirtualFile targetFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (targetFile == null) {
                return false;
            }
            Project project = ProjectUtil.guessProjectForContentFile((VirtualFile)targetFile);
            if (project == null) {
                return false;
            }
            if (anchor == null) {
                ApplicationManager.getApplication().invokeLater(() -> OpenFileAction.openFile((VirtualFile)targetFile, (Project)project));
                return true;
            }
            JFrame frame = WindowManager.getInstance().getFrame(project);
            Point mousePosition = Objects.requireNonNull(frame).getMousePosition();
            if (mousePosition == null) {
                return false;
            }
            RelativePoint point = new RelativePoint((Component)frame, mousePosition);
            ApplicationManager.getApplication().invokeLater(() -> {
                Collection headers = (Collection)ReadAction.compute(() -> MarkdownAnchorReference.Companion.getPsiHeaders(project, anchor, PsiManager.getInstance((Project)project).findFile(targetFile)));
                if (headers.isEmpty()) {
                    SafeLinkOpener.showCannotNavigateNotification(project, anchor, point);
                } else if (headers.size() == 1) {
                    SafeLinkOpener.navigateToHeader(targetFile, Objects.requireNonNull((PsiElement)ContainerUtil.getFirstItem((Collection)headers)));
                } else {
                    SafeLinkOpener.showHeadersPopup(headers, point);
                }
            });
            return true;
        });
    }

    private static void showCannotNavigateNotification(@NotNull Project project, @NotNull String anchor, @NotNull RelativePoint point) {
        if (project == null) {
            SafeLinkOpener.$$$reportNull$$$0(2);
        }
        if (anchor == null) {
            SafeLinkOpener.$$$reportNull$$$0(3);
        }
        if (point == null) {
            SafeLinkOpener.$$$reportNull$$$0(4);
        }
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(MarkdownBundle.message("markdown.navigate.to.header.no.headers", anchor), MessageType.WARNING, null);
        Balloon balloon = balloonBuilder.createBalloon();
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)project, (Disposable)balloon);
    }

    private static void navigateToHeader(@NotNull VirtualFile targetFile, @NotNull PsiElement item) {
        FileEditor editor;
        if (targetFile == null) {
            SafeLinkOpener.$$$reportNull$$$0(5);
        }
        if (item == null) {
            SafeLinkOpener.$$$reportNull$$$0(6);
        }
        if ((editor = FileEditorManager.getInstance((Project)item.getProject()).getSelectedEditor(targetFile)) == null) {
            return;
        }
        MarkdownSplitEditor splitEditor = (MarkdownSplitEditor)editor;
        boolean oldAutoScrollPreview = splitEditor.isAutoScrollPreview();
        if (!oldAutoScrollPreview) {
            splitEditor.setAutoScrollPreview(true);
        }
        PsiNavigateUtil.navigate((PsiElement)item);
        if (!oldAutoScrollPreview) {
            splitEditor.setAutoScrollPreview(false);
        }
    }

    private static void showHeadersPopup(@NotNull Collection<PsiElement> headers, @NotNull RelativePoint point) {
        if (headers == null) {
            SafeLinkOpener.$$$reportNull$$$0(7);
        }
        if (point == null) {
            SafeLinkOpener.$$$reportNull$$$0(8);
        }
        BaseListPopupStep<PsiElement> headersPopup = new BaseListPopupStep<PsiElement>(MarkdownBundle.message("markdown.navigate.to.header", new Object[0]), new ArrayList<PsiElement>(headers)){

            @NotNull
            public String getTextFor(PsiElement value) {
                Document document = FileDocumentManager.getInstance().getDocument(value.getContainingFile().getVirtualFile());
                String name = value.getContainingFile().getVirtualFile().getName();
                String string = value.getText() + " (" + name + ":" + (Objects.requireNonNull(document).getLineNumber(value.getTextOffset()) + 1) + ")";
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(PsiElement selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> SafeLinkOpener.navigateToHeader(selectedValue.getContainingFile().getVirtualFile(), selectedValue));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/accessor/SafeLinkOpener$1", "getTextFor"));
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)headersPopup).show(point);
    }

    private static boolean isHttpScheme(@Nullable String scheme) {
        return scheme != null && SCHEMES.contains(StringUtil.toLowerCase((String)scheme));
    }

    private static boolean isLocalHost(@Nullable String hostName) {
        return hostName == null || hostName.startsWith("127.") || hostName.endsWith(":1") || NettyKt.isLocalHost((String)hostName, (boolean)false, (boolean)false);
    }

    public static boolean isSafeExtension(@Nullable String path) {
        if (path == null) {
            return false;
        }
        int i = path.lastIndexOf(46);
        return i != -1 && SAFE_LOCAL_EXTENSIONS.contains(StringUtil.toLowerCase((String)path.substring(i + 1)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/accessor/SafeLinkOpener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openLink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "tryOpenInEditor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showCannotNavigateNotification";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToHeader";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showHeadersPopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InaccessibleURLOpenedException
    extends IllegalArgumentException {
        InaccessibleURLOpenedException(String link) {
            super(link);
        }
    }
}

