/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPackagingStateStorage;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public final class AndroidManifestMergerStateStorage
implements StorageOwner {
    private static final Logger LOG = Logger.getInstance(AndroidPackagingStateStorage.class);
    public static final StorageProvider<AndroidManifestMergerStateStorage> PROVIDER = new StorageProvider<AndroidManifestMergerStateStorage>(){

        @NotNull
        public AndroidManifestMergerStateStorage createStorage(File targetDataDir) {
            return new AndroidManifestMergerStateStorage(AndroidJpsUtil.getStorageFile(targetDataDir, "manifest_merger"));
        }
    };
    private final File myFile;

    private AndroidManifestMergerStateStorage(@NotNull File file) {
        if (file == null) {
            AndroidManifestMergerStateStorage.$$$reportNull$$$0(0);
        }
        this.myFile = file;
    }

    public void flush(boolean memoryCachesOnly) {
    }

    public void clean() {
        FileUtil.delete((File)this.myFile);
    }

    public void close() {
    }

    @Nullable
    public MyState read() {
        block6: {
            MyState myState;
            DataInputStream input2 = new DataInputStream(new FileInputStream(this.myFile));
            try {
                myState = new MyState(input2);
            }
            catch (Throwable throwable) {
                try {
                    input2.close();
                    throw throwable;
                }
                catch (FileNotFoundException input2) {
                    break block6;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            input2.close();
            return myState;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(@NotNull MyState state) {
        if (state == null) {
            AndroidManifestMergerStateStorage.$$$reportNull$$$0(1);
        }
        FileUtil.createParentDirs((File)this.myFile);
        try (DataOutputStream output = new DataOutputStream(new FileOutputStream(this.myFile));){
            output.writeLong(state.myManifestFileTimestamp);
            output.writeInt(state.myLibManifestsTimestamps.size());
            for (Object key : state.myLibManifestsTimestamps.keySet()) {
                String strKey = (String)key;
                output.writeUTF(strKey);
                output.writeLong(state.myLibManifestsTimestamps.getLong((Object)strKey));
            }
            output.writeBoolean(state.myToMerge);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/android/AndroidManifestMergerStateStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "saveState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyState {
        private final long myManifestFileTimestamp;
        private final Object2LongMap<String> myLibManifestsTimestamps;
        private final boolean myToMerge;

        public MyState(@NotNull File manifestFile, @NotNull Collection<File> libManifestFiles, boolean toMerge) {
            if (manifestFile == null) {
                MyState.$$$reportNull$$$0(0);
            }
            if (libManifestFiles == null) {
                MyState.$$$reportNull$$$0(1);
            }
            this.myManifestFileTimestamp = FSOperations.lastModified((File)manifestFile);
            this.myLibManifestsTimestamps = new Object2LongOpenHashMap(libManifestFiles.size());
            for (File libManifestFile : libManifestFiles) {
                this.myLibManifestsTimestamps.put((Object)FileUtil.toCanonicalPath((String)libManifestFile.getPath()), FSOperations.lastModified((File)libManifestFile));
            }
            this.myToMerge = toMerge;
        }

        private MyState(DataInput input) throws IOException {
            this.myManifestFileTimestamp = input.readLong();
            int libManifestsCount = input.readInt();
            this.myLibManifestsTimestamps = new Object2LongOpenHashMap(libManifestsCount);
            for (int i = 0; i < libManifestsCount; ++i) {
                String path = input.readUTF();
                long timestamp = input.readLong();
                this.myLibManifestsTimestamps.put((Object)path, timestamp);
            }
            this.myToMerge = input.readBoolean();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyState state = (MyState)o;
            if (this.myManifestFileTimestamp != state.myManifestFileTimestamp) {
                return false;
            }
            if (this.myToMerge != state.myToMerge) {
                return false;
            }
            return this.myLibManifestsTimestamps.equals(state.myLibManifestsTimestamps);
        }

        public int hashCode() {
            int result = (int)(this.myManifestFileTimestamp ^ this.myManifestFileTimestamp >>> 32);
            result = 31 * result + this.myLibManifestsTimestamps.hashCode();
            result = 31 * result + (this.myToMerge ? 1 : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "manifestFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "libManifestFiles";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/android/AndroidManifestMergerStateStorage$MyState";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

