/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidDexBuilder;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidPreDexBuildTarget;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidPreDexBuilder
extends AndroidTargetBuilder<AndroidPreDexBuildTarget.MyRootDescriptor, AndroidPreDexBuildTarget> {
    @NonNls
    private static final String BUILDER_NAME = "Android Pre Dex";

    protected AndroidPreDexBuilder() {
        super(Collections.singletonList(AndroidPreDexBuildTarget.MyTargetType.INSTANCE));
    }

    @Nullable
    public static String getOutputFileNameForExternalJar(@NotNull File srcFile) {
        String canonicalPath;
        if (srcFile == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(0);
        }
        if ((canonicalPath = FileUtil.toCanonicalPath((String)srcFile.getAbsolutePath())) == null) {
            return null;
        }
        if (AndroidBuildTestingManager.getTestingManager() != null) {
            return srcFile.getName();
        }
        int hashCode = canonicalPath.hashCode();
        return FileUtil.getNameWithoutExtension((File)srcFile) + "-" + Integer.toHexString(hashCode) + ".jar";
    }

    @Override
    protected void buildTarget(@NotNull AndroidPreDexBuildTarget target, @NotNull DirtyFilesHolder<AndroidPreDexBuildTarget.MyRootDescriptor, AndroidPreDexBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(2);
        }
        if (outputConsumer == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(3);
        }
        if (context == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(4);
        }
        if (!AndroidPreDexBuilder.doBuild(target, holder, outputConsumer, context)) {
            throw new StopBuildException();
        }
    }

    private static boolean doBuild(@NotNull AndroidPreDexBuildTarget target, @NotNull DirtyFilesHolder<AndroidPreDexBuildTarget.MyRootDescriptor, AndroidPreDexBuildTarget> holder, @NotNull BuildOutputConsumer outputConsumer, @NotNull CompileContext context) throws IOException, ProjectBuildException {
        if (target == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(6);
        }
        if (outputConsumer == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(7);
        }
        if (context == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(8);
        }
        final ArrayList filesToPreDex = new ArrayList();
        holder.processDirtyFiles((FileProcessor)new FileProcessor<AndroidPreDexBuildTarget.MyRootDescriptor, AndroidPreDexBuildTarget>(){

            public boolean apply(AndroidPreDexBuildTarget target, File file, AndroidPreDexBuildTarget.MyRootDescriptor root) throws IOException {
                if (AndroidPreDexBuilder.canBePreDexed(file) && file.isFile()) {
                    filesToPreDex.add(Pair.create((Object)file, (Object)root.getModuleName()));
                }
                return true;
            }
        });
        JpsProject project = target.getProject();
        AndroidPlatform platform = null;
        for (JpsModule module : project.getModules()) {
            if (AndroidJpsUtil.getExtension(module) == null) continue;
            platform = AndroidJpsUtil.getAndroidPlatform(module, context, BUILDER_NAME);
            break;
        }
        if (platform == null) {
            return false;
        }
        if (!filesToPreDex.isEmpty()) {
            File outputDir = target.getOutputFile(context);
            for (Pair pair : filesToPreDex) {
                File outputFile;
                context.checkCanceled();
                File srcFile = (File)pair.getFirst();
                String moduleName = (String)pair.getSecond();
                String srcFilePath = srcFile.getAbsolutePath();
                if (moduleName != null) {
                    context.processMessage((BuildMessage)new ProgressMessage("Pre-dex [" + moduleName + "]"));
                    outputFile = new File(new File(outputDir, moduleName), srcFile.getName());
                } else {
                    context.processMessage((BuildMessage)new ProgressMessage("Pre-dex: " + srcFile.getName()));
                    String outputFileName = AndroidPreDexBuilder.getOutputFileNameForExternalJar(srcFile);
                    if (outputFileName == null) {
                        context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, "Cannot pre-dex file " + srcFilePath + ": incorrect path", srcFilePath));
                        return false;
                    }
                    outputFile = new File(outputDir, outputFileName);
                }
                if (AndroidJpsUtil.createDirIfNotExist(outputFile.getParentFile(), context, BUILDER_NAME) == null) {
                    return false;
                }
                if (AndroidDexBuilder.runDex(platform, outputFile.getPath(), new String[]{srcFilePath}, context, project, outputConsumer, BUILDER_NAME, srcFile.getName(), null)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canBePreDexed(@NotNull File file) {
        if (file == null) {
            AndroidPreDexBuilder.$$$reportNull$$$0(9);
        }
        return "jar".equals(FileUtilRt.getExtension((String)file.getName()));
    }

    @NotNull
    public String getPresentableName() {
        return BUILDER_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputConsumer";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/android/AndroidPreDexBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOutputFileNameForExternalJar";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTarget";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doBuild";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canBePreDexed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

