/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.openapi.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidAarDepsBuildTarget
extends AndroidBuildTarget {
    public AndroidAarDepsBuildTarget(JpsModule module) {
        super(MyTargetType.INSTANCE, module);
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        Set libraries = JpsJavaExtensionService.getInstance().enumerateDependencies(Collections.singleton(this.myModule)).runtimeOnly().productionOnly().getLibraries();
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (JpsLibrary library : libraries) {
            Pair<File, List<File>> pair = AndroidJpsUtil.getResDirAndJarsIfAar(library);
            List jars = pair != null ? (List)pair.getSecond() : null;
            if (jars == null) continue;
            for (File jar : jars) {
                result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, jar));
            }
        }
        ArrayList<BuildRootDescriptor> arrayList = result;
        if (arrayList == null) {
            AndroidAarDepsBuildTarget.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        Set<File> set = Collections.singleton(this.getOutputFile(context));
        if (set == null) {
            AndroidAarDepsBuildTarget.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        File file = this.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths());
        if (file == null) {
            AndroidAarDepsBuildTarget.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public File getOutputFile(BuildDataPaths dataPaths) {
        JpsModule module = this.myModule;
        return AndroidAarDepsBuildTarget.getOutputFile(module, dataPaths);
    }

    @NotNull
    public static File getOutputFile(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidAarDepsBuildTarget.$$$reportNull$$$0(3);
        }
        if (dataPaths == null) {
            AndroidAarDepsBuildTarget.$$$reportNull$$$0(4);
        }
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        return new File(dir, "aar_deps.jar");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeRootDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidAarDepsBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        MyTargetType() {
            super("android-aar-deps", "AAR Dependencies Packaging");
        }

        @Override
        @Nullable
        public AndroidAarDepsBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            if (extension == null) {
                MyTargetType.$$$reportNull$$$0(0);
            }
            return !extension.isLibrary() ? new AndroidAarDepsBuildTarget(extension.getModule()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/builder/AndroidAarDepsBuildTarget$MyTargetType", "createBuildTarget"));
        }
    }
}

