/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidResourceCachingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidResourcePackagingBuildTarget
extends AndroidBuildTarget {
    public AndroidResourcePackagingBuildTarget(@NotNull JpsModule module) {
        if (module == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(0);
        }
        super(MyTargetType.INSTANCE, module);
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        if (extension.isUseCustomManifestPackage()) {
            out.println(extension.getCustomManifestPackage());
        }
        out.println(extension.getAdditionalPackagingCommandLineParameters());
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        String[] resourceDirs = AndroidJpsUtil.collectResourceDirsForCompilation(extension, true, dataPaths, false);
        ArrayList<String> assertDirs = new ArrayList<String>();
        AndroidResourcePackagingBuildTarget.collectAssetDirs(extension, assertDirs, false);
        File manifestFile = AndroidJpsUtil.getPreprocessedManifestFile(extension, dataPaths);
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        for (String resourceDir : resourceDirs) {
            result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(resourceDir)));
        }
        for (String assetDir : assertDirs) {
            result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(assetDir)));
        }
        if (manifestFile != null) {
            result.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, manifestFile));
        }
        ArrayList<BuildRootDescriptor> arrayList = result;
        if (arrayList == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputFile(context));
        if (list == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public File getOutputFile(@NotNull CompileContext context) {
        if (context == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(3);
        }
        return AndroidResourcePackagingBuildTarget.getOutputFile(context.getProjectDescriptor().dataManager.getDataPaths(), this.myModule);
    }

    @NotNull
    public static File getOutputFile(@NotNull BuildDataPaths dataPaths, @NotNull JpsModule module) {
        if (dataPaths == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(4);
        }
        if (module == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(5);
        }
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths, module);
        return new File(dir.getPath(), module.getName() + ".apk.res");
    }

    public static void collectAssetDirs(@NotNull JpsAndroidModuleExtension extension, @NotNull List<String> result, boolean checkExistence) {
        File assetsDir;
        if (extension == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(6);
        }
        if (result == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(7);
        }
        if ((assetsDir = extension.getAssetsDir()) != null && (!checkExistence || assetsDir.exists())) {
            result.add(assetsDir.getPath());
        }
        if (extension.isIncludeAssetsFromLibraries()) {
            for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(extension.getModule(), true)) {
                File depAssetsDir = depExtension.getAssetsDir();
                if (depAssetsDir == null || checkExistence && !depAssetsDir.exists()) continue;
                result.add(depAssetsDir.getPath());
            }
            AndroidResourcePackagingBuildTarget.collectAssetDirsFromAarDeps(extension.getModule(), result);
        }
    }

    private static void collectAssetDirsFromAarDeps(@NotNull JpsModule module, @NotNull Collection<String> result) {
        if (module == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(8);
        }
        if (result == null) {
            AndroidResourcePackagingBuildTarget.$$$reportNull$$$0(9);
        }
        ArrayList<String> resDirsFromAarDeps = new ArrayList<String>();
        AndroidJpsUtil.collectResDirectoriesFromAarDeps(module, resDirsFromAarDeps);
        if (resDirsFromAarDeps.isEmpty()) {
            return;
        }
        for (String path : resDirsFromAarDeps) {
            File assetsSibling = new File(new File(path).getParentFile(), "assets");
            if (!assetsSibling.isDirectory()) continue;
            result.add(assetsSibling.getPath());
        }
    }

    @Override
    protected void fillDependencies(List<BuildTarget<?>> result) {
        super.fillDependencies(result);
        result.add(new AndroidResourceCachingBuildTarget(this.myModule));
        for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(this.myModule, true)) {
            result.add(new AndroidResourceCachingBuildTarget(depExtension.getModule()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeRootDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAssetDirs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectAssetDirsFromAarDeps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MyTargetType
    extends AndroidBuildTargetType<AndroidResourcePackagingBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-resource-packaging", "Resource Packaging");
        }

        @Override
        public AndroidResourcePackagingBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            if (extension == null) {
                MyTargetType.$$$reportNull$$$0(0);
            }
            return !extension.isLibrary() ? new AndroidResourcePackagingBuildTarget(extension.getModule()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/builder/AndroidResourcePackagingBuildTarget$MyTargetType", "createBuildTarget"));
        }
    }
}

