/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.android.model.JpsAndroidApplicationArtifactProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsAndroidApplicationArtifactPropertiesImpl
extends JpsElementBase<JpsAndroidApplicationArtifactPropertiesImpl>
implements JpsAndroidApplicationArtifactProperties {
    public static final JpsElementChildRole<JpsAndroidApplicationArtifactProperties> ROLE = JpsElementChildRoleBase.create((String)"android application artifact properties");
    private final MyState myState;

    public JpsAndroidApplicationArtifactPropertiesImpl() {
        this.myState = new MyState();
    }

    public JpsAndroidApplicationArtifactPropertiesImpl(@NotNull MyState state) {
        if (state == null) {
            JpsAndroidApplicationArtifactPropertiesImpl.$$$reportNull$$$0(0);
        }
        this.myState = new MyState();
        this.myState.SIGNING_MODE = state.SIGNING_MODE;
        this.myState.KEY_STORE_URL = state.KEY_STORE_URL;
        this.myState.KEY_STORE_PASSWORD = state.KEY_STORE_PASSWORD;
        this.myState.KEY_ALIAS = state.KEY_ALIAS;
        this.myState.KEY_PASSWORD = state.KEY_PASSWORD;
        this.myState.PROGUARD_CFG_FILES = state.PROGUARD_CFG_FILES;
        this.myState.RUN_PROGUARD = state.RUN_PROGUARD;
    }

    @NotNull
    public JpsAndroidApplicationArtifactPropertiesImpl createCopy() {
        return new JpsAndroidApplicationArtifactPropertiesImpl(this.myState);
    }

    public void applyChanges(@NotNull JpsAndroidApplicationArtifactPropertiesImpl modified) {
        if (modified == null) {
            JpsAndroidApplicationArtifactPropertiesImpl.$$$reportNull$$$0(1);
        }
        this.setSigningMode(modified.getSigningMode());
        this.setKeyStoreUrl(modified.getKeyStoreUrl());
        this.setKeyStorePassword(modified.getKeyStorePassword());
        this.setKeyAlias(modified.getKeyAlias());
        this.setKeyPassword(modified.getKeyPassword());
        this.setRunProGuard(modified.isRunProGuard());
        this.setProGuardCfgFiles(modified.getProGuardCfgFiles());
    }

    @NotNull
    public MyState getState() {
        MyState myState = this.myState;
        if (myState == null) {
            JpsAndroidApplicationArtifactPropertiesImpl.$$$reportNull$$$0(2);
        }
        return myState;
    }

    @Override
    public AndroidArtifactSigningMode getSigningMode() {
        return this.myState.SIGNING_MODE;
    }

    @Override
    public void setSigningMode(AndroidArtifactSigningMode mode) {
        if (!this.myState.SIGNING_MODE.equals((Object)mode)) {
            this.myState.SIGNING_MODE = mode;
            this.fireElementChanged();
        }
    }

    @Override
    public String getKeyStoreUrl() {
        return this.myState.KEY_STORE_URL;
    }

    @Override
    public void setKeyStoreUrl(String url) {
        if (!this.myState.KEY_STORE_URL.equals(url)) {
            this.myState.KEY_STORE_URL = url;
            this.fireElementChanged();
        }
    }

    @Override
    public String getKeyStorePassword() {
        return this.myState.KEY_STORE_PASSWORD;
    }

    @Override
    public void setKeyStorePassword(String password) {
        if (!this.myState.KEY_STORE_PASSWORD.equals(password)) {
            this.myState.KEY_STORE_PASSWORD = password;
            this.fireElementChanged();
        }
    }

    @Override
    public String getKeyAlias() {
        return this.myState.KEY_ALIAS;
    }

    @Override
    public void setKeyAlias(String alias) {
        if (!this.myState.KEY_ALIAS.equals(alias)) {
            this.myState.KEY_ALIAS = alias;
            this.fireElementChanged();
        }
    }

    @Override
    public String getKeyPassword() {
        return this.myState.KEY_PASSWORD;
    }

    @Override
    public void setKeyPassword(String password) {
        if (!this.myState.KEY_PASSWORD.equals(password)) {
            this.myState.KEY_PASSWORD = password;
            this.fireElementChanged();
        }
    }

    @Override
    public boolean isRunProGuard() {
        return this.myState.RUN_PROGUARD;
    }

    @Override
    public void setRunProGuard(boolean value) {
        if (this.myState.RUN_PROGUARD != value) {
            this.myState.RUN_PROGUARD = value;
            this.fireElementChanged();
        }
    }

    @Override
    public List<String> getProGuardCfgFiles() {
        return this.myState.PROGUARD_CFG_FILES;
    }

    @Override
    public List<String> getProGuardCfgFiles(@NotNull JpsModule module) {
        String sdkHomePath;
        List<String> urls;
        if (module == null) {
            JpsAndroidApplicationArtifactPropertiesImpl.$$$reportNull$$$0(3);
        }
        if ((urls = this.getProGuardCfgFiles()) == null || urls.isEmpty()) {
            return urls;
        }
        JpsSdk sdk = module.getSdk((JpsSdkType)JpsAndroidSdkType.INSTANCE);
        String string = sdkHomePath = sdk != null ? FileUtil.toSystemIndependentName((String)sdk.getHomePath()) : null;
        if (sdkHomePath == null || sdkHomePath.isEmpty()) {
            return urls;
        }
        ArrayList<String> result = new ArrayList<String>(urls.size());
        for (String url : urls) {
            result.add(StringUtil.replace((String)url, (String)"%MODULE_SDK_HOME%", (String)sdkHomePath));
        }
        return result;
    }

    @Override
    public void setProGuardCfgFiles(List<String> urls) {
        if (!this.myState.PROGUARD_CFG_FILES.equals(urls)) {
            this.myState.PROGUARD_CFG_FILES = urls;
            this.fireElementChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/model/impl/JpsAndroidApplicationArtifactPropertiesImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/model/impl/JpsAndroidApplicationArtifactPropertiesImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProGuardCfgFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyState {
        public AndroidArtifactSigningMode SIGNING_MODE = AndroidArtifactSigningMode.RELEASE_UNSIGNED;
        public String KEY_STORE_URL = "";
        public String KEY_STORE_PASSWORD = "";
        public String KEY_ALIAS = "";
        public String KEY_PASSWORD = "";
        public boolean RUN_PROGUARD;
        public List<String> PROGUARD_CFG_FILES = new ArrayList<String>();
    }
}

