/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googleMapsWearActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"mapActivityKt", "", "activityClass", "layoutName", "packageName", "useAndroidX", "", "studio.intellij.android.wizardTemplate.impl"})
public final class MapActivityKtKt {
    @NotNull
    public static final String mapActivityKt(@NotNull String activityClass2, @NotNull String layoutName2, @NotNull String packageName, boolean useAndroidX) {
        Intrinsics.checkParameterIsNotNull((Object)activityClass2, (String)"activityClass");
        Intrinsics.checkParameterIsNotNull((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier((String)packageName) + "\n\nimport com.google.android.gms.maps.CameraUpdateFactory\nimport com.google.android.gms.maps.GoogleMap\nimport com.google.android.gms.maps.MapFragment\nimport com.google.android.gms.maps.OnMapReadyCallback\nimport com.google.android.gms.maps.model.LatLng\nimport com.google.android.gms.maps.model.MarkerOptions\n\nimport android.os.Bundle\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.wear.widget.SwipeDismissFrameLayout", (boolean)useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.wearable.activity.WearableActivity", (boolean)useAndroidX) + "\nimport android.view.Gravity\nimport android.view.View\nimport android.widget.FrameLayout\nimport android.widget.Toast\n\nclass " + activityClass2 + " : WearableActivity(), OnMapReadyCallback {\n\n    /**\n     * Map is initialized when it\"s fully loaded and ready to be used.\n     * See [onMapReady]\n     */\n    private lateinit var mMap: GoogleMap\n    private lateinit var swipeDismissRootContainer: SwipeDismissFrameLayout\n\n    public override fun onCreate(savedState: Bundle?) {\n        super.onCreate(savedState)\n\n        // Enables always on.\n        setAmbientEnabled()\n\n        setContentView(R.layout." + layoutName2 + ")\n\n        // Enables the Swipe-To-Dismiss Gesture via the root layout (SwipeDismissFrameLayout).\n        // Swipe-To-Dismiss is a standard pattern in Wear for closing an app and needs to be\n        // manually enabled for any Google Maps Activity. For more information, review our docs:\n        // https://developer.android.com/training/wearables/ui/exit.html\n        swipeDismissRootContainer = findViewById(R.id.swipe_dismiss_root_container)\n        swipeDismissRootContainer.addCallback(object : SwipeDismissFrameLayout.Callback() {\n            override fun onDismissed(layout: SwipeDismissFrameLayout?) {\n                // Hides view before exit to avoid stutter.\n                layout?.visibility = View.GONE\n                finish()\n            }\n        })\n\n        // Adjusts margins to account for the system window insets when they become available.\n        swipeDismissRootContainer.setOnApplyWindowInsetsListener { _, insetsArg ->\n            val insets = swipeDismissRootContainer.onApplyWindowInsets(insetsArg)\n            val mapContainer = findViewById<FrameLayout>(R.id.map_container)\n            val params = mapContainer.layoutParams as FrameLayout.LayoutParams\n\n            // Add Wearable insets to FrameLayout container holding map as margins\n            params.setMargins(\n                    insets.systemWindowInsetLeft,\n                    insets.systemWindowInsetTop,\n                    insets.systemWindowInsetRight,\n                    insets.systemWindowInsetBottom)\n            mapContainer.layoutParams = params\n\n            insets\n        }\n\n        // Obtain the MapFragment and set the async listener to be notified when the map is ready.\n        @Suppress(\"Deprecation\")\n        // Suppressing deprecation since WearableActivity doesn't extend FragmentManager, thus\n        // getSupportFragmentManager can't be used\n        val mapFragment = fragmentManager.findFragmentById(R.id.map) as MapFragment\n        mapFragment.getMapAsync(this)\n    }\n\n    override fun onMapReady(googleMap: GoogleMap) {\n        // Map is ready to be used.\n        mMap = googleMap\n\n        // Inform user how to close app (Swipe-To-Close).\n        val duration = Toast.LENGTH_LONG\n        val toast = Toast.makeText(getApplicationContext(), R.string.intro_text, duration)\n        toast.setGravity(Gravity.CENTER, 0, 0)\n        toast.show()\n\n        // Adds a marker in Sydney, Australia and moves the camera.\n        val sydney = LatLng(-34.0, 151.0)\n        mMap.addMarker(MarkerOptions().position(sydney).title(\"Marker in Sydney\"))\n        mMap.moveCamera(CameraUpdateFactory.newLatLng(sydney))\n    }\n}\n";
    }
}

