/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.loginActivity.src.app_package.ui.login;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"loginActivityKt", "", "activityClass", "packageName", "useAndroidX", "", "studio.intellij.android.wizardTemplate.impl"})
public final class LoginActivityKtKt {
    @NotNull
    public static final String loginActivityKt(@NotNull String activityClass2, @NotNull String packageName, boolean useAndroidX) {
        Intrinsics.checkParameterIsNotNull((Object)activityClass2, (String)"activityClass");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        return "package " + TemplateHelpersKt.escapeKotlinIdentifier((String)packageName) + ".ui.login\n\nimport android.app.Activity\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.arch.lifecycle.Observer", (boolean)useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.arch.lifecycle.ViewModelProviders", (boolean)useAndroidX) + "\nimport android.os.Bundle\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.annotation.StringRes", (boolean)useAndroidX) + "\nimport " + TemplateHelpersKt.getMaterialComponentName((String)"android.support.v7.app.AppCompatActivity", (boolean)useAndroidX) + "\nimport android.text.Editable\nimport android.text.TextWatcher\nimport android.view.View\nimport android.view.inputmethod.EditorInfo\nimport android.widget.Button\nimport android.widget.EditText\nimport android.widget.ProgressBar\nimport android.widget.Toast\n\nimport " + TemplateHelpersKt.escapeKotlinIdentifier((String)packageName) + ".R\n\nclass " + activityClass2 + " : AppCompatActivity() {\n\n    private lateinit var loginViewModel: LoginViewModel\n\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n\n        setContentView(R.layout.activity_login)\n\n        val username = findViewById<EditText>(R.id.username)\n        val password = findViewById<EditText>(R.id.password)\n        val login = findViewById<Button>(R.id.login)\n        val loading = findViewById<ProgressBar>(R.id.loading)\n\n        loginViewModel = ViewModelProviders.of(this, LoginViewModelFactory())\n            .get(LoginViewModel::class.java)\n\n        loginViewModel.loginFormState.observe(this@LoginActivity, Observer {\n            val loginState = it ?: return@Observer\n\n            // disable login button unless both username / password is valid\n            login.isEnabled = loginState.isDataValid\n\n            if (loginState.usernameError != null) {\n                username.error = getString(loginState.usernameError)\n            }\n            if (loginState.passwordError != null) {\n               password.error = getString(loginState.passwordError)\n            }\n        })\n\n        loginViewModel.loginResult.observe(this@LoginActivity, Observer {\n            val loginResult = it ?: return@Observer\n\n            loading.visibility = View.GONE\n            if (loginResult.error != null) {\n                showLoginFailed(loginResult.error)\n            }\n            if (loginResult.success != null) {\n                updateUiWithUser(loginResult.success)\n            }\n            setResult(Activity.RESULT_OK)\n\n            //Complete and destroy login activity once successful\n            finish()\n        })\n\n        username.afterTextChanged {\n            loginViewModel.loginDataChanged(\n                username.text.toString(),\n                password.text.toString()\n            )\n        }\n\n        password.apply {\n            afterTextChanged {\n                loginViewModel.loginDataChanged(\n                    username.text.toString(),\n                    password.text.toString()\n                )\n            }\n\n            setOnEditorActionListener { _, actionId, _ ->\n                when (actionId) {\n                    EditorInfo.IME_ACTION_DONE ->\n                        loginViewModel.login(\n                            username.text.toString(),\n                            password.text.toString()\n                        )\n                }\n                false\n            }\n\n            login.setOnClickListener {\n                loading.visibility = View.VISIBLE\n                loginViewModel.login(username.text.toString(), password.text.toString())\n            }\n        }\n    }\n\n    private fun updateUiWithUser(model: LoggedInUserView) {\n        val welcome = getString(R.string.welcome)\n        val displayName = model.displayName\n        // TODO : initiate successful logged in experience\n        Toast.makeText(\n            applicationContext,\n            \"$welcome $displayName\",\n            Toast.LENGTH_LONG\n        ).show()\n    }\n\n    private fun showLoginFailed(@StringRes errorString: Int) {\n        Toast.makeText(applicationContext, errorString, Toast.LENGTH_SHORT).show()\n    }\n}\n\n/**\n * Extension function to simplify setting an afterTextChanged action to EditText components.\n */\nfun EditText.afterTextChanged(afterTextChanged: (String) -> Unit) {\n    this.addTextChangedListener(object : TextWatcher {\n        override fun afterTextChanged(editable: Editable?) {\n            afterTextChanged.invoke(editable.toString())\n        }\n\n        override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}\n\n        override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {}\n    })\n}\n";
    }
}

