/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class SelectionSaver
implements TreeSelectionListener,
TreeModelListener,
PropertyChangeListener {
    private final JTree myTree;
    private Collection<TreeNode> myCurrentSelection = new ArrayList<TreeNode>();

    private SelectionSaver(JTree tree) {
        this.myTree = tree;
    }

    public static void installOn(JTree tree) {
        new SelectionSaver(tree).install();
    }

    private void install() {
        this.myTree.getModel().addTreeModelListener(this);
        this.myTree.getSelectionModel().addTreeSelectionListener(this);
        this.myTree.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model")) {
            ((TreeModel)evt.getOldValue()).removeTreeModelListener(this);
            ((TreeModel)evt.getNewValue()).addTreeModelListener(this);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        Object[] children;
        TreePath pathToDelete = treeModelEvent.getTreePath();
        for (Object nodeToDelete : children = treeModelEvent.getChildren()) {
            if (!this.myCurrentSelection.contains(nodeToDelete)) continue;
            int deletedRow = this.myTree.getRowForPath(pathToDelete.pathByAddingChild(nodeToDelete));
            if (deletedRow == 0) {
                return;
            }
            TreePath treePath = new TreePath(this.myTree.getPathForRow(deletedRow - 1));
            this.myTree.getSelectionModel().addSelectionPath((TreePath)treePath.getLastPathComponent());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.myCurrentSelection = new ArrayList<TreeNode>();
        TreePath[] selection = this.myTree.getSelectionModel().getSelectionPaths();
        if (selection == null) {
            return;
        }
        for (TreePath treePath : selection) {
            this.myCurrentSelection.add((TreeNode)treePath.getLastPathComponent());
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }
}

