/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.prompts;

import java.util.List;
import net.rubygrapefruit.platform.prompts.AbstractPrompter;
import net.rubygrapefruit.platform.prompts.Prompter;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.TerminalInputListener;
import net.rubygrapefruit.platform.terminal.TerminalOutput;
import net.rubygrapefruit.platform.terminal.Terminals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlainPrompter
extends AbstractPrompter {
    private final TerminalOutput output;
    private final TerminalInput input;

    PlainPrompter(Terminals terminals) {
        this.output = terminals.getTerminal(Terminals.Output.Stdout);
        this.input = terminals.getTerminalInput();
    }

    @Override
    boolean isInteractive() {
        return true;
    }

    @Override
    Integer select(String prompt, List<String> options, int defaultOption) {
        char ch;
        int index;
        String result2;
        this.output.newline();
        this.output.bold().write(prompt).write(":").normal().newline();
        for (int i = 0; i < options.size(); ++i) {
            if (i == defaultOption) {
                this.output.foreground(Prompter.SELECTION_COLOR).write(">").defaultForeground().write(" ");
            } else {
                this.output.write("  ");
            }
            this.output.write(String.valueOf(i + 1)).write(") ").write(options.get(i));
            if (i == defaultOption) {
                this.output.foreground(Prompter.SELECTION_COLOR).write(" (default)").defaultForeground();
            }
            this.output.newline();
        }
        do {
            this.output.write("Please select an option (1..").write(String.valueOf(options.size())).write(") [").write(String.valueOf(defaultOption + 1)).write("] ");
            CollectingListener listener2 = new CollectingListener();
            while (listener2.result == 0) {
                this.input.read(listener2);
            }
            if (listener2.result == 2) {
                return null;
            }
            result2 = listener2.chars.toString().trim();
            if (result2.length() != 0) continue;
            return defaultOption;
        } while (result2.length() != 1 || !Character.isDigit(result2.charAt(0)) || (index = (ch = result2.charAt(0)) - 48 - 1) < 0 || index >= options.size());
        return index;
    }

    @Override
    String enterText(String prompt, String defaultValue) {
        this.output.newline();
        this.output.bold().write(prompt).normal();
        this.output.write(" [").write(defaultValue).write("]: ");
        CollectingListener listener2 = new CollectingListener();
        while (listener2.result == 0) {
            this.input.read(listener2);
        }
        if (listener2.result == 2) {
            return null;
        }
        String result2 = listener2.chars.toString().trim();
        if (result2.length() == 0) {
            return defaultValue;
        }
        return result2;
    }

    @Override
    Boolean askYesNo(String prompt, boolean defaultValue) {
        String result2;
        this.output.newline();
        do {
            this.output.bold().write(prompt).normal();
            this.output.write("(y/n) [").write(defaultValue ? "y" : "n").write("]: ");
            CollectingListener listener2 = new CollectingListener();
            while (listener2.result == 0) {
                this.input.read(listener2);
            }
            if (listener2.result == 2) {
                return null;
            }
            result2 = listener2.chars.toString().trim().toLowerCase();
            if (result2.length() == 0) {
                return defaultValue;
            }
            if (!result2.equals("y") && !result2.equals("yes")) continue;
            return true;
        } while (!result2.equals("n") && !result2.equals("no"));
        return false;
    }

    private static class CollectingListener
    implements TerminalInputListener {
        int result = 0;
        final StringBuilder chars = new StringBuilder();

        private CollectingListener() {
        }

        public void character(char ch) {
            this.chars.append(ch);
        }

        public void controlKey(TerminalInputListener.Key key) {
            if (key == TerminalInputListener.Key.Enter) {
                this.result = 1;
            }
        }

        public void endInput() {
            this.result = 2;
        }
    }
}

