/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleVersionIdentifier;

public class ResolvedConfigurationIdentifier {
    private final ModuleVersionIdentifier id;
    private final String configuration;

    public ResolvedConfigurationIdentifier(ModuleVersionIdentifier moduleVersionIdentifier, String configuration2) {
        this.id = moduleVersionIdentifier;
        this.configuration = configuration2;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getModuleGroup() {
        return this.id.getGroup();
    }

    public String getModuleName() {
        return this.id.getName();
    }

    public String getModuleVersion() {
        return this.id.getVersion();
    }

    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    public String toString() {
        return String.format("%s:%s:%s:%s", this.getModuleGroup(), this.getModuleName(), this.getModuleVersion(), this.configuration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedConfigurationIdentifier that = (ResolvedConfigurationIdentifier)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.configuration.equals(that.configuration);
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.configuration.hashCode();
    }
}

