/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.antbuilder;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.project.antbuilder.CachedClassLoader;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classpath.ClassPath;

class Cleanup
extends PhantomReference<CachedClassLoader> {
    private final ClassPath key;
    private final ClassLoader classLoader;
    private final GroovySystemLoader groovySystemForClassLoader;
    private final GroovySystemLoader gradleApiGroovyLoader;
    private final GroovySystemLoader antBuilderGroovyLoader;

    Cleanup(ClassPath classPath, CachedClassLoader cachedClassLoader, ReferenceQueue<CachedClassLoader> referenceQueue, ClassLoader classLoader, GroovySystemLoader groovySystemForClassLoader, GroovySystemLoader gradleApiGroovyLoader, GroovySystemLoader antBuilderGroovyLoader) {
        super(cachedClassLoader, referenceQueue);
        this.groovySystemForClassLoader = groovySystemForClassLoader;
        this.gradleApiGroovyLoader = gradleApiGroovyLoader;
        this.antBuilderGroovyLoader = antBuilderGroovyLoader;
        this.key = classPath;
        this.classLoader = classLoader;
    }

    ClassPath getKey() {
        return this.key;
    }

    void cleanup(Mode mode) {
        this.groovySystemForClassLoader.shutdown();
        this.gradleApiGroovyLoader.discardTypesFrom(this.classLoader);
        this.antBuilderGroovyLoader.discardTypesFrom(this.classLoader);
        if (mode == Mode.CLOSE_CLASSLOADER) {
            ClassLoaderUtils.tryClose(this.classLoader);
        }
    }

    static enum Mode {
        DONT_CLOSE_CLASSLOADER,
        CLOSE_CLASSLOADER;

    }
}

