/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.util.Path;

public interface TaskDetails {
    public Path getPath();

    @Nullable
    public String getDescription();

    public String getTypeName();

    public static TaskDetails of(Path path, Task task) {
        return TaskDetails.of(path, new DslObject(task).getPublicType().getFullyQualifiedName(), task.getDescription());
    }

    public static TaskDetails of(Path path, String typeName, @Nullable String description) {
        return new DefaultTaskDetails(path, typeName, description);
    }

    public static final class DefaultTaskDetails
    implements TaskDetails {
        private final Path path;
        private final String typeName;
        @Nullable
        private final String description;

        private DefaultTaskDetails(Path path, String typeName, @Nullable String description) {
            this.path = path;
            this.typeName = typeName;
            this.description = description;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }
    }
}

