/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.io.Closeable;
import java.util.function.Function;
import org.gradle.internal.buildtree.BuildTreeContext;
import org.gradle.internal.buildtree.BuildTreeModelControllerServices;
import org.gradle.internal.buildtree.BuildTreeScopeServices;
import org.gradle.internal.buildtree.DefaultBuildTreeContext;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
public class BuildTreeState
implements Closeable {
    private final ServiceRegistry services;
    private final DefaultBuildTreeContext context;

    public BuildTreeState(ServiceRegistry parent, BuildTreeModelControllerServices.Supplier modelServices) {
        this.services = ServiceRegistryBuilder.builder().displayName("build tree services").parent(parent).provider(new BuildTreeScopeServices(this, modelServices)).build();
        this.context = new DefaultBuildTreeContext(this.services);
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public <T> T run(Function<? super BuildTreeContext, T> action) {
        return action.apply(this.context);
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.services).stop();
    }
}

