/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationInvocationException;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceWriteBuildOperationType;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transfer.ResourceOperation;

public class ProgressLoggingExternalResourceUploader
extends AbstractProgressLoggingHandler
implements ExternalResourceUploader {
    private final ExternalResourceUploader delegate;
    private final BuildOperationExecutor buildOperationExecutor;

    public ProgressLoggingExternalResourceUploader(ExternalResourceUploader delegate, BuildOperationExecutor buildOperationExecutor) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void upload(ReadableContent resource, ExternalResourceName destination) throws IOException {
        try {
            this.buildOperationExecutor.run(new UploadOperation(destination, resource));
        }
        catch (BuildOperationInvocationException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    private class UploadOperation
    implements RunnableBuildOperation {
        private final ExternalResourceName destination;
        private final ReadableContent resource;

        public UploadOperation(ExternalResourceName destination, ReadableContent resource) {
            this.destination = destination;
            this.resource = resource;
        }

        @Override
        public void run(BuildOperationContext context) throws IOException {
            ResourceOperation uploadOperation = ProgressLoggingExternalResourceUploader.this.createResourceOperation(context, ResourceOperation.Type.upload);
            uploadOperation.setContentLength(this.resource.getContentLength());
            try {
                ProgressLoggingExternalResourceUploader.this.delegate.upload(new ProgressLoggingReadableContent(this.resource, uploadOperation), this.destination);
                context.setResult(new ExternalResourceWriteBuildOperationType.Result(uploadOperation){
                    final /* synthetic */ ResourceOperation val$uploadOperation;
                    {
                        this.val$uploadOperation = resourceOperation;
                    }

                    @Override
                    public long getBytesWritten() {
                        return this.val$uploadOperation.getTotalProcessedBytes();
                    }
                });
            }
            catch (Throwable throwable) {
                context.setResult(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Upload " + this.destination.getUri()).progressDisplayName(this.destination.getShortDisplayName()).details(new PutOperationDetails(this.destination.getUri()));
        }
    }

    private static class PutOperationDetails
    extends AbstractProgressLoggingHandler.LocationDetails
    implements ExternalResourceWriteBuildOperationType.Details {
        private PutOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceWriteBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }

    private static class ProgressLoggingReadableContent
    implements ReadableContent {
        private final ReadableContent delegate;
        private final ResourceOperation uploadOperation;

        private ProgressLoggingReadableContent(ReadableContent delegate, ResourceOperation uploadOperation) {
            this.delegate = delegate;
            this.uploadOperation = uploadOperation;
        }

        @Override
        public InputStream open() {
            return new AbstractProgressLoggingHandler.ProgressLoggingInputStream(this.delegate.open(), this.uploadOperation);
        }

        @Override
        public long getContentLength() {
            return this.delegate.getContentLength();
        }
    }
}

