/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.PluginDescriptorLocator;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedGradleEnterprisePlugin;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.ClassPathPluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.tracker.internal.PluginVersionTracker;

public class AlreadyOnClasspathPluginResolver
implements PluginResolver {
    private final PluginResolver delegate;
    private final PluginRegistry corePluginRegistry;
    private final PluginDescriptorLocator pluginDescriptorLocator;
    private final ClassLoaderScope parentLoaderScope;
    private final PluginInspector pluginInspector;
    private final PluginVersionTracker pluginVersionTracker;

    public AlreadyOnClasspathPluginResolver(PluginResolver delegate, PluginRegistry corePluginRegistry, ClassLoaderScope parentLoaderScope, PluginDescriptorLocator pluginDescriptorLocator, PluginInspector pluginInspector, PluginVersionTracker pluginVersionTracker) {
        this.delegate = delegate;
        this.corePluginRegistry = corePluginRegistry;
        this.pluginDescriptorLocator = pluginDescriptorLocator;
        this.parentLoaderScope = parentLoaderScope;
        this.pluginInspector = pluginInspector;
        this.pluginVersionTracker = pluginVersionTracker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resolve(PluginRequestInternal pluginRequest, PluginResolutionResult result2) {
        PluginId pluginId = pluginRequest.getId();
        if (this.isCorePlugin(pluginId) || !this.isPresentOnClasspath(pluginId)) {
            this.delegate.resolve(pluginRequest, result2);
            return;
        } else if (pluginRequest.getOriginalRequest().getVersion() != null) {
            if (pluginRequest.getId().equals(AutoAppliedGradleEnterprisePlugin.BUILD_SCAN_PLUGIN_ID) && this.isPresentOnClasspath(AutoAppliedGradleEnterprisePlugin.ID)) {
                throw new InvalidPluginRequestException(pluginRequest, "The build scan plugin is not compatible with this version of Gradle.\nPlease see https://gradle.com/help/gradle-6-build-scan-plugin for more information.");
            }
            String existingVersion = this.pluginVersionTracker.findPluginVersionAt(this.parentLoaderScope, pluginId.getId());
            if (existingVersion == null) throw new InvalidPluginRequestException(pluginRequest, "The request for this plugin could not be satisfied because the plugin is already on the classpath with an unknown version, so compatibility cannot be checked.");
            if (!existingVersion.equals(pluginRequest.getOriginalRequest().getVersion())) throw new InvalidPluginRequestException(pluginRequest, "The request for this plugin could not be satisfied because the plugin is already on the classpath with a different version (" + existingVersion + ").");
            this.resolveAlreadyOnClasspath(pluginId, existingVersion, result2);
            return;
        } else {
            this.resolveAlreadyOnClasspath(pluginId, null, result2);
        }
    }

    private void resolveAlreadyOnClasspath(PluginId pluginId, String pluginVersion, PluginResolutionResult result2) {
        ClassPathPluginResolution pluginResolution = new ClassPathPluginResolution(pluginId, pluginVersion, this.parentLoaderScope, this.pluginInspector);
        result2.found("Already on classpath", pluginResolution);
    }

    private boolean isPresentOnClasspath(PluginId pluginId) {
        return this.pluginDescriptorLocator.findPluginDescriptor(pluginId.toString()) != null;
    }

    private boolean isCorePlugin(PluginId pluginId) {
        return this.corePluginRegistry.lookup(pluginId) != null;
    }
}

