/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalCommandHandlerCustomizer;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;

public final class TerminalToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NonNls
    public static final String TOOL_WINDOW_ID = "Terminal";

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            TerminalToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            TerminalToolWindowFactory.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        TerminalView terminalView = TerminalView.getInstance(project);
        terminalView.initToolWindow((ToolWindowEx)toolWindow);
        final TerminalCommandHandlerCustomizer.TerminalCommandHandlerOptions options = new TerminalCommandHandlerCustomizer.TerminalCommandHandlerOptions(project);
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new DumbAwareToggleAction(TerminalBundle.message("settings.terminal.smart.command.handling", new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options.getEnabled();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                options.setEnabled(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowFactory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }}));
        TerminalArrangementManager terminalArrangementManager = TerminalArrangementManager.getInstance(project);
        terminalView.restoreTabs(terminalArrangementManager.getArrangementState());
        terminalArrangementManager.setToolWindow(toolWindow);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "toolWindow";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowFactory";
        objectArray[2] = "createToolWindowContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

