/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.configurations.ConfigurationsModel;
import com.android.tools.idea.gradle.dsl.api.crashlytics.CrashlyticsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.util.GradleDslModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleBlockModelMap;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.PluginModelImpl;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslInfixExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleBuildModelImpl
extends GradleFileModelImpl
implements GradleBuildModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NonNls
    private static final String ID = "id";
    @NonNls
    private static final String VERSION = "version";
    @NonNls
    private static final String APPLY = "apply";

    public GradleBuildModelImpl(@NotNull GradleBuildFile buildDslFile) {
        if (buildDslFile == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(0);
        }
        super(buildDslFile);
    }

    @Override
    @NotNull
    public List<PluginModel> plugins() {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ArrayList<PluginModelImpl> plugins = new ArrayList<PluginModelImpl>();
        if (pluginsDslElement != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement)).values());
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement(APPLY, ApplyDslElement.class)) != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement)).values());
        }
        return new ArrayList<PluginModel>(PluginModelImpl.deduplicatePlugins(plugins).values());
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin) {
        Map<String, PluginModelImpl> applyPluginsModels;
        if (plugin == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(1);
        }
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement(APPLY, ApplyDslElement.class);
        if (pluginsDslElement == null && applyDslElement == null) {
            int at = 0;
            List<GradleDslElement> elements = this.myGradleDslFile.getCurrentElements();
            if (elements.size() > 0 && elements.get(0) instanceof BuildScriptDslElement) {
                ++at;
            }
            pluginsDslElement = this.myGradleDslFile.ensurePropertyElementAt(PluginsDslElement.PLUGINS, at);
        } else if (pluginsDslElement == null) {
            Map<String, PluginModelImpl> models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement));
            if (models.containsKey(plugin)) {
                PluginModel pluginModel = models.get(plugin);
                if (pluginModel == null) {
                    GradleBuildModelImpl.$$$reportNull$$$0(2);
                }
                return pluginModel;
            }
            GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, GradleNameElement.create(APPLY));
            applyMap.setAsNamedArgs(true);
            GradleDslLiteral literal = new GradleDslLiteral(applyMap, GradleNameElement.create(PLUGIN));
            literal.setValue(plugin.trim());
            applyMap.setNewElement(literal);
            applyDslElement.setNewElement(applyMap);
            return new PluginModelImpl(applyMap, literal);
        }
        Map<String, PluginModelImpl> models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement));
        if (models.containsKey(plugin)) {
            PluginModel pluginModel = models.get(plugin);
            if (pluginModel == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(3);
            }
            return pluginModel;
        }
        if (applyDslElement != null && (applyPluginsModels = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement))).containsKey(plugin)) {
            PluginModel pluginModel = applyPluginsModels.get(plugin);
            if (pluginModel == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(4);
            }
            return pluginModel;
        }
        GradleDslLiteral literal = new GradleDslLiteral(pluginsDslElement, GradleNameElement.create(ID));
        literal.setElementType(PropertyType.REGULAR);
        literal.setValue(plugin.trim());
        pluginsDslElement.setNewElement(literal);
        return new PluginModelImpl(literal, literal);
    }

    @Override
    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin, @NotNull String version, boolean apply) {
        if (plugin == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(5);
        }
        if (version == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(6);
        }
        int at = 0;
        List<GradleDslElement> elements = this.myGradleDslFile.getCurrentElements();
        if (elements.size() > 0 && elements.get(0) instanceof BuildScriptDslElement) {
            ++at;
        }
        PluginsDslElement pluginsElement = this.myGradleDslFile.ensurePropertyElementAt(PluginsDslElement.PLUGINS, at);
        GradleDslInfixExpression expression = new GradleDslInfixExpression(pluginsElement, null);
        GradleDslLiteral idLiteral = expression.setNewLiteral(ID, plugin);
        expression.setNewLiteral(VERSION, version);
        expression.setNewLiteral(APPLY, apply);
        pluginsElement.setNewElement(expression);
        return new PluginModelImpl(expression, idLiteral);
    }

    @Override
    public void removePlugin(@NotNull String plugin) {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement;
        if (plugin == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(7);
        }
        if ((pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS)) != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(pluginsDslElement), plugin);
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement(APPLY, ApplyDslElement.class)) != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(applyDslElement), plugin);
        }
    }

    @Override
    @Nullable
    public PsiElement getPluginsPsiElement() {
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        if (pluginsDslElement != null) {
            return pluginsDslElement.getPsiElement();
        }
        return null;
    }

    @Override
    @NotNull
    public AndroidModel android() {
        AndroidModel androidModel = this.getModel(AndroidModel.class);
        if (androidModel == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(8);
        }
        return androidModel;
    }

    @Override
    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptModel buildScriptModel = this.getModel(BuildScriptModel.class);
        if (buildScriptModel == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(9);
        }
        return buildScriptModel;
    }

    @Override
    @NotNull
    public ConfigurationsModel configurations() {
        ConfigurationsModel configurationsModel = this.getModel(ConfigurationsModel.class);
        if (configurationsModel == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(10);
        }
        return configurationsModel;
    }

    @Override
    @NotNull
    public CrashlyticsModel crashlytics() {
        CrashlyticsModel crashlyticsModel = this.getModel(CrashlyticsModel.class);
        if (crashlyticsModel == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(11);
        }
        return crashlyticsModel;
    }

    @Override
    @NotNull
    public DependenciesModel dependencies() {
        DependenciesModel dependenciesModel = this.getModel(DependenciesModel.class);
        if (dependenciesModel == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(12);
        }
        return dependenciesModel;
    }

    @Override
    @NotNull
    public ExtModel ext() {
        ExtModel extModel = this.getModel(ExtModel.class);
        if (extModel == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(13);
        }
        return extModel;
    }

    @Override
    @NotNull
    public JavaModel java() {
        JavaModel javaModel = this.getModel(JavaModel.class);
        if (javaModel == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(14);
        }
        return javaModel;
    }

    @Override
    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesModel repositoriesModel = this.getModel(RepositoriesModel.class);
        if (repositoriesModel == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(15);
        }
        return repositoriesModel;
    }

    @Override
    @NotNull
    public <T extends GradleDslModel> T getModel(Class<T> klass) {
        T t = GradleBlockModelMap.get(this.myGradleDslFile, GradleBuildModel.class, klass);
        if (t == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(16);
        }
        return t;
    }

    @Override
    @NotNull
    public Set<GradleFileModel> getInvolvedFiles() {
        Set<GradleFileModel> set = this.getAllInvolvedFiles().stream().distinct().map(e -> GradleBuildModelImpl.getFileModel(e)).collect(Collectors.toSet());
        if (set == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    private static GradleFileModel getFileModel(@NotNull GradleDslFile file) {
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(18);
        }
        if (file instanceof GradleBuildFile) {
            return new GradleBuildModelImpl((GradleBuildFile)file);
        }
        if (file instanceof GradleSettingsFile) {
            return new GradleSettingsModelImpl((GradleSettingsFile)file);
        }
        if (file instanceof GradlePropertiesFile) {
            return new GradlePropertiesModel(file);
        }
        throw new IllegalStateException("Unknown GradleDslFile type found!");
    }

    @Override
    @NotNull
    public File getModuleRootDirectory() {
        BuildModelContext context = this.myGradleDslFile.getContext();
        VirtualFile projectSettingsFile = context.getProjectSettingsFile();
        if (projectSettingsFile == null) {
            File file = this.myGradleDslFile.getDirectoryPath();
            if (file == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(19);
            }
            return file;
        }
        GradleSettingsFile settingsFile = context.getOrCreateSettingsFile(projectSettingsFile);
        GradleSettingsModelImpl settingsModel = new GradleSettingsModelImpl(settingsFile);
        File directory = settingsModel.moduleDirectory(this.myGradleDslFile.getName());
        if (directory == null) {
            File file = this.myGradleDslFile.getDirectoryPath();
            if (file == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(20);
            }
            return file;
        }
        File file = directory;
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(21);
        }
        return file;
    }

    @Override
    @TestOnly
    public void removeRepositoriesBlocks() {
        this.myGradleDslFile.removeProperty(RepositoriesDslElement.REPOSITORIES.name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = PLUGIN;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModelImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = VERSION;
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModelImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPlugin";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "android";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildscript";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "configurations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "crashlytics";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "dependencies";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "ext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "java";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "repositories";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvolvedFiles";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRootDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyPlugin";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removePlugin";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFileModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

