/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import java.awt.Color;
import java.awt.Point;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.XPathBundle;
import org.intellij.plugins.xpathView.util.HighlighterUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XPathView.XPathViewPlugin", storages={@Storage(value="xpath.xml")}, category=SettingsCategory.CODE)
public final class XPathAppComponent
implements PersistentStateComponent<Config> {
    private Config configuration = new Config();

    @Nullable
    public Config getState() {
        return this.configuration;
    }

    public void loadState(@NotNull Config state) {
        if (state == null) {
            XPathAppComponent.$$$reportNull$$$0(0);
        }
        this.configuration = state;
    }

    @NotNull
    public Config getConfig() {
        Config config = this.configuration;
        if (config == null) {
            XPathAppComponent.$$$reportNull$$$0(1);
        }
        return config;
    }

    public void setConfig(@NotNull Config configuration) {
        if (configuration == null) {
            XPathAppComponent.$$$reportNull$$$0(2);
        }
        this.configuration = configuration;
    }

    public static XPathAppComponent getInstance() {
        return (XPathAppComponent)ApplicationManager.getApplication().getService(XPathAppComponent.class);
    }

    public static void showEditorHint(@NlsContexts.HintText String info, Editor editor) {
        JLabel label = new JLabel(info);
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, (Color)JBColor.WHITE, (Color)Gray._128), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
        label.setForeground(JBColor.foreground());
        label.setBackground(HintUtil.getInformationColor());
        label.setOpaque(true);
        label.setFont(label.getFont().deriveFont(1));
        LightweightHint h = new LightweightHint((JComponent)label);
        Point point = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
        SwingUtilities.convertPointToScreen(point, editor.getContentComponent());
        int flags = 34;
        HintManagerImpl.getInstanceImpl().showEditorHint(h, editor, point, 34, 0, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/xpathView/XPathAppComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/xpathView/XPathAppComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FindPreviousHandler
    extends MyFindHandler {
        public FindPreviousHandler(EditorActionHandler origHandler) {
            super(origHandler, true);
        }
    }

    public static class FindNextHandler
    extends MyFindHandler {
        public FindNextHandler(EditorActionHandler origHandler) {
            super(origHandler, false);
        }
    }

    static class MyFindHandler
    extends EditorActionHandler {
        private final EditorActionHandler origHandler;
        private final boolean isPrev;
        private boolean wrapAround;

        MyFindHandler(EditorActionHandler origHandler, boolean isPrev) {
            this.origHandler = origHandler;
            this.isPrev = isPrev;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                MyFindHandler.$$$reportNull$$$0(0);
            }
            if (HighlighterUtil.hasHighlighters(editor)) {
                int startOffset;
                int offset = editor.getCaretModel().getOffset();
                List<RangeHighlighter> hl = HighlighterUtil.getHighlighters(editor);
                int diff = Integer.MAX_VALUE;
                RangeHighlighter next = null;
                for (RangeHighlighter highlighter : hl) {
                    if (this.isPrev) {
                        if (highlighter.getStartOffset() >= offset || offset - highlighter.getStartOffset() >= diff) continue;
                        diff = offset - highlighter.getStartOffset();
                        next = highlighter;
                        continue;
                    }
                    if (highlighter.getStartOffset() <= offset || highlighter.getStartOffset() - offset >= diff) continue;
                    diff = highlighter.getStartOffset() - offset;
                    next = highlighter;
                }
                if (next != null) {
                    startOffset = next.getStartOffset();
                } else if (this.wrapAround) {
                    startOffset = hl.get(this.isPrev ? hl.size() - 1 : 0).getStartOffset();
                } else {
                    String info = XPathBundle.message("hint.text.choice.first.last.xpath.match.reached.press.to.search.from.choice.bottom.top", this.isPrev ? 0 : 1, this.isPrev ? KeymapUtil.getShortcutText((String)"FindPrevious") : KeymapUtil.getShortcutText((String)"FindNext"), this.isPrev ? 0 : 1);
                    XPathAppComponent.showEditorHint(info, editor);
                    this.wrapAround = true;
                    return;
                }
                editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(startOffset), ScrollType.MAKE_VISIBLE);
                editor.getCaretModel().moveToOffset(startOffset);
                this.wrapAround = false;
                return;
            }
            this.origHandler.execute(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/xpathView/XPathAppComponent$MyFindHandler", "doExecute"));
        }
    }
}

